/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.SetHeaderFooterParameters;
import org.sejda.model.pdf.TextStampPattern;
import org.sejda.model.pdf.UnicodeType0Font;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType0Font;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfHeaderFooterWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PdfHeaderFooterWriter.class);
    private static final Float DEFAULT_MARGIN = Float.valueOf(30.0f);
    private PDDocumentHandler documentHandler;
    private int totalPages;

    public PdfHeaderFooterWriter(PDDocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
        this.totalPages = documentHandler.getNumberOfPages();
    }

    public void write(SetHeaderFooterParameters parameters, int currentFileCounter) throws TaskIOException {
        PDFont font = ObjectUtils.defaultIfNull(FontUtils.getStandardType1Font(parameters.getFont()), PDType1Font.HELVETICA);
        Double fontSize = ObjectUtils.defaultIfNull(parameters.getFontSize(), 10.0);
        HorizontalAlign hAlign = ObjectUtils.defaultIfNull(parameters.getHorizontalAlign(), HorizontalAlign.CENTER);
        VerticalAlign vAlign = ObjectUtils.defaultIfNull(parameters.getVerticalAlign(), VerticalAlign.BOTTOM);
        String what = vAlign == VerticalAlign.BOTTOM ? "footer" : "header";
        Set pages = parameters.getPageRange().getPages(this.documentHandler.getNumberOfPages());
        Integer labelPageNumber = parameters.getPageCountStartFrom();
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            int pageNumber = (Integer)iterator.next();
            if (labelPageNumber == null) {
                labelPageNumber = pageNumber;
            }
            String batesSeq = null;
            if (parameters.getBatesSequence() != null) {
                batesSeq = parameters.getBatesSequence().next();
            }
            String label = new TextStampPattern().withPage(labelPageNumber, this.totalPages).withBatesSequence(batesSeq).withFileSequence(String.valueOf(currentFileCounter)).build(parameters.getPattern());
            font = this.fontOrFallback(label, font, this.loadFont(UnicodeType0Font.NOTO_SANS_REGULAR));
            LOG.debug("Applying {} '{}' to document page {}", what, label, pageNumber);
            PDPage page = this.documentHandler.getPage(pageNumber);
            PDRectangle pageSize = page.getCropBox();
            try {
                float stringWidth = font.getStringWidth(label) * fontSize.floatValue() / 1000.0f;
                float xPosition = hAlign.position(pageSize.getWidth(), stringWidth, DEFAULT_MARGIN.floatValue());
                float yPosition = vAlign.position(pageSize.getHeight(), DEFAULT_MARGIN.floatValue());
                PDPageContentStream contentStream = new PDPageContentStream(this.documentHandler.getUnderlyingPDDocument(), page, true, true);
                contentStream.beginText();
                contentStream.setFont(font, fontSize.floatValue());
                contentStream.setNonStrokingColor(parameters.getColor());
                contentStream.newLineAtOffset(xPosition, yPosition);
                contentStream.showText(label);
                contentStream.endText();
                contentStream.close();
            }
            catch (IOException e) {
                throw new TaskIOException("An error occurred writing the header or footer of the page.", e);
            }
            Integer n = labelPageNumber;
            Integer n2 = labelPageNumber = Integer.valueOf(labelPageNumber + 1);
        }
    }

    private PDFont fontOrFallback(String text, PDFont font, PDFont fallback) {
        if (fallback == null) {
            return font;
        }
        try {
            font.getStringWidth(text);
            return font;
        }
        catch (IOException | IllegalArgumentException ex) {
            LOG.debug("Label cannot be written with font {}, will fallback to font {}", (Object)font.getName(), (Object)fallback.getName());
            return fallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFont loadFont(UnicodeType0Font font) {
        InputStream in = font.getResourceStream();
        try {
            PDType0Font pDType0Font = PDType0Font.load(this.documentHandler.getUnderlyingPDDocument(), in);
            return pDType0Font;
        }
        catch (IOException e) {
            LOG.warn("Failed to load font " + (Object)((Object)font), e);
            PDFont pDFont = null;
            return pDFont;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.documentHandler);
    }
}

