/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.io.IOException;
import java.util.function.Supplier;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.PagesExtractor;
import org.sejda.impl.sambox.component.split.AbstractPdfSplitter;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.SplitBySizeParameters;
import org.sejda.model.split.NextOutputStrategy;
import org.sejda.sambox.output.ExistingPagesSizePredictor;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.util.IOUtils;

public class SizePdfSplitter
extends AbstractPdfSplitter<SplitBySizeParameters> {
    private static final WriteOption[] COMPRESSED_OPTS = new WriteOption[]{WriteOption.COMPRESS_STREAMS, WriteOption.XREF_STREAM};
    private static final int PDF_HEADER_SIZE = 15;
    private static final int ID_VALUE_SIZE = 70;
    private static final int PAGE_OVERHEAD = 10;
    private OutputSizeStrategy nextOutputStrategy;

    public SizePdfSplitter(PDDocument document, SplitBySizeParameters parameters) {
        super(document, parameters);
        this.nextOutputStrategy = parameters.isCompress() ? new OutputSizeStrategy(document, parameters, () -> new ExistingPagesSizePredictor(WriteOption.COMPRESS_STREAMS, WriteOption.XREF_STREAM)) : new OutputSizeStrategy(document, parameters);
    }

    @Override
    NameGenerationRequest enrichNameGenerationRequest(NameGenerationRequest request) {
        return request;
    }

    @Override
    NextOutputStrategy nextOutputStrategy() {
        return this.nextOutputStrategy;
    }

    @Override
    protected void onOpen(int page) throws TaskIOException {
        this.nextOutputStrategy.newPredictor();
        this.nextOutputStrategy.addPage(page);
    }

    @Override
    protected void onRetain(int page) throws TaskIOException {
        this.nextOutputStrategy.addPage(page + 1);
    }

    @Override
    protected void onClose(int page) {
        this.nextOutputStrategy.closePredictor();
    }

    @Override
    protected PagesExtractor supplyPagesExtractor(PDDocument document) {
        return new PagesExtractor(document){

            @Override
            public void setCompress(boolean compress) {
                if (compress) {
                    this.destinationDocument().addWriteOption(COMPRESSED_OPTS);
                } else {
                    this.destinationDocument().removeWriteOption(COMPRESSED_OPTS);
                }
            }
        };
    }

    static class OutputSizeStrategy
    implements NextOutputStrategy {
        private long sizeLimit;
        private PDDocument document;
        private ExistingPagesSizePredictor predictor;
        private Supplier<ExistingPagesSizePredictor> predictorSupplier = () -> new ExistingPagesSizePredictor(new WriteOption[0]);

        OutputSizeStrategy(PDDocument document, SplitBySizeParameters parameters) {
            this.sizeLimit = parameters.getSizeToSplitAt();
            this.document = document;
        }

        OutputSizeStrategy(PDDocument document, SplitBySizeParameters parameters, Supplier<ExistingPagesSizePredictor> predictorSupplier) {
            this(document, parameters);
            this.predictorSupplier = predictorSupplier;
        }

        public void newPredictor() throws TaskIOException {
            try {
                this.predictor = this.predictorSupplier.get();
                this.predictor.addIndirectReferenceFor(this.document.getDocumentInformation());
                this.predictor.addIndirectReferenceFor(this.document.getDocumentCatalog().getViewerPreferences());
            }
            catch (IOException e) {
                throw new TaskIOException("Unable to initialize the pages size predictor", e);
            }
        }

        public void addPage(int page) throws TaskIOException {
            try {
                if (page <= this.document.getNumberOfPages()) {
                    this.predictor.addPage(this.document.getPage(page - 1));
                }
            }
            catch (IOException e) {
                throw new TaskIOException("Unable to simulate page " + page + " addition", e);
            }
        }

        public void closePredictor() {
            IOUtils.closeQuietly(this.predictor);
            this.predictor = null;
        }

        @Override
        public void ensureIsValid() throws TaskExecutionException {
            if (this.sizeLimit < 1L) {
                throw new TaskExecutionException(String.format("Unable to split at %d, a positive size is required.", this.sizeLimit));
            }
        }

        @Override
        public boolean isOpening(Integer page) {
            return this.predictor == null || !this.predictor.hasPages();
        }

        @Override
        public boolean isClosing(Integer page) throws TaskIOException {
            try {
                long currentPageSize = this.predictor.predictedPagesSize();
                return 85L + currentPageSize + this.predictor.predictedXrefTableSize() + (long)this.documentFooterSize(currentPageSize) + this.predictor.pages() * 10L > this.sizeLimit;
            }
            catch (IOException e) {
                throw new TaskIOException("Unable to simulate page " + page + " addition", e);
            }
        }

        private int documentFooterSize(long documentSize) {
            return 17 + Long.toString(documentSize).length();
        }
    }
}

