/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Optional;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceView;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;

public class FileChannelSeekableSource
extends BaseSeekableSource {
    private FileChannel channel;
    private File file;
    private long size;

    public FileChannelSeekableSource(File file) throws IOException {
        super(Optional.ofNullable(file).map(File::getAbsolutePath).orElseThrow(() -> new IllegalArgumentException("Input file cannot be null")));
        this.channel = new RandomAccessFile(file, "r").getChannel();
        this.size = this.channel.size();
        this.file = file;
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public SeekableSource position(long newPosition) throws IOException {
        RequireUtils.requireArg(newPosition >= 0L, "Cannot set position to a negative value");
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.close(this.channel);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.requireOpen();
        return this.channel.read(dst);
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        ByteBuffer buffer = ByteBuffer.allocate(1);
        if (this.channel.read(buffer) > 0) {
            buffer.flip();
            return buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        this.requireOpen();
        return new SeekableSourceView(new FileChannelSeekableSource(this.file), startingPosition, length);
    }
}

