/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.parameter.base.SinglePdfSourceSingleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.validation.constraint.HasSelectedPages;
import org.sejda.model.validation.constraint.NoIntersections;
import org.sejda.model.validation.constraint.NotAllowed;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@NoIntersections
@SingleOutputAllowedExtensions
@HasSelectedPages
public class ExtractPagesParameters
extends SinglePdfSourceSingleOutputParameters
implements PageRangeSelection,
PagesSelection {
    @NotNull
    @NotAllowed(disallow={PredefinedSetOfPages.ALL_PAGES})
    private PredefinedSetOfPages predefinedSetOfPages;
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();

    public ExtractPagesParameters() {
        this.predefinedSetOfPages = PredefinedSetOfPages.NONE;
    }

    public ExtractPagesParameters(PredefinedSetOfPages predefinedSetOfPages) {
        this.predefinedSetOfPages = predefinedSetOfPages;
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    public PredefinedSetOfPages getPredefinedSetOfPages() {
        return this.predefinedSetOfPages;
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        if (this.predefinedSetOfPages != PredefinedSetOfPages.NONE) {
            return this.predefinedSetOfPages.getPages(upperLimit);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(upperLimit));
        }
        return retSet;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.predefinedSetOfPages).append(this.pageSelection).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtractPagesParameters)) {
            return false;
        }
        ExtractPagesParameters parameter = (ExtractPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.predefinedSetOfPages, parameter.predefinedSetOfPages).append(this.pageSelection, parameter.pageSelection).isEquals();
    }
}

