/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.cos.UnmodifiableCOSDictionary;
import org.sejda.sambox.util.DateConverter;

public class COSDictionary
extends COSBase {
    private Map<COSName, COSBase> items = new LinkedHashMap<COSName, COSBase>();

    public COSDictionary() {
    }

    public COSDictionary(COSDictionary dict) {
        this.items.putAll(dict.items);
    }

    public COSName getKeyForValue(COSBase value) {
        for (Map.Entry<COSName, COSBase> entry : this.items.entrySet()) {
            if (!entry.getValue().getCOSObject().equals(value.getCOSObject())) continue;
            return entry.getKey();
        }
        return null;
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    public COSBase getDictionaryObject(String key) {
        return this.getDictionaryObject(COSName.getPDFName(key));
    }

    public COSBase getDictionaryObject(COSName firstKey, COSName secondKey) {
        COSBase retval = this.getDictionaryObject(firstKey);
        if (retval == null && secondKey != null) {
            return this.getDictionaryObject(secondKey);
        }
        return retval;
    }

    public COSBase getDictionaryObject(COSName key) {
        return Optional.ofNullable(this.items.get(key)).map(COSBase::getCOSObject).filter(i -> !COSNull.NULL.equals(i)).orElse(null);
    }

    public void setItem(COSName key, COSBase value) {
        if (value == null) {
            this.removeItem(key);
        } else {
            this.items.put(key, value);
        }
    }

    public void setItem(COSName key, COSObjectable value) {
        COSBase base = null;
        if (value != null) {
            base = value.getCOSObject();
        }
        this.setItem(key, base);
    }

    public void setItem(String key, COSObjectable value) {
        this.setItem(COSName.getPDFName(key), value);
    }

    public void setBoolean(String key, boolean value) {
        this.setItem(COSName.getPDFName(key), (COSBase)COSBoolean.valueOf(value));
    }

    public void setBoolean(COSName key, boolean value) {
        this.setItem(key, (COSBase)COSBoolean.valueOf(value));
    }

    public void setItem(String key, COSBase value) {
        this.setItem(COSName.getPDFName(key), value);
    }

    public void setName(String key, String value) {
        this.setName(COSName.getPDFName(key), value);
    }

    public void setName(COSName key, String value) {
        this.setItem(key, (COSBase)COSName.getPDFName(value));
    }

    public void setDate(String key, Calendar date) {
        this.setDate(COSName.getPDFName(key), date);
    }

    public void setDate(COSName key, Calendar date) {
        this.setString(key, DateConverter.toString(date));
    }

    public void setEmbeddedDate(String embedded, String key, Calendar date) {
        this.setEmbeddedDate(embedded, COSName.getPDFName(key), date);
    }

    public void setEmbeddedDate(String embedded, COSName key, Calendar date) {
        COSDictionary dic = (COSDictionary)this.getDictionaryObject(embedded);
        if (dic == null && date != null) {
            dic = new COSDictionary();
            this.setItem(embedded, (COSBase)dic);
        }
        if (dic != null) {
            dic.setDate(key, date);
        }
    }

    public void setString(String key, String value) {
        this.setString(COSName.getPDFName(key), value);
    }

    public void setString(COSName key, String value) {
        COSString name = null;
        if (value != null) {
            name = COSString.parseLiteral(value);
        }
        this.setItem(key, (COSBase)name);
    }

    public void setEmbeddedString(String embedded, String key, String value) {
        this.setEmbeddedString(embedded, COSName.getPDFName(key), value);
    }

    public void setEmbeddedString(String embedded, COSName key, String value) {
        COSDictionary dic = (COSDictionary)this.getDictionaryObject(embedded);
        if (dic == null && value != null) {
            dic = new COSDictionary();
            this.setItem(embedded, (COSBase)dic);
        }
        if (dic != null) {
            dic.setString(key, value);
        }
    }

    public void setInt(String key, int value) {
        this.setInt(COSName.getPDFName(key), value);
    }

    public void setInt(COSName key, int value) {
        this.setItem(key, (COSBase)COSInteger.get(value));
    }

    public void setLong(String key, long value) {
        this.setLong(COSName.getPDFName(key), value);
    }

    public void setLong(COSName key, long value) {
        this.setItem(key, (COSBase)COSInteger.get(value));
    }

    public void setEmbeddedInt(String embeddedDictionary, String key, int value) {
        this.setEmbeddedInt(embeddedDictionary, COSName.getPDFName(key), value);
    }

    public void setEmbeddedInt(String embeddedDictionary, COSName key, int value) {
        COSDictionary embedded = (COSDictionary)this.getDictionaryObject(embeddedDictionary);
        if (embedded == null) {
            embedded = new COSDictionary();
            this.setItem(embeddedDictionary, (COSBase)embedded);
        }
        embedded.setInt(key, value);
    }

    public void setFloat(String key, float value) {
        this.setFloat(COSName.getPDFName(key), value);
    }

    public void setFloat(COSName key, float value) {
        this.setItem(key, (COSBase)new COSFloat(value));
    }

    public void setFlag(COSName field, int bitFlag, boolean value) {
        int currentFlags = this.getInt(field, 0);
        currentFlags = value ? (currentFlags |= bitFlag) : (currentFlags &= ~bitFlag);
        this.setInt(field, currentFlags);
    }

    public COSName getCOSName(COSName key) {
        return this.getCOSName(key, null);
    }

    public COSName getCOSName(COSName key, COSName defaultValue) {
        COSBase name = this.getDictionaryObject(key);
        if (name instanceof COSName) {
            return (COSName)name;
        }
        return defaultValue;
    }

    public String getNameAsString(String key) {
        return this.getNameAsString(COSName.getPDFName(key));
    }

    public String getNameAsString(COSName key) {
        COSBase name = this.getDictionaryObject(key);
        if (name instanceof COSName) {
            return ((COSName)name).getName();
        }
        if (name instanceof COSString) {
            return ((COSString)name).getString();
        }
        return null;
    }

    public String getNameAsString(String key, String defaultValue) {
        return this.getNameAsString(COSName.getPDFName(key), defaultValue);
    }

    public String getNameAsString(COSName key, String defaultValue) {
        return Optional.ofNullable(this.getNameAsString(key)).orElse(defaultValue);
    }

    public String getString(String key) {
        return this.getString(COSName.getPDFName(key));
    }

    public String getString(COSName key) {
        COSBase value = this.getDictionaryObject(key);
        if (value instanceof COSString) {
            return ((COSString)value).getString();
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        return this.getString(COSName.getPDFName(key), defaultValue);
    }

    public String getString(COSName key, String defaultValue) {
        return Optional.ofNullable(this.getString(key)).orElse(defaultValue);
    }

    public String getEmbeddedString(String embedded, String key) {
        return this.getEmbeddedString(embedded, COSName.getPDFName(key), null);
    }

    public String getEmbeddedString(String embedded, COSName key) {
        return this.getEmbeddedString(embedded, key, null);
    }

    public String getEmbeddedString(String embedded, String key, String defaultValue) {
        return this.getEmbeddedString(embedded, COSName.getPDFName(key), defaultValue);
    }

    public String getEmbeddedString(String embedded, COSName key, String defaultValue) {
        COSDictionary dic = (COSDictionary)this.getDictionaryObject(embedded);
        if (dic != null) {
            return dic.getString(key, defaultValue);
        }
        return defaultValue;
    }

    public Calendar getDate(String key) {
        return this.getDate(COSName.getPDFName(key));
    }

    public Calendar getDate(COSName key) {
        return DateConverter.toCalendar((COSString)this.getDictionaryObject(key));
    }

    public Calendar getDate(String key, Calendar defaultValue) {
        return this.getDate(COSName.getPDFName(key), defaultValue);
    }

    public Calendar getDate(COSName key, Calendar defaultValue) {
        return Optional.ofNullable(this.getDate(key)).orElse(defaultValue);
    }

    public Calendar getEmbeddedDate(String embedded, String key) {
        return this.getEmbeddedDate(embedded, COSName.getPDFName(key), null);
    }

    public Calendar getEmbeddedDate(String embedded, COSName key) {
        return this.getEmbeddedDate(embedded, key, null);
    }

    public Calendar getEmbeddedDate(String embedded, String key, Calendar defaultValue) {
        return this.getEmbeddedDate(embedded, COSName.getPDFName(key), defaultValue);
    }

    public Calendar getEmbeddedDate(String embedded, COSName key, Calendar defaultValue) {
        COSDictionary eDic = (COSDictionary)this.getDictionaryObject(embedded);
        if (eDic != null) {
            return eDic.getDate(key, defaultValue);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(COSName.getPDFName(key), defaultValue);
    }

    public boolean getBoolean(COSName key, boolean defaultValue) {
        return this.getBoolean(key, null, defaultValue);
    }

    public boolean getBoolean(COSName firstKey, COSName secondKey, boolean defaultValue) {
        COSBase bool = this.getDictionaryObject(firstKey, secondKey);
        if (bool instanceof COSBoolean) {
            return ((COSBoolean)bool).getValue();
        }
        return defaultValue;
    }

    public int getEmbeddedInt(String embeddedDictionary, String key) {
        return this.getEmbeddedInt(embeddedDictionary, COSName.getPDFName(key));
    }

    public int getEmbeddedInt(String embeddedDictionary, COSName key) {
        return this.getEmbeddedInt(embeddedDictionary, key, -1);
    }

    public int getEmbeddedInt(String embeddedDictionary, String key, int defaultValue) {
        return this.getEmbeddedInt(embeddedDictionary, COSName.getPDFName(key), defaultValue);
    }

    public int getEmbeddedInt(String embeddedDictionary, COSName key, int defaultValue) {
        COSDictionary embedded = (COSDictionary)this.getDictionaryObject(embeddedDictionary);
        if (embedded != null) {
            return embedded.getInt(key, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(COSName.getPDFName(key), -1);
    }

    public int getInt(COSName key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(COSName.getPDFName(key), defaultValue);
    }

    public int getInt(COSName key, int defaultValue) {
        return this.getInt(key, null, defaultValue);
    }

    public int getInt(COSName firstKey, COSName secondKey) {
        return this.getInt(firstKey, secondKey, -1);
    }

    public int getInt(COSName firstKey, COSName secondKey, int defaultValue) {
        COSBase obj = this.getDictionaryObject(firstKey, secondKey);
        if (obj instanceof COSNumber) {
            return ((COSNumber)obj).intValue();
        }
        return defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(COSName.getPDFName(key), -1L);
    }

    public long getLong(COSName key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(COSName.getPDFName(key), defaultValue);
    }

    public long getLong(COSName key, long defaultValue) {
        COSBase obj = this.getDictionaryObject(key);
        if (obj instanceof COSNumber) {
            return ((COSNumber)obj).longValue();
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(COSName.getPDFName(key), -1.0f);
    }

    public float getFloat(COSName key) {
        return this.getFloat(key, -1.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(COSName.getPDFName(key), defaultValue);
    }

    public float getFloat(COSName key, float defaultValue) {
        COSBase obj = this.getDictionaryObject(key);
        if (obj instanceof COSNumber) {
            return ((COSNumber)obj).floatValue();
        }
        return defaultValue;
    }

    public boolean getFlag(COSName field, int bitFlag) {
        int ff = this.getInt(field, 0);
        return (ff & bitFlag) == bitFlag;
    }

    public void removeItem(COSName key) {
        this.items.remove(key);
    }

    public void removeItems(COSName ... keys) {
        Arrays.stream(keys).forEach(this.items::remove);
    }

    public COSBase getItem(COSName key) {
        return this.items.get(key);
    }

    public COSBase getItem(String key) {
        return this.getItem(COSName.getPDFName(key));
    }

    public Set<COSName> keySet() {
        return this.items.keySet();
    }

    public Set<Map.Entry<COSName, COSBase>> entrySet() {
        return this.items.entrySet();
    }

    public Collection<COSBase> getValues() {
        return this.items.values();
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }

    public void addAll(COSDictionary dic) {
        for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsKey(COSName name) {
        return this.items.containsKey(name);
    }

    public boolean containsKey(String name) {
        return this.containsKey(COSName.getPDFName(name));
    }

    public void mergeWithoutOverwriting(COSDictionary dic) {
        for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
            if (this.getItem(entry.getKey()) != null) continue;
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    public void merge(COSDictionary dic) {
        for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    public COSDictionary asUnmodifiableDictionary() {
        return new UnmodifiableCOSDictionary(this);
    }

    public COSDictionary duplicate() {
        return new COSDictionary(this);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder(this.getClass().getSimpleName());
        retVal.append("{");
        for (COSName key : this.items.keySet()) {
            retVal.append("(");
            retVal.append(key);
            retVal.append(":");
            retVal.append(Optional.ofNullable(this.getItem(key)).map(v -> {
                if (v instanceof COSDictionary) {
                    return "COSDictionary{.." + ((COSDictionary)v).size() + " items ..}";
                }
                if (v instanceof COSArray) {
                    return "COSArray{.." + ((COSArray)v).size() + " items ..}";
                }
                return v.toString();
            }).orElse("null"));
            retVal.append(") ");
        }
        retVal.append("}");
        return retVal.toString();
    }
}

