/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.cos.PDFDocEncoding;
import org.sejda.sambox.util.Charsets;
import org.sejda.sambox.util.Hex;

public final class COSString
extends COSBase {
    private byte[] bytes;
    private boolean forceHexForm;

    private COSString(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setValue(byte[] value) {
        this.bytes = Arrays.copyOf(value, value.length);
    }

    public void setForceHexForm(boolean value) {
        this.forceHexForm = value;
    }

    public boolean isForceHexForm() {
        return this.forceHexForm;
    }

    public String getString() {
        if (this.bytes.length > 2) {
            if ((this.bytes[0] & 0xFF) == 254 && (this.bytes[1] & 0xFF) == 255) {
                return new String(this.bytes, 2, this.bytes.length - 2, Charsets.UTF_16BE);
            }
            if ((this.bytes[0] & 0xFF) == 255 && (this.bytes[1] & 0xFF) == 254) {
                return new String(this.bytes, 2, this.bytes.length - 2, Charsets.UTF_16LE);
            }
        }
        return PDFDocEncoding.toString(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toHexString() {
        StringBuilder sb = new StringBuilder(this.bytes.length * 2);
        for (byte b : this.bytes) {
            sb.append(Hex.getString(b));
        }
        return sb.toString();
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof COSString) {
            COSString strObj = (COSString)obj;
            return this.getString().equals(strObj.getString()) && this.forceHexForm == strObj.forceHexForm;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes) + (this.forceHexForm ? 17 : 0);
    }

    public String toString() {
        return "COSString{" + this.getString() + "}";
    }

    public static COSString newInstance(byte[] value) {
        return new COSString(value);
    }

    public static COSString parseLiteral(String literal) {
        return Optional.ofNullable(PDFDocEncoding.getBytes(literal)).map(COSString::new).orElseGet(() -> {
            byte[] data = literal.getBytes(Charsets.UTF_16BE);
            byte[] bytes = new byte[data.length + 2];
            bytes[0] = -2;
            bytes[1] = -1;
            System.arraycopy(data, 0, bytes, 2, data.length);
            return new COSString(bytes);
        });
    }

    public static COSString parseHex(String hex) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        StringBuilder hexBuffer = new StringBuilder(hex.trim());
        if (hexBuffer.length() % 2 != 0) {
            hexBuffer.append('0');
        }
        int length = hexBuffer.length();
        for (int i = 0; i < length; i += 2) {
            try {
                bytes.write(Integer.parseInt(hexBuffer.substring(i, i + 2), 16));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid hex string: " + hex, e);
            }
        }
        COSString retVal = new COSString(bytes.toByteArray());
        retVal.setForceHexForm(true);
        return retVal;
    }
}

