/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;

public abstract class PDTerminalField
extends PDField {
    protected PDTerminalField(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDTerminalField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public void setActions(PDFormFieldAdditionalActions actions) {
        this.getCOSObject().setItem(COSName.AA, (COSObjectable)actions);
    }

    @Override
    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getCOSObject().getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        } else if (this.getParent() != null) {
            retval = this.getParent().getFieldFlags();
        }
        return retval;
    }

    @Override
    public String getFieldType() {
        String fieldType = this.getCOSObject().getNameAsString(COSName.FT);
        if (fieldType == null && this.getParent() != null) {
            fieldType = this.getParent().getFieldType();
        }
        return fieldType;
    }

    @Override
    public List<PDAnnotationWidget> getWidgets() {
        ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>();
        COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            widgets.add(new PDAnnotationWidget(this.getCOSObject()));
        } else if (kids.size() > 0) {
            for (COSBase kid : kids) {
                if (COSNull.NULL.equals(kid) || !Objects.nonNull(kid)) continue;
                widgets.add(new PDAnnotationWidget((COSDictionary)kid.getCOSObject()));
            }
        }
        return widgets;
    }

    public void addWidgetIfMissing(PDAnnotationWidget widget) {
        if (Objects.nonNull(widget)) {
            COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
            if (kids == null) {
                kids = new COSArray(widget.getCOSObject());
                widget.getCOSObject().setItem(COSName.PARENT, (COSObjectable)this);
                this.getCOSObject().setItem(COSName.KIDS, (COSBase)kids);
            } else if (!kids.contains(widget.getCOSObject())) {
                kids.add(widget.getCOSObject());
                widget.getCOSObject().setItem(COSName.PARENT, (COSObjectable)this);
            }
        }
    }

    public void setWidgets(List<PDAnnotationWidget> children) {
        this.getCOSObject().setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(children));
    }

    protected final void applyChange() throws IOException {
        if (!this.getAcroForm().isNeedAppearances()) {
            this.constructAppearances();
        }
    }

    abstract void constructAppearances() throws IOException;

    @Override
    public boolean isTerminal() {
        return true;
    }
}

