/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashSetOfInt
implements Cloneable {
    public int[] set;
    public int elementSize = 0;
    int threshold;

    public HashSetOfInt() {
        this(13);
    }

    public HashSetOfInt(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.set = new int[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        HashSetOfInt hashSetOfInt = (HashSetOfInt)super.clone();
        hashSetOfInt.elementSize = this.elementSize;
        hashSetOfInt.threshold = this.threshold;
        int n = this.set.length;
        hashSetOfInt.set = new int[n];
        System.arraycopy(this.set, 0, hashSetOfInt.set, 0, n);
        return hashSetOfInt;
    }

    public boolean contains(int n) {
        int n2;
        int n3 = this.set.length;
        int n4 = n % n3;
        while ((n2 = this.set[n4]) != 0) {
            if (n2 == n) {
                return true;
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        return false;
    }

    public int add(int n) {
        int n2;
        int n3 = this.set.length;
        int n4 = n % n3;
        while ((n2 = this.set[n4]) != 0) {
            if (n2 == n) {
                this.set[n4] = n;
                return this.set[n4];
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        this.set[n4] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    public int remove(int n) {
        int n2;
        int n3 = this.set.length;
        int n4 = n % n3;
        while ((n2 = this.set[n4]) != 0) {
            if (n2 == n) {
                int n5 = this.set[n4];
                --this.elementSize;
                this.set[n4] = 0;
                this.rehash();
                return n5;
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        return 0;
    }

    private void rehash() {
        HashSetOfInt hashSetOfInt = new HashSetOfInt(this.elementSize * 2);
        int n = this.set.length;
        while (--n >= 0) {
            int n2 = this.set[n];
            if (n2 == 0) continue;
            hashSetOfInt.add(n2);
        }
        this.set = hashSetOfInt.set;
        this.threshold = hashSetOfInt.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.set.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.set[i];
            if (n2 == 0) continue;
            stringBuffer.append(n2);
            if (i == n - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

