#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.0.1
id: semigroupoids-5.0.1-fafa53fc1a76ec617ee4419105d11368
key: semig_HuvOh8WT5cqAWrgFYvgUVV
license: BSD3
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
exposed: True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/semigroupoids-5.0.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/semigroupoids-5.0.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/semigroupoids-5.0.1
hs-libraries: HSsemigroupoids-5.0.1-HuvOh8WT5cqAWrgFYvgUVV
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    base-orphans-0.5.1-066f51369735933a8c1cc4e054dd01ca
    bifunctors-5.2.1-f15ad2d16f9be29f17cf3cf758fe7ba6
    comonad-5-530ea4e1d08a0115920b946124e760ac
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    contravariant-1.4-7b1149a75def92c79deb23a86e0b36cb
    distributive-0.5.0.2-17a8848c95a42a5c612669379433d996
    semigroups-0.18.1-4a4dee25d838ab8c8d38a0caa045cf78
    tagged-0.8.3-aa128de4449752177a05765fb0ce3959
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    transformers-compat-0.5.1.4-b5340b5b89d4b4066d5de0d53e173907
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
