/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oauth.signpost.OAuth;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SignatureBaseString;

public class HmacSha1MessageSigner
extends OAuthMessageSigner {
    private static final String MAC_NAME = "HmacSHA1";

    @Override
    public String getSignatureMethod() {
        return "HMAC-SHA1";
    }

    @Override
    public String sign(HttpRequest httpRequest, HttpParameters httpParameters) throws OAuthMessageSignerException {
        try {
            String string = OAuth.percentEncode(this.getConsumerSecret()) + '&' + OAuth.percentEncode(this.getTokenSecret());
            byte[] byArray = string.getBytes("UTF-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, MAC_NAME);
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(secretKeySpec);
            String string2 = new SignatureBaseString(httpRequest, httpParameters).generate();
            OAuth.debugOut("SBS", string2);
            byte[] byArray2 = string2.getBytes("UTF-8");
            return this.base64Encode(mac.doFinal(byArray2)).trim();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OAuthMessageSignerException(generalSecurityException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OAuthMessageSignerException(unsupportedEncodingException);
        }
    }
}

