/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCacheConfigurator {
    private static final Log log = LogFactory.getLog(CompositeCacheConfigurator.class);
    static final String DEFAULT_REGION = "jcs.default";
    static final String REGION_PREFIX = "jcs.region.";
    static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    static final String ATTRIBUTE_PREFIX = ".attributes";
    static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    public static final String KEY_MATCHER_PREFIX = ".keymatcher";
    private final CompositeCacheManager compositeCacheManager;

    public CompositeCacheConfigurator(CompositeCacheManager compositeCacheManager) {
        this.compositeCacheManager = compositeCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConfigure(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            log.error("Could not read configuration file, ignored: " + string, iOException);
            return;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    log.error("Could not close configuration file " + string, iOException);
                }
            }
        }
        this.doConfigure(properties);
    }

    public void doConfigure(Properties properties) {
        long l = System.currentTimeMillis();
        this.compositeCacheManager.setConfigurationProperties(properties);
        this.setDefaultAuxValues(properties);
        this.setDefaultCompositeCacheAttributes(properties);
        this.setDefaultElementAttributes(properties);
        this.parseSystemRegions(properties);
        this.parseRegions(properties);
        long l2 = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Finished configuration in " + (l2 - l) + " ms.");
        }
    }

    protected void setDefaultAuxValues(Properties properties) {
        String string = OptionConverter.findAndSubst(DEFAULT_REGION, properties);
        this.compositeCacheManager.setDefaultAuxValues(string);
        if (log.isInfoEnabled()) {
            log.info("Setting default auxiliaries to " + string);
        }
    }

    protected void setDefaultCompositeCacheAttributes(Properties properties) {
        ICompositeCacheAttributes iCompositeCacheAttributes = this.parseCompositeCacheAttributes(properties, "", DEFAULT_REGION);
        this.compositeCacheManager.setDefaultCacheAttributes(iCompositeCacheAttributes);
        log.info("setting defaultCompositeCacheAttributes to " + iCompositeCacheAttributes);
    }

    protected void setDefaultElementAttributes(Properties properties) {
        IElementAttributes iElementAttributes = this.parseElementAttributes(properties, "", DEFAULT_REGION);
        this.compositeCacheManager.setDefaultElementAttributes(iElementAttributes);
        log.info("setting defaultElementAttributes to " + iElementAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSystemRegions(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            CompositeCache compositeCache;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(SYSTEM_REGION_PREFIX) || string.indexOf("attributes") != -1) continue;
            String string2 = string.substring(SYSTEM_REGION_PREFIX.length());
            String string3 = OptionConverter.findAndSubst(string, properties);
            String string4 = string2;
            synchronized (string4) {
                compositeCache = this.parseRegion(properties, string2, string3, null, SYSTEM_REGION_PREFIX);
            }
            this.compositeCacheManager.addCache(string2, compositeCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRegions(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            CompositeCache compositeCache;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(REGION_PREFIX) || string.indexOf("attributes") != -1) continue;
            String string2 = string.substring(REGION_PREFIX.length());
            arrayList.add(string2);
            String string3 = OptionConverter.findAndSubst(string, properties);
            String string4 = string2;
            synchronized (string4) {
                compositeCache = this.parseRegion(properties, string2, string3);
            }
            this.compositeCacheManager.addCache(string2, compositeCache);
        }
        if (log.isInfoEnabled()) {
            log.info("Parsed regions " + arrayList);
        }
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties properties, String string, String string2) {
        return this.parseRegion(properties, string, string2, null, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties properties, String string, String string2, ICompositeCacheAttributes iCompositeCacheAttributes) {
        return this.parseRegion(properties, string, string2, iCompositeCacheAttributes, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties properties, String string, String string2, ICompositeCacheAttributes iCompositeCacheAttributes, String string3) {
        IElementAttributes iElementAttributes = this.parseElementAttributes(properties, string, string3);
        CompositeCache compositeCache = iCompositeCacheAttributes == null ? new CompositeCache(this.parseCompositeCacheAttributes(properties, string, string3), iElementAttributes) : new CompositeCache(iCompositeCacheAttributes, iElementAttributes);
        compositeCache.setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
        compositeCache.setElementEventQueue(this.compositeCacheManager.getElementEventQueue());
        if (compositeCache.getMemoryCache() instanceof IRequireScheduler) {
            ((IRequireScheduler)((Object)compositeCache.getMemoryCache())).setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
        }
        if (string2 != null) {
            ArrayList<AuxiliaryCache<K, V>> arrayList = new ArrayList<AuxiliaryCache<K, V>>();
            if (log.isDebugEnabled()) {
                log.debug("Parsing region name '" + string + "', value '" + string2 + "'");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (!(string2.startsWith(",") || string2.equals("") || stringTokenizer.hasMoreTokens())) {
                return null;
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4 == null || string4.equals(",")) continue;
                log.debug("Parsing auxiliary named \"" + string4 + "\".");
                AuxiliaryCache<K, V> auxiliaryCache = this.parseAuxiliary(properties, string4, string);
                if (auxiliaryCache == null) continue;
                if (auxiliaryCache instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxiliaryCache)).setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
                }
                arrayList.add(auxiliaryCache);
            }
            AuxiliaryCache[] auxiliaryCacheArray = arrayList.toArray(new AuxiliaryCache[0]);
            compositeCache.setAuxCaches(auxiliaryCacheArray);
        }
        return compositeCache;
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties properties, String string) {
        return this.parseCompositeCacheAttributes(properties, string, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties properties, String string, String string2) {
        String string3 = string2 + string + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes iCompositeCacheAttributes = OptionConverter.instantiateByKey(properties, string3, null);
        if (iCompositeCacheAttributes == null) {
            if (log.isInfoEnabled()) {
                log.info("No special CompositeCacheAttributes class defined for key [" + string3 + "], using default class.");
            }
            ICompositeCacheAttributes iCompositeCacheAttributes2 = this.compositeCacheManager.getDefaultCacheAttributes();
            iCompositeCacheAttributes = iCompositeCacheAttributes2.clone();
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing options for '" + string3 + "'");
        }
        PropertySetter.setProperties(iCompositeCacheAttributes, properties, string3 + ".");
        iCompositeCacheAttributes.setCacheName(string);
        if (log.isDebugEnabled()) {
            log.debug("End of parsing for \"" + string3 + "\".");
        }
        iCompositeCacheAttributes.setCacheName(string);
        return iCompositeCacheAttributes;
    }

    protected IElementAttributes parseElementAttributes(Properties properties, String string, String string2) {
        String string3 = string2 + string + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes iElementAttributes = OptionConverter.instantiateByKey(properties, string3, null);
        if (iElementAttributes == null) {
            if (log.isInfoEnabled()) {
                log.info("No special ElementAttribute class defined for key [" + string3 + "], using default class.");
            }
            IElementAttributes iElementAttributes2 = this.compositeCacheManager.getDefaultElementAttributes();
            iElementAttributes = iElementAttributes2.clone();
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing options for '" + string3 + "'");
        }
        PropertySetter.setProperties(iElementAttributes, properties, string3 + ".");
        if (log.isDebugEnabled()) {
            log.debug("End of parsing for \"" + string3 + "\".");
        }
        return iElementAttributes;
    }

    protected <K, V> AuxiliaryCache<K, V> parseAuxiliary(Properties properties, String string, String string2) {
        AuxiliaryCache auxiliaryCache;
        if (log.isDebugEnabled()) {
            log.debug("parseAuxiliary " + string);
        }
        if ((auxiliaryCache = this.compositeCacheManager.getAuxiliaryCache(string, string2)) == null) {
            String string3;
            Object object;
            AuxiliaryCacheFactory auxiliaryCacheFactory = this.compositeCacheManager.registryFacGet(string);
            if (auxiliaryCacheFactory == null) {
                object = AUXILIARY_PREFIX + string;
                auxiliaryCacheFactory = OptionConverter.instantiateByKey(properties, (String)object, null);
                if (auxiliaryCacheFactory == null) {
                    log.error("Could not instantiate auxFactory named \"" + string + "\".");
                    return null;
                }
                auxiliaryCacheFactory.setName(string);
                if (auxiliaryCacheFactory instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxiliaryCacheFactory)).setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
                }
                auxiliaryCacheFactory.initialize();
                this.compositeCacheManager.registryFacPut(auxiliaryCacheFactory);
            }
            object = this.compositeCacheManager.registryAttrGet(string);
            String string4 = AUXILIARY_PREFIX + string + ATTRIBUTE_PREFIX;
            if (object == null) {
                string3 = AUXILIARY_PREFIX + string + ATTRIBUTE_PREFIX;
                object = OptionConverter.instantiateByKey(properties, string3, null);
                if (object == null) {
                    log.error("Could not instantiate auxAttr named '" + string4 + "'");
                    return null;
                }
                object.setName(string);
                this.compositeCacheManager.registryAttrPut((AuxiliaryCacheAttributes)object);
            }
            object = object.clone();
            if (log.isDebugEnabled()) {
                log.debug("Parsing options for '" + string4 + "'");
            }
            PropertySetter.setProperties(object, properties, string4 + ".");
            object.setCacheName(string2);
            if (log.isDebugEnabled()) {
                log.debug("End of parsing for '" + string4 + "'");
            }
            object.setCacheName(string2);
            string3 = AUXILIARY_PREFIX + string;
            ICacheEventLogger iCacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(properties, string3);
            IElementSerializer iElementSerializer = AuxiliaryCacheConfigurator.parseElementSerializer(properties, string3);
            try {
                auxiliaryCache = auxiliaryCacheFactory.createCache((AuxiliaryCacheAttributes)object, this.compositeCacheManager, iCacheEventLogger, iElementSerializer);
            }
            catch (Exception exception) {
                log.error("Could not instantiate auxiliary cache named \"" + string2 + "\".");
                return null;
            }
            this.compositeCacheManager.addAuxiliaryCache(string, string2, auxiliaryCache);
        }
        return auxiliaryCache;
    }

    public static <K> IKeyMatcher<K> parseKeyMatcher(Properties properties, String string) {
        String string2 = string + KEY_MATCHER_PREFIX;
        KeyMatcherPatternImpl keyMatcherPatternImpl = OptionConverter.instantiateByKey(properties, string2, null);
        if (keyMatcherPatternImpl != null) {
            String string3 = string + KEY_MATCHER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(keyMatcherPatternImpl, properties, string3 + ".");
            if (log.isInfoEnabled()) {
                log.info("Using custom key matcher [" + keyMatcherPatternImpl + "] for auxiliary [" + string + "]");
            }
        } else {
            keyMatcherPatternImpl = new KeyMatcherPatternImpl();
            if (log.isInfoEnabled()) {
                log.info("Using standard key matcher [" + keyMatcherPatternImpl + "] for auxiliary [" + string + "]");
            }
        }
        return keyMatcherPatternImpl;
    }
}

