/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private static boolean useBoundary_DEFAULT = true;
    private static int boundarySize_DEFAULT = 2000;
    private static int maximumPoolSize_DEFAULT = 150;
    private static int minimumPoolSize_DEFAULT = 4;
    private static int keepAliveTime_DEFAULT = 300000;
    private static PoolConfiguration.WhenBlockedPolicy whenBlockedPolicy_DEFAULT = PoolConfiguration.WhenBlockedPolicy.RUN;
    private static int startUpSize_DEFAULT = 4;
    private static PoolConfiguration defaultConfig;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static volatile Properties props;
    private static ThreadPoolManager INSTANCE;
    private ConcurrentHashMap<String, ThreadPoolExecutor> pools = new ConcurrentHashMap();
    private ReentrantLock poolLock = new ReentrantLock();

    private ThreadPoolManager() {
        ThreadPoolManager.configure();
    }

    private ThreadPoolExecutor createPool(PoolConfiguration poolConfiguration) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = null;
        if (poolConfiguration.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug("Creating a Bounded Buffer to use for the pool");
            }
            linkedBlockingQueue = new LinkedBlockingQueue(poolConfiguration.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Creating a non bounded Linked Queue to use for the pool");
            }
            linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(poolConfiguration.getStartUpSize(), poolConfiguration.getMaximumPoolSize(), (long)poolConfiguration.getKeepAliveTime(), TimeUnit.MILLISECONDS, linkedBlockingQueue, new DaemonThreadFactory("JCS-ThreadPoolManager-"));
        switch (poolConfiguration.getWhenBlockedPolicy()) {
            case ABORT: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        threadPoolExecutor.prestartAllCoreThreads();
        return threadPoolExecutor;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            for (String string : INSTANCE.getPoolNames()) {
                try {
                    INSTANCE.getPool(string).shutdownNow();
                }
                catch (Throwable throwable) {
                    log.warn("Failed to close pool " + string, throwable);
                }
            }
            INSTANCE = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getPool(String string) {
        ThreadPoolExecutor threadPoolExecutor = this.pools.get(string);
        if (threadPoolExecutor == null) {
            this.poolLock.lock();
            try {
                threadPoolExecutor = this.pools.get(string);
                if (threadPoolExecutor == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Creating pool for name [" + string + "]");
                    }
                    PoolConfiguration poolConfiguration = ThreadPoolManager.loadConfig("thread_pool." + string);
                    threadPoolExecutor = this.createPool(poolConfiguration);
                    this.pools.put(string, threadPoolExecutor);
                    if (log.isDebugEnabled()) {
                        log.debug("PoolName = " + this.getPoolNames());
                    }
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
        return threadPoolExecutor;
    }

    public ArrayList<String> getPoolNames() {
        return new ArrayList<String>(this.pools.keySet());
    }

    public static void setProps(Properties properties) {
        props = properties;
    }

    private static void configure() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing ThreadPoolManager");
        }
        if (props == null) {
            log.warn("No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        defaultConfig = new PoolConfiguration(useBoundary_DEFAULT, boundarySize_DEFAULT, maximumPoolSize_DEFAULT, minimumPoolSize_DEFAULT, keepAliveTime_DEFAULT, whenBlockedPolicy_DEFAULT, startUpSize_DEFAULT);
        defaultConfig = ThreadPoolManager.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    private static PoolConfiguration loadConfig(String string) {
        PoolConfiguration poolConfiguration = defaultConfig.clone();
        try {
            poolConfiguration.setUseBoundary(Boolean.parseBoolean(props.getProperty(string + ".useBoundary", "false")));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("useBoundary not a boolean.", numberFormatException);
        }
        try {
            poolConfiguration.setBoundarySize(Integer.parseInt(props.getProperty(string + ".boundarySize", "2000")));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("boundarySize not a number.", numberFormatException);
        }
        try {
            poolConfiguration.setMaximumPoolSize(Integer.parseInt(props.getProperty(string + ".maximumPoolSize", "150")));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("maximumPoolSize not a number.", numberFormatException);
        }
        try {
            poolConfiguration.setMinimumPoolSize(Integer.parseInt(props.getProperty(string + ".minimumPoolSize", "4")));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("minimumPoolSize not a number.", numberFormatException);
        }
        try {
            poolConfiguration.setKeepAliveTime(Integer.parseInt(props.getProperty(string + ".keepAliveTime", "300000")));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("keepAliveTime not a number.", numberFormatException);
        }
        poolConfiguration.setWhenBlockedPolicy(props.getProperty(string + ".whenBlockedPolicy", "RUN"));
        try {
            poolConfiguration.setStartUpSize(Integer.parseInt(props.getProperty(string + ".startUpSize", "4")));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("startUpSize not a number.", numberFormatException);
        }
        if (log.isInfoEnabled()) {
            log.info(string + " PoolConfiguration = " + poolConfiguration);
        }
        return poolConfiguration;
    }

    static {
        props = null;
        INSTANCE = null;
    }
}

