/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.SignpostAdapters;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5";
    public static final String DEFAULT_REQUEST_TOKEN_URL = Main.getOSMWebsite() + "/oauth/request_token";
    public static final String DEFAULT_ACCESS_TOKEN_URL = Main.getOSMWebsite() + "/oauth/access_token";
    public static final String DEFAULT_AUTHORISE_URL = Main.getOSMWebsite() + "/oauth/authorize";
    private final String consumerKey;
    private final String consumerSecret;
    private final String requestTokenUrl;
    private final String accessTokenUrl;
    private final String authoriseUrl;

    public static OAuthParameters createDefault() {
        return OAuthParameters.createDefault(null);
    }

    public static OAuthParameters createDefault(String string) {
        boolean bl;
        String string2;
        block3: {
            string2 = "";
            if (!"https://api.openstreetmap.org/api".equals(string)) {
                try {
                    string2 = new URL(string).getHost();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!Main.isTraceEnabled()) break block3;
                    Main.trace(malformedURLException.getMessage());
                }
            }
        }
        return new OAuthParameters(DEFAULT_JOSM_CONSUMER_KEY, DEFAULT_JOSM_CONSUMER_SECRET, (bl = string2.endsWith("dev.openstreetmap.org")) ? DEFAULT_REQUEST_TOKEN_URL.replace("www.openstreetmap.org", string2) : DEFAULT_REQUEST_TOKEN_URL, bl ? DEFAULT_ACCESS_TOKEN_URL.replace("www.openstreetmap.org", string2) : DEFAULT_ACCESS_TOKEN_URL, bl ? DEFAULT_AUTHORISE_URL.replace("www.openstreetmap.org", string2) : DEFAULT_AUTHORISE_URL);
    }

    public static OAuthParameters createFromPreferences(Preferences preferences) {
        OAuthParameters oAuthParameters = OAuthParameters.createDefault(preferences.get("osm-server.url"));
        return new OAuthParameters(preferences.get("oauth.settings.consumer-key", oAuthParameters.getConsumerKey()), preferences.get("oauth.settings.consumer-secret", oAuthParameters.getConsumerSecret()), preferences.get("oauth.settings.request-token-url", oAuthParameters.getRequestTokenUrl()), preferences.get("oauth.settings.access-token-url", oAuthParameters.getAccessTokenUrl()), preferences.get("oauth.settings.authorise-url", oAuthParameters.getAuthoriseUrl()));
    }

    public OAuthParameters(String string, String string2, String string3, String string4, String string5) {
        this.consumerKey = string;
        this.consumerSecret = string2;
        this.requestTokenUrl = string3;
        this.accessTokenUrl = string4;
        this.authoriseUrl = string5;
    }

    public OAuthParameters(OAuthParameters oAuthParameters) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "other");
        this.consumerKey = oAuthParameters.consumerKey;
        this.consumerSecret = oAuthParameters.consumerSecret;
        this.accessTokenUrl = oAuthParameters.accessTokenUrl;
        this.requestTokenUrl = oAuthParameters.requestTokenUrl;
        this.authoriseUrl = oAuthParameters.authoriseUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getAuthoriseUrl() {
        return this.authoriseUrl;
    }

    public OAuthConsumer buildConsumer() {
        return new SignpostAdapters.OAuthConsumer(this.consumerKey, this.consumerSecret);
    }

    public OAuthProvider buildProvider(OAuthConsumer oAuthConsumer) {
        CheckParameterUtil.ensureParameterNotNull(oAuthConsumer, "consumer");
        return new SignpostAdapters.OAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.accessTokenUrl == null ? 0 : this.accessTokenUrl.hashCode());
        n = 31 * n + (this.authoriseUrl == null ? 0 : this.authoriseUrl.hashCode());
        n = 31 * n + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        n = 31 * n + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        n = 31 * n + (this.requestTokenUrl == null ? 0 : this.requestTokenUrl.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OAuthParameters oAuthParameters = (OAuthParameters)object;
        if (this.accessTokenUrl == null ? oAuthParameters.accessTokenUrl != null : !this.accessTokenUrl.equals(oAuthParameters.accessTokenUrl)) {
            return false;
        }
        if (this.authoriseUrl == null ? oAuthParameters.authoriseUrl != null : !this.authoriseUrl.equals(oAuthParameters.authoriseUrl)) {
            return false;
        }
        if (this.consumerKey == null ? oAuthParameters.consumerKey != null : !this.consumerKey.equals(oAuthParameters.consumerKey)) {
            return false;
        }
        if (this.consumerSecret == null ? oAuthParameters.consumerSecret != null : !this.consumerSecret.equals(oAuthParameters.consumerSecret)) {
            return false;
        }
        return !(this.requestTokenUrl == null ? oAuthParameters.requestTokenUrl != null : !this.requestTokenUrl.equals(oAuthParameters.requestTokenUrl));
    }
}

