/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class CoordinateInfoViewer
extends JPanel {
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);
    private transient HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private LatLonViewer referenceLatLonViewer;
    private LatLonViewer currentLatLonViewer;
    private DistanceViewer distanceViewer;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.referenceLatLonViewer = new LatLonViewer(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceLatLonViewer, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.currentLatLonViewer = new LatLonViewer(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentLatLonViewer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.distanceViewer = new DistanceViewer(this.model);
        this.add((Component)this.distanceViewer, gridBagConstraints);
    }

    public CoordinateInfoViewer(HistoryBrowserModel historyBrowserModel) {
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.setModel(historyBrowserModel);
        this.build();
        this.registerAsObserver(historyBrowserModel);
    }

    protected void unregisterAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            historyBrowserModel.deleteObserver(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            historyBrowserModel.deleteObserver(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            historyBrowserModel.deleteObserver(this.distanceViewer);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addObserver(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            historyBrowserModel.addObserver(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            historyBrowserModel.addObserver(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            historyBrowserModel.addObserver(this.distanceViewer);
        }
    }

    public void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsObserver(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsObserver(historyBrowserModel);
        }
    }

    private static class DistanceViewer
    extends LatLonViewer {
        private JLabel lblDistance;

        DistanceViewer(HistoryBrowserModel historyBrowserModel) {
            super(historyBrowserModel, PointInTimeType.REFERENCE_POINT_IN_TIME);
        }

        @Override
        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Distance: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblDistance = new JLabel();
            this.add((Component)this.lblDistance, gridBagConstraints);
            GuiHelper.setBackgroundReadable(this.lblDistance, Color.WHITE);
            this.lblDistance.setOpaque(true);
            this.lblDistance.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        @Override
        protected void refresh() {
            if (!this.prepareRefresh()) {
                return;
            }
            if (this.coord != null && this.oppositeCoord != null) {
                double d = this.coord.greatCircleDistance(this.oppositeCoord);
                GuiHelper.setBackgroundReadable(this.lblDistance, d > 0.0 ? BGCOLOR_DIFFERENCE : Color.WHITE);
                this.lblDistance.setText(NavigatableComponent.getDistText(d));
            } else {
                GuiHelper.setBackgroundReadable(this.lblDistance, this.coord != this.oppositeCoord ? BGCOLOR_DIFFERENCE : Color.WHITE);
                this.lblDistance.setText(I18n.tr("(none)", new Object[0]));
            }
        }
    }

    private static class LatLonViewer
    extends JPanel
    implements Observer {
        private JLabel lblLat;
        private JLabel lblLon;
        private final transient HistoryBrowserModel model;
        private final PointInTimeType role;
        protected LatLon coord;
        protected LatLon oppositeCoord;

        protected HistoryOsmPrimitive getPrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role);
        }

        protected HistoryOsmPrimitive getOppositePrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role.opposite());
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Latitude: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblLat = new JLabel();
            this.add((Component)this.lblLat, gridBagConstraints);
            GuiHelper.setBackgroundReadable(this.lblLat, Color.WHITE);
            this.lblLat.setOpaque(true);
            this.lblLat.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Longitude: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblLon = new JLabel();
            this.add((Component)this.lblLon, gridBagConstraints);
            GuiHelper.setBackgroundReadable(this.lblLon, Color.WHITE);
            this.lblLon.setOpaque(true);
            this.lblLon.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        LatLonViewer(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
            this.build();
            this.model = historyBrowserModel;
            this.role = pointInTimeType;
        }

        protected final boolean prepareRefresh() {
            HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
            HistoryOsmPrimitive historyOsmPrimitive2 = this.getOppositePrimitive();
            if (!(historyOsmPrimitive instanceof HistoryNode)) {
                return false;
            }
            if (!(historyOsmPrimitive2 instanceof HistoryNode)) {
                return false;
            }
            HistoryNode historyNode = (HistoryNode)historyOsmPrimitive;
            HistoryNode historyNode2 = (HistoryNode)historyOsmPrimitive2;
            this.coord = historyNode.getCoords();
            this.oppositeCoord = historyNode2.getCoords();
            return true;
        }

        protected void refresh() {
            if (!this.prepareRefresh()) {
                return;
            }
            this.lblLat.setText(this.coord != null ? this.coord.latToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            this.lblLon.setText(this.coord != null ? this.coord.lonToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            if (this.coord == this.oppositeCoord || this.coord != null && this.oppositeCoord != null && this.coord.lat() == this.oppositeCoord.lat()) {
                GuiHelper.setBackgroundReadable(this.lblLat, Color.WHITE);
            } else {
                GuiHelper.setBackgroundReadable(this.lblLat, BGCOLOR_DIFFERENCE);
            }
            if (this.coord == this.oppositeCoord || this.coord != null && this.oppositeCoord != null && this.coord.lon() == this.oppositeCoord.lon()) {
                GuiHelper.setBackgroundReadable(this.lblLon, Color.WHITE);
            } else {
                GuiHelper.setBackgroundReadable(this.lblLon, BGCOLOR_DIFFERENCE);
            }
        }

        @Override
        public void update(Observable observable, Object object) {
            this.refresh();
        }
    }
}

