/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.DividedScale;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.LineElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.LineTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.RepeatImageElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class ElemStyles
implements Preferences.PreferenceChangedListener {
    private final List<StyleSource> styleSources;
    private boolean drawMultipolygon;
    private int cacheIdx = 1;
    private boolean defaultNodes;
    private boolean defaultLines;
    private int defaultNodesIdx;
    private int defaultLinesIdx;
    private final Map<String, String> preferenceCache = new HashMap<String, String>();

    public ElemStyles() {
        this.styleSources = new ArrayList<StyleSource>();
        Main.pref.addPreferenceChangeListener(this);
    }

    public void clearCached() {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                ElemStyles.this.cacheIdx++;
                ElemStyles.this.preferenceCache.clear();
            }
        });
    }

    public List<StyleSource> getStyleSources() {
        return Collections.unmodifiableList(this.styleSources);
    }

    public StyleElementList get(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        return (StyleElementList)this.getStyleCacheWithRange((OsmPrimitive)osmPrimitive, (double)d, (NavigatableComponent)navigatableComponent).a;
    }

    public Pair<StyleElementList, Range> getStyleCacheWithRange(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        boolean bl;
        Pair<StyleElementList, Range> pair;
        if (osmPrimitive.mappaintStyle == null || osmPrimitive.mappaintCacheIdx != this.cacheIdx || d <= 0.0) {
            osmPrimitive.mappaintStyle = StyleCache.EMPTY_STYLECACHE;
        } else {
            pair = osmPrimitive.mappaintStyle.getWithRange(d);
            if (pair.a != null) {
                return pair;
            }
        }
        pair = this.getImpl(osmPrimitive, d, navigatableComponent);
        if (osmPrimitive instanceof Node && this.isDefaultNodes()) {
            if (((StyleElementList)pair.a).isEmpty()) {
                pair.a = TextLabel.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osmPrimitive) != null ? NodeElement.DEFAULT_NODE_STYLELIST_TEXT : NodeElement.DEFAULT_NODE_STYLELIST;
            } else {
                bl = false;
                boolean bl2 = false;
                for (StyleElement styleElement : (StyleElementList)pair.a) {
                    if (styleElement instanceof BoxTextElement) {
                        bl2 = true;
                        continue;
                    }
                    if (styleElement.isModifier) continue;
                    bl = true;
                }
                if (!bl) {
                    pair.a = new StyleElementList((StyleElementList)pair.a, (StyleElement)NodeElement.SIMPLE_NODE_ELEMSTYLE);
                    if (!bl2 && TextLabel.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osmPrimitive) != null) {
                        pair.a = new StyleElementList((StyleElementList)pair.a, (StyleElement)BoxTextElement.SIMPLE_NODE_TEXT_ELEMSTYLE);
                    }
                }
            }
        } else if (osmPrimitive instanceof Way && this.isDefaultLines()) {
            bl = false;
            for (StyleElement styleElement : (StyleElementList)pair.a) {
                if (!styleElement.isProperLineStyle()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                StyleElement styleElement;
                AreaElement areaElement = Utils.find((Iterable)pair.a, AreaElement.class);
                styleElement = areaElement == null ? LineElement.UNTAGGED_WAY : LineElement.createSimpleLineStyle(areaElement.color, true);
                pair.a = new StyleElementList((StyleElementList)pair.a, styleElement);
            }
        }
        StyleCache styleCache = osmPrimitive.mappaintStyle != null ? osmPrimitive.mappaintStyle : StyleCache.EMPTY_STYLECACHE;
        try {
            osmPrimitive.mappaintStyle = styleCache.put((StyleElementList)pair.a, (Range)pair.b);
        }
        catch (DividedScale.RangeViolatedError rangeViolatedError) {
            throw new AssertionError("Range violated: " + rangeViolatedError.getMessage() + " (object: " + osmPrimitive.getPrimitiveId() + ", current style: " + osmPrimitive.mappaintStyle + ", scale: " + d + ", new stylelist: " + pair.a + ", new range: " + pair.b + ')', rangeViolatedError);
        }
        osmPrimitive.mappaintCacheIdx = this.cacheIdx;
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<StyleElementList, Range> getImpl(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        if (osmPrimitive instanceof Node) {
            return this.generateStyles(osmPrimitive, d, false);
        }
        if (osmPrimitive instanceof Way) {
            StyleElement styleElement;
            Object object5;
            Object object22;
            Object object3;
            boolean bl;
            Multipolygon multipolygon;
            Object object42;
            Pair<StyleElementList, Range> pair = this.generateStyles(osmPrimitive, d, false);
            boolean bl2 = false;
            Color color = null;
            for (OsmPrimitive object5 : osmPrimitive.getReferrers()) {
                object42 = (Relation)object5;
                if (!this.drawMultipolygon || !((Relation)object42).isMultipolygon() || !((AbstractPrimitive)object42).isUsable() || !(multipolygon = MultipolygonCache.getInstance().get(navigatableComponent, (Relation)object42)).getOuterWays().contains(osmPrimitive)) continue;
                bl = false;
                if (!bl2) {
                    object3 = new ArrayList(((StyleElementList)pair.a).size());
                    for (Object object22 : (StyleElementList)pair.a) {
                        if (object22 instanceof AreaElement) {
                            color = ((AreaElement)object22).color;
                            continue;
                        }
                        object3.add((Object)object22);
                        if (!((StyleElement)object22).isProperLineStyle()) continue;
                        bl = true;
                    }
                    pair.a = new StyleElementList((Collection<StyleElement>)object3);
                    bl2 = true;
                }
                if (bl) continue;
                object5 = object42;
                synchronized (object5) {
                    object3 = this.getStyleCacheWithRange((OsmPrimitive)object42, d, navigatableComponent);
                }
                object5 = null;
                object22 = ((StyleElementList)((Pair)object3).a).iterator();
                while (object22.hasNext()) {
                    styleElement = (StyleElement)object22.next();
                    if (!styleElement.isProperLineStyle()) continue;
                    object5 = styleElement;
                    break;
                }
                pair.b = Range.cut((Range)pair.b, (Range)((Pair)object3).b);
                if (object5 != null) {
                    pair.a = new StyleElementList((StyleElementList)pair.a, (StyleElement)object5);
                    break;
                }
                if (color != null || !this.isDefaultLines() || (object22 = Utils.find((Iterable)((Pair)object3).a, AreaElement.class)) == null) continue;
                color = ((AreaElement)object22).color;
            }
            if (bl2) {
                if (this.isDefaultLines()) {
                    boolean bl3 = false;
                    for (Object object42 : (StyleElementList)pair.a) {
                        if (!((StyleElement)object42).isProperLineStyle()) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        pair.a = new StyleElementList((StyleElementList)pair.a, (StyleElement)LineElement.createSimpleLineStyle(color, true));
                    }
                }
                return pair;
            }
            if (!this.isDefaultLines()) {
                return pair;
            }
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                object42 = (Relation)osmPrimitive2;
                if (!this.drawMultipolygon || !((Relation)object42).isMultipolygon() || !((AbstractPrimitive)object42).isUsable() || !(multipolygon = MultipolygonCache.getInstance().get(navigatableComponent, (Relation)object42)).getInnerWays().contains(osmPrimitive)) continue;
                pair = this.generateStyles(osmPrimitive, d, false);
                bl = false;
                for (Object object5 : (StyleElementList)pair.a) {
                    if (!((StyleElement)object5).isProperLineStyle() && !(object5 instanceof AreaElement)) continue;
                    bl = true;
                    break;
                }
                if (!bl && !multipolygon.getOuterWays().isEmpty()) {
                    object3 = null;
                    object5 = null;
                    object22 = object42;
                    synchronized (object22) {
                        object5 = this.get((OsmPrimitive)object42, d, navigatableComponent);
                    }
                    object22 = ((StyleElementList)object5).iterator();
                    while (object22.hasNext()) {
                        styleElement = object22.next();
                        if (!(styleElement instanceof AreaElement)) continue;
                        object3 = ((AreaElement)styleElement).color;
                        break;
                    }
                    pair.a = new StyleElementList((StyleElementList)pair.a, (StyleElement)LineElement.createSimpleLineStyle(object3, true));
                }
                return pair;
            }
            return pair;
        }
        if (osmPrimitive instanceof Relation) {
            Pair<StyleElementList, Range> pair = this.generateStyles(osmPrimitive, d, true);
            if (this.drawMultipolygon && ((Relation)osmPrimitive).isMultipolygon() && !Utils.exists((Iterable)pair.a, AreaElement.class) && Main.pref.getBoolean("multipolygon.deprecated.outerstyle", true)) {
                Multipolygon multipolygon = MultipolygonCache.getInstance().get(navigatableComponent, (Relation)osmPrimitive);
                for (Way way : multipolygon.getOuterWays()) {
                    Pair<StyleElementList, Range> pair2 = this.generateStyles(way, d, false);
                    pair.b = Range.cut((Range)pair.b, (Range)pair2.b);
                    StyleElement styleElement = Utils.find((Iterable)pair2.a, AreaElement.class);
                    if (styleElement == null) continue;
                    pair.a = new StyleElementList((StyleElementList)pair.a, styleElement);
                    break;
                }
            }
            return pair;
        }
        return null;
    }

    public Pair<StyleElementList, Range> generateStyles(OsmPrimitive osmPrimitive, double d, boolean bl) {
        ArrayList<StyleElement> arrayList = new ArrayList<StyleElement>();
        MultiCascade multiCascade = new MultiCascade();
        Environment environment = new Environment(osmPrimitive, multiCascade, null, null);
        for (StyleSource object : this.styleSources) {
            if (!object.active) continue;
            object.apply(multiCascade, osmPrimitive, d, bl);
        }
        for (Map.Entry entry : multiCascade.getLayers()) {
            if ("*".equals(entry.getKey())) continue;
            environment.layer = (String)entry.getKey();
            if (osmPrimitive instanceof Way) {
                ElemStyles.addIfNotNull(arrayList, AreaElement.create(environment));
                ElemStyles.addIfNotNull(arrayList, RepeatImageElement.create(environment));
                ElemStyles.addIfNotNull(arrayList, LineElement.createLine(environment));
                ElemStyles.addIfNotNull(arrayList, LineElement.createLeftCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineElement.createRightCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineElement.createCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineTextElement.create(environment));
                continue;
            }
            if (osmPrimitive instanceof Node) {
                NodeElement nodeElement = NodeElement.create(environment);
                if (nodeElement != null) {
                    arrayList.add(nodeElement);
                    ElemStyles.addIfNotNull(arrayList, BoxTextElement.create(environment, nodeElement.getBoxProvider()));
                    continue;
                }
                ElemStyles.addIfNotNull(arrayList, BoxTextElement.create(environment, NodeElement.SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER));
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            if (((Relation)osmPrimitive).isMultipolygon()) {
                ElemStyles.addIfNotNull(arrayList, AreaElement.create(environment));
                ElemStyles.addIfNotNull(arrayList, RepeatImageElement.create(environment));
                ElemStyles.addIfNotNull(arrayList, LineElement.createLine(environment));
                ElemStyles.addIfNotNull(arrayList, LineElement.createCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineTextElement.create(environment));
                continue;
            }
            if (!"restriction".equals(osmPrimitive.get("type"))) continue;
            ElemStyles.addIfNotNull(arrayList, NodeElement.create(environment));
        }
        return new Pair<StyleElementList, Range>(new StyleElementList(arrayList), multiCascade.range);
    }

    private static <T> void addIfNotNull(List<T> list, T t) {
        if (t != null) {
            list.add(t);
        }
    }

    private boolean isDefaultNodes() {
        if (this.defaultNodesIdx == this.cacheIdx) {
            return this.defaultNodes;
        }
        this.defaultNodes = this.fromCanvas("default-points", Boolean.TRUE, Boolean.class);
        this.defaultNodesIdx = this.cacheIdx;
        return this.defaultNodes;
    }

    private boolean isDefaultLines() {
        if (this.defaultLinesIdx == this.cacheIdx) {
            return this.defaultLines;
        }
        this.defaultLines = this.fromCanvas("default-lines", Boolean.TRUE, Boolean.class);
        this.defaultLinesIdx = this.cacheIdx;
        return this.defaultLines;
    }

    private <T> T fromCanvas(String string, T t, Class<T> clazz) {
        MultiCascade multiCascade = new MultiCascade();
        Relation relation = new Relation();
        relation.put("#canvas", "query");
        for (StyleSource styleSource : this.styleSources) {
            if (!styleSource.active) continue;
            styleSource.apply(multiCascade, relation, 1.0, false);
        }
        return multiCascade.getCascade("default").get(string, t, clazz);
    }

    public boolean isDrawMultipolygon() {
        return this.drawMultipolygon;
    }

    public void setDrawMultipolygon(boolean bl) {
        this.drawMultipolygon = bl;
    }

    void clear() {
        this.styleSources.clear();
    }

    void add(StyleSource styleSource) {
        this.styleSources.add(styleSource);
    }

    void setStyleSources(Collection<StyleSource> collection) {
        this.styleSources.clear();
        this.styleSources.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AreaElement getAreaElemStyle(OsmPrimitive osmPrimitive, boolean bl) {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            if (MapPaintStyles.getStyles() == null) {
                AreaElement areaElement = null;
                return areaElement;
            }
            for (StyleElement styleElement : (StyleElementList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)osmPrimitive, (double)1.0, (boolean)bl).a) {
                if (!(styleElement instanceof AreaElement)) continue;
                AreaElement areaElement = (AreaElement)styleElement;
                return areaElement;
            }
            Iterator<StyleElement> iterator = null;
            return iterator;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    public static boolean hasAreaElemStyle(OsmPrimitive osmPrimitive, boolean bl) {
        return ElemStyles.getAreaElemStyle(osmPrimitive, bl) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOnlyAreaElemStyle(OsmPrimitive osmPrimitive) {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            if (MapPaintStyles.getStyles() == null) {
                boolean bl = false;
                return bl;
            }
            StyleElementList styleElementList = (StyleElementList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)osmPrimitive, (double)1.0, (boolean)false).a;
            if (styleElementList.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            for (StyleElement styleElement : styleElementList) {
                if (styleElement instanceof AreaElement) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    public String getPreferenceCached(String string, String string2) {
        String string3;
        if (this.preferenceCache.containsKey(string)) {
            string3 = this.preferenceCache.get(string);
        } else {
            string3 = Main.pref.get(string, null);
            this.preferenceCache.put(string, string3);
        }
        return string3 != null ? string3 : string2;
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (this.preferenceCache.containsKey(preferenceChangeEvent.getKey())) {
            this.clearCached();
        }
    }
}

