/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.runtime.RubyContext;

public class NNode
extends PackNode {
    private final int repeats;
    @Node.Child
    private PackNode child;

    public NNode(RubyContext context, int repeats, PackNode child) {
        super(context);
        this.repeats = repeats;
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isCompilationConstant(this.repeats) && this.repeats <= this.getContext().getOptions().PACK_UNROLL_LIMIT) {
            return this.executeExploded(frame);
        }
        for (int i = 0; i < this.repeats; ++i) {
            this.child.execute(frame);
        }
        if (CompilerDirectives.inInterpreter()) {
            this.getRootNode().reportLoopCount(this.repeats);
        }
        return null;
    }

    @ExplodeLoop
    public Object executeExploded(VirtualFrame frame) {
        for (int i = 0; i < this.repeats; ++i) {
            this.child.execute(frame);
        }
        return null;
    }
}

