/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.settings;

import ch.ehi.basics.tools.StringUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Settings {
    private HashMap values = new HashMap();
    private HashMap transientValues = new HashMap();

    public Settings() {
    }

    public Settings(Settings settings) {
        if (settings != null) {
            Object v;
            String string;
            Iterator iterator = null;
            iterator = settings.values.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                v = settings.values.get(string);
                this.values.put(string, v);
            }
            iterator = this.transientValues.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                v = settings.transientValues.get(string);
                this.transientValues.put(string, v);
            }
        }
    }

    public String getValue(String string) {
        String string2 = (String)this.values.get(string);
        return StringUtility.purge(string2);
    }

    public void setValue(String string, String string2) {
        if ((string2 = StringUtility.purge(string2)) == null) {
            this.values.remove(string);
        } else {
            this.values.put(string, string2);
        }
    }

    public Object getTransientObject(String string) {
        Object v = this.transientValues.get(string);
        if (v != null && v instanceof String) {
            return StringUtility.purge((String)v);
        }
        return v;
    }

    public void setTransientObject(String string, Object object) {
        if (object != null && object instanceof String) {
            object = StringUtility.purge((String)object);
        }
        if (object == null) {
            this.transientValues.remove(string);
        } else {
            this.transientValues.put(string, object);
        }
    }

    public String getTransientValue(String string) {
        return (String)this.getTransientObject(string);
    }

    public void setTransientValue(String string, String string2) {
        this.setTransientObject(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, String string) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.store(outputStream, string);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.values);
        properties.store(outputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.values.putAll(properties);
    }

    public Set getValues() {
        return this.values.keySet();
    }

    public Set getTransientValues() {
        return this.transientValues.keySet();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values.keySet().iterator();
        Iterator iterator2 = this.transientValues.keySet().iterator();
        if (iterator.hasNext() || iterator2.hasNext()) {
            Object v;
            String string;
            String string2 = "";
            stringBuffer.append("Settings{");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                v = this.values.get(string);
                stringBuffer.append(string2 + string + "=" + v.toString());
                string2 = ";";
            }
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                v = this.transientValues.get(string);
                stringBuffer.append(string2 + string + "=" + v.toString());
                string2 = ";";
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }
}

