// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Command, E, KeyPatcher, add_option_dict, env, iced, key_select, load_key, make_esc, pg, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  pg = require('./push_and_keygen');

  E = require('../err').E;

  make_esc = require('iced-error').make_esc;

  add_option_dict = require('./argparse').add_option_dict;

  env = require('../env').env;

  key_select = require('../keyselector').key_select;

  load_key = require('../keyring').load_key;

  KeyPatcher = require('../keypatch').KeyPatcher;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      g: {
        alias: "gen",
        action: "storeTrue",
        help: "generate a new key"
      },
      p: {
        alias: "show-public-only-keys",
        action: "storeTrue",
        help: "Allow picking of public keys for which no secret key is available (not recommended)"
      },
      "skip-add-email": {
        action: "storeTrue",
        help: "Skip the prompt asking if we want to store email to key; don't do it"
      },
      "add-email": {
        action: "storeTrue",
        help: "Add email to key by default, if needed"
      }
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        aliases: [],
        help: "push a PGP key from the client to the server"
      };
      name = "push";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      add_option_dict(sub, pg.Command.OPTS);
      sub.addArgument(["search"], {
        nargs: '?',
        help: "search parameter to find the right key"
      });
      return opts.aliases.concat([name]);
    };

    Command.prototype.check_args = function(cb) {
      var err;
      err = null;
      if (this.argv.search && this.argv.gen) {
        err = new E.ArgsError("Can't both search and generate; pick one or the other!");
      } else if (this.argv.search && this.secret_only()) {
        err = new E.ArgsError("Can't specify a search with secret-only-push; has to correspond to your public");
      }
      return cb(err);
    };

    Command.prototype.load_key = function(cb) {
      return cb(err);
    };

    Command.prototype.prepare_key = function(cb) {
      var did_patch, err, esc, kp, secret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      esc = make_esc(cb, "Command::prepare_key");
      (function(_this) {
        return (function(__iced_k) {
          if (_this.argv.gen) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/command/push.iced",
                funcname: "Command.prepare_key"
              });
              _this.do_key_gen(esc(__iced_deferrals.defer({
                lineno: 64
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            (function(__iced_k) {
              if (_this.secret_only()) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/command/push.iced",
                    funcname: "Command.prepare_key"
                  });
                  load_key({
                    username: env().get_username(),
                    fingerprint: _this.me.fingerprint()
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function(__slot_1) {
                      return function() {
                        return __slot_1.key = arguments[0];
                      };
                    })(_this),
                    lineno: 66
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                if (!_this.argv.show_public_only_keys) {
                  secret = true;
                }
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/command/push.iced",
                    funcname: "Command.prepare_key"
                  });
                  key_select({
                    username: env().get_username(),
                    query: _this.argv.search,
                    secret: secret
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function(__slot_1) {
                      return function() {
                        return __slot_1.key = arguments[0];
                      };
                    })(_this),
                    lineno: 69
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  kp = new KeyPatcher({
                    key: _this.key,
                    opts: _this.argv
                  });
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/node-client/src/command/push.iced",
                      funcname: "Command.prepare_key"
                    });
                    kp.run({
                      interactive: true
                    }, esc(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return did_patch = arguments[0];
                        };
                      })(),
                      lineno: 71
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(did_patch ? _this.key = kp.get_key() : void 0);
                  });
                });
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return Command;

  })(pg.Command);

}).call(this);
