// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Base, Command, E, KeyManager, KeybasePushProofGen, User, athrow, env, iced, log, make_email, make_esc, prompt_passphrase, req, session, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __slice = [].slice;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  session = require('../session');

  make_esc = require('iced-error').make_esc;

  log = require('../log');

  KeybasePushProofGen = require('../sigs').KeybasePushProofGen;

  req = require('../req');

  env = require('../env').env;

  prompt_passphrase = require('../prompter').prompt_passphrase;

  KeyManager = require('../keymanager').KeyManager;

  E = require('../err').E;

  athrow = require('iced-utils').util.athrow;

  env = require('../env').env;

  User = require('../user').User;

  make_email = require('../util').make_email;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    Command.OPTS = {
      s: {
        alias: "secret",
        action: "storeTrue",
        help: "push the secret key to the server"
      },
      u: {
        alias: "update",
        action: "storeTrue",
        help: "update the public key with new key fields"
      }
    };

    function Command() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      Command.__super__.constructor.apply(this, args);
      this._secret_only = false;
    }

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return true;
    };

    Command.prototype.secret_only = function() {
      return this._secret_only;
    };

    Command.prototype.sign = function(cb) {
      var eng, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ Command::sign");
      (function(_this) {
        return (function(__iced_k) {
          if (_this.key.has_canonical_username()) {
            log.debug("| We can skip the sig, since the UID canonical username is already in the key");
            return __iced_k(_this.sig = null);
          } else {
            eng = new KeybasePushProofGen({
              km: _this.key
            });
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                funcname: "Command.sign"
              });
              eng.run(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    err = arguments[0];
                    return __slot_1.sig = arguments[1];
                  };
                })(_this),
                lineno: 56
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- Command::sign");
          return cb(err);
        };
      })(this));
    };

    Command.prototype.push = function(cb) {
      var args, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = {
        is_primary: 1
      };
      if (this.sig != null) {
        args.sig_id_base = this.sig.id;
        args.sig_id_short = this.sig.short_id;
        args.sig = this.sig.pgp;
      }
      if (!this.secret_only()) {
        args.public_key = this.key.key_data().toString('utf8');
      }
      if (this.p3skb) {
        args.private_key = this.p3skb;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.push"
          });
          req.post({
            endpoint: "key/add",
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 73
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.load_key_manager = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyManager::load_secret");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.load_key_manager"
          });
          KeyManager.load({
            fingerprint: _this.key.fingerprint()
          }, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.keymanager = arguments[0];
              };
            })(_this),
            lineno: 80
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    Command.prototype.package_secret_key = function(cb) {
      var err, p3skb, prompter, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ package secret key");
      prompter = this.prompt_passphrase.bind(this);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.package_secret_key"
          });
          _this.keymanager.export_to_p3skb({
            prompter: prompter
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return p3skb = arguments[1];
              };
            })(),
            lineno: 88
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this.p3skb = p3skb;
          }
          log.debug("- package secret key -> " + (typeof err !== "undefined" && err !== null ? err.message : void 0));
          return cb(err);
        };
      })(this));
    };

    Command.prototype.do_secret_key = function(cb) {
      var esc, go, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyManager::do_secret_key");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.do_secret_key"
          });
          _this.should_push_secret(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return go = arguments[0];
              };
            })(),
            lineno: 97
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (go) {
              (function(__iced_k) {
                if (_this.keymanager == null) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                      funcname: "Command.do_secret_key"
                    });
                    _this.load_key_manager(esc(__iced_deferrals.defer({
                      lineno: 99
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                    funcname: "Command.do_secret_key"
                  });
                  _this.package_secret_key(esc(__iced_deferrals.defer({
                    lineno: 100
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              });
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    Command.prototype.prompt_passphrase = function(cb) {
      var args, err, pp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = {
        prompt: "Your key passphrase"
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.prompt_passphrase"
          });
          prompt_passphrase(args, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return pp = arguments[1];
              };
            })(),
            lineno: 108
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, pp);
        };
      })(this));
    };

    Command.prototype.prompt_new_passphrase = function(cb) {
      var args, err, pp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = {
        prompt: "Your key passphrase (can be the same as your login passphrase)",
        confirm: {
          prompt: "Repeat to confirm"
        },
        no_leading_space: true
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.prompt_new_passphrase"
          });
          prompt_passphrase(args, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return pp = arguments[1];
              };
            })(),
            lineno: 118
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, pp);
        };
      })(this));
    };

    Command.prototype.do_key_gen_2 = function(_arg, cb) {
      var done, err, go, passphrase, rv, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      passphrase = _arg.passphrase;
      rv = new iced.Rendezvous();
      process.stderr.write("Generating keys.");
      KeyManager.generate({
        passphrase: passphrase
      }, rv.id(true).defer({
        assign_fn: (function(_this) {
          return function(__slot_1) {
            return function() {
              err = arguments[0];
              return __slot_1.keymanager = arguments[1];
            };
          };
        })(this)(this),
        lineno: 127,
        context: __iced_deferrals
      }));
      go = true;
      (function(_this) {
        return (function(__iced_k) {
          var _results, _while;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!go) {
              return _break();
            } else {
              setTimeout(rv.id(false).defer({
                lineno: 131,
                context: __iced_deferrals
              }), 1000);
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                  funcname: "Command.do_key_gen_2"
                });
                rv.wait(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return done = arguments[0];
                    };
                  })(),
                  lineno: 132
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return _next(done ? go = false : process.stderr.write("."));
              });
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          process.stderr.write(" Done!\n");
          return cb(err);
        };
      })(this));
    };

    Command.prototype.do_key_gen = function(cb) {
      var esc, passphrase, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "do_key_gen");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.do_key_gen"
          });
          _this.prompt_new_passphrase(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return passphrase = arguments[0];
              };
            })(),
            lineno: 144
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.debug("+ generating public/private keypair");
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
              funcname: "Command.do_key_gen"
            });
            _this.do_key_gen_2({
              passphrase: passphrase
            }, esc(__iced_deferrals.defer({
              lineno: 146
            })));
            __iced_deferrals._fulfill();
          })(function() {
            log.debug("- generated");
            log.debug("+ loading public key");
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                funcname: "Command.do_key_gen"
              });
              _this.keymanager.load_public(esc(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    return __slot_1.key = arguments[0];
                  };
                })(_this),
                lineno: 149
              })));
              __iced_deferrals._fulfill();
            })(function() {
              log.debug("- loaded public key");
              return cb(null, _this.key);
            });
          });
        };
      })(this));
    };

    Command.prototype.check_args = function(cb) {
      return cb(null);
    };

    Command.prototype.should_push_secret = function(cb) {
      return cb(null, this.argv.secret || this.secret_only());
    };

    Command.prototype.should_push = function(cb) {
      return cb(null, true);
    };

    Command.prototype.check_no_key = function(cb) {
      var ckres, err, esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "check_no_key");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.check_no_key"
          });
          User.load({
            username: env().get_username(),
            self: true
          }, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.me = arguments[0];
              };
            })(_this),
            lineno: 163
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
              funcname: "Command.check_no_key"
            });
            _this.me.check_key({
              secret: false
            }, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return ckres = arguments[0];
                };
              })(),
              lineno: 164
            })));
            __iced_deferrals._fulfill();
          })(function() {
            err = null;
            if (_this.argv.update && ckres.remote) {
              log.info("Updating both remote keys with local version");
              _this.argv.search = _this.me.fingerprint();
            } else if (_this.argv.update && !ckres.remote) {
              err = new E.NoRemoteKeyError("can't update your key; you don't have one uploaded; try push without --update");
            } else if (ckres.remote && _this.argv.secret) {
              log.info("Public key already uploaded; pushing only secret key");
              _this._secret_only = true;
            } else if (ckres.remote && !_this.argv.secret) {
              err = new E.KeyExistsError("You already have a key registered; either revoke or run `keybase push --update`");
            }
            return cb(err);
          });
        };
      })(this));
    };

    Command.prototype.run = function(cb) {
      var esc, go, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
            funcname: "Command.run"
          });
          _this.check_no_key(esc(__iced_deferrals.defer({
            lineno: 182
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
              funcname: "Command.run"
            });
            _this.check_args(esc(__iced_deferrals.defer({
              lineno: 183
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                funcname: "Command.run"
              });
              _this.prepare_key(esc(__iced_deferrals.defer({
                lineno: 184
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                  funcname: "Command.run"
                });
                _this.should_push(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return go = arguments[0];
                    };
                  })(),
                  lineno: 185
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  if (go) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                        funcname: "Command.run"
                      });
                      session.login(esc(__iced_deferrals.defer({
                        lineno: 187
                      })));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                          funcname: "Command.run"
                        });
                        _this.sign(esc(__iced_deferrals.defer({
                          lineno: 188
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                            funcname: "Command.run"
                          });
                          _this.do_secret_key(esc(__iced_deferrals.defer({
                            lineno: 189
                          })));
                          __iced_deferrals._fulfill();
                        })(function() {
                          (function(__iced_k) {
                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                              parent: ___iced_passed_deferral,
                              filename: "/home/jacko/node-client/src/command/push_and_keygen.iced",
                              funcname: "Command.run"
                            });
                            _this.push(esc(__iced_deferrals.defer({
                              lineno: 190
                            })));
                            __iced_deferrals._fulfill();
                          })(__iced_k);
                        });
                      });
                    });
                  } else {
                    return __iced_k();
                  }
                })(function() {
                  log.info("success!");
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
