// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, KeyManager, KeyPull, PullTypes, TmpKeyRing, User, athrow, chain_err, colors, env, format_fingerprint, iced, log, make_esc, master_ring, prompt_yn, req, session, __iced_k, __iced_k_noop, _ref, _ref1, _ref2;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  session = require('./session').session;

  _ref = require('iced-error'), chain_err = _ref.chain_err, make_esc = _ref.make_esc;

  env = require('./env').env;

  log = require('./log');

  User = require('./user').User;

  req = require('./req');

  KeyManager = require('./keymanager').KeyManager;

  E = require('./err').E;

  _ref1 = require('./keyring'), TmpKeyRing = _ref1.TmpKeyRing, master_ring = _ref1.master_ring;

  prompt_yn = require('./prompter').prompt_yn;

  colors = require('./colors');

  _ref2 = require('pgp-utils').util, format_fingerprint = _ref2.format_fingerprint, athrow = _ref2.athrow;

  PullTypes = {
    ERROR: -1,
    NONE: 0,
    SECRET: 1,
    PUBLIC: 2
  };

  exports.KeyPull = KeyPull = (function() {
    function KeyPull(_arg) {
      this.force = _arg.force, this.stdin_blocked = _arg.stdin_blocked, this.need_secret = _arg.need_secret;
    }

    KeyPull.prototype.secret_pull = function(cb) {
      var args, err, esc, km, p3skb, passphrase, prompter, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ KeyPull::secret_pull");
      esc = make_esc(cb, "KeyPull::secret_pull");
      (function(_this) {
        return (function(__iced_k) {
          if ((p3skb = _this.me.private_key_bundle()) == null) {
            return __iced_k(err = new E.NoLocalKeyError("couldn't find a private key bundle for you"));
          } else {
            err = null;
            passphrase = null;
            args = {
              extra: " (to pull your private key from the server)",
              stderr: true
            };
            prompter = function(cb) {
              var err, passphrase, ___iced_passed_deferral1, __iced_deferrals, __iced_k;
              __iced_k = __iced_k_noop;
              ___iced_passed_deferral1 = iced.findDeferral(arguments);
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral1,
                  filename: "/home/jacko/node-client/src/keypull.iced"
                });
                session.get_passphrase(args, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      err = arguments[0];
                      return passphrase = arguments[1];
                    };
                  })(),
                  lineno: 44
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return cb(err, passphrase);
              });
            };
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/keypull.iced",
                funcname: "KeyPull.secret_pull"
              });
              KeyManager.import_from_p3skb({
                raw: p3skb,
                prompter: prompter
              }, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return km = arguments[0];
                  };
                })(),
                lineno: 46
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/keypull.iced",
                  funcname: "KeyPull.secret_pull"
                });
                km.save_to_ring({
                  passphrase: passphrase
                }, esc(__iced_deferrals.defer({
                  lineno: 47
                })));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(log.info("Pulled secret key (" + (format_fingerprint(_this.me.fingerprint(true))) + ")"));
              });
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- KeyPull::secret_pull");
          return cb(err);
        };
      })(this));
    };

    KeyPull.prototype.load_user = function(cb) {
      var err, esc, pub, pull_needed, sec, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ KeyPull::load_user");
      esc = make_esc(cb, "KeyPull::load_user");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/keypull.iced",
            funcname: "KeyPull.load_user"
          });
          User.load({
            username: env().get_username(),
            require_public_key: false,
            cache: true,
            self: true,
            secret: true
          }, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.me = arguments[0];
              };
            })(_this),
            lineno: 59
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/keypull.iced",
              funcname: "KeyPull.load_user"
            });
            _this.me.check_key({
              secret: true
            }, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return sec = arguments[0];
                };
              })(),
              lineno: 60
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/keypull.iced",
                funcname: "KeyPull.load_user"
              });
              _this.me.check_key({
                secret: false
              }, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return pub = arguments[0];
                  };
                })(),
                lineno: 61
              })));
              __iced_deferrals._fulfill();
            })(function() {
              log.debug("Check key secret: " + (JSON.stringify(sec)));
              log.debug("Check key public: " + (JSON.stringify(pub)));
              err = null;
              pull_needed = !pub.remote ? (err = new E.NoRemoteKeyError("you don't have a public key; try `keybase push` if you have a key; or `keybase gen` if you don't"), PullTypes.ERROR) : sec.remote && !sec.local && _this.need_secret ? PullTypes.SECRET : _this.need_secret && !sec.local ? (err = new E.NoRemoteKeyError("can't perform secret-key action without a secret key"), PullTypes.ERROR) : pub.local && (!sec.remote || sec.local) && !_this.force ? PullTypes.NONE : sec.remote && (!sec.local || _this.force) ? PullTypes.SECRET : PullTypes.PUBLIC;
              log.debug("- KeyPull::load_user -> " + err + " " + pull_needed);
              return cb(err, pull_needed);
            });
          });
        };
      })(this));
    };

    KeyPull.prototype.prompt_ok = function(warnings, proofs, cb) {
      var err, prompt, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      prompt = warnings > 0 ? (log.console.error(colors.red(colors.bold("Some of your hosted proofs failed!"))), "Do you still accept these credentials to be your own?") : proofs === 0 ? "We found your account, but you have no hosted proofs. Check your fingerprint carefully. Is this you?" : "Is this you?";
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/keypull.iced",
            funcname: "KeyPull.prompt_ok"
          });
          prompt_yn({
            prompt: prompt,
            defval: false
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ret = arguments[1];
              };
            })(),
            lineno: 91
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (!ret && !(typeof err !== "undefined" && err !== null)) {
            err = new E.CancelError("key import operation canceled");
          }
          return cb(err);
        };
      })(this));
    };

    KeyPull.prototype.public_pull = function(cb) {
      var esc, key, n_proofs, tmp_keyring, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      tmp_keyring = null;
      log.debug("+ KeyPull::public_pull");
      cb = chain_err(cb, function(tcb) {
        var e2, ___iced_passed_deferral1, __iced_deferrals, __iced_k;
        __iced_k = __iced_k_noop;
        ___iced_passed_deferral1 = iced.findDeferral(arguments);
        (function(_this) {
          return (function(__iced_k) {
            if (tmp_keyring != null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral1,
                  filename: "/home/jacko/node-client/src/keypull.iced"
                });
                tmp_keyring.nuke(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return e2 = arguments[0];
                    };
                  })(),
                  lineno: 105
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(typeof e2 !== "undefined" && e2 !== null ? log.warn("Problem in cleanup: " + e2.message) : void 0);
              });
            } else {
              return __iced_k();
            }
          });
        })(this)((function(_this) {
          return function() {
            return tcb(null);
          };
        })(this));
      });
      esc = make_esc(cb, "KeyPull::public_pull");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/keypull.iced",
            funcname: "KeyPull.public_pull"
          });
          TmpKeyRing.make(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return tmp_keyring = arguments[0];
              };
            })(),
            lineno: 110
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/keypull.iced",
              funcname: "KeyPull.public_pull"
            });
            _this.me.import_public_keys({
              keyring: tmp_keyring
            }, esc(__iced_deferrals.defer({
              lineno: 111
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/keypull.iced",
                funcname: "KeyPull.public_pull"
              });
              _this.me.check_remote_proofs({}, esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    warnings = arguments[0];
                    return n_proofs = arguments[1];
                  };
                })(),
                lineno: 112
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/keypull.iced",
                  funcname: "KeyPull.public_pull"
                });
                _this.prompt_ok(warnings.warnings().length, n_proofs, esc(__iced_deferrals.defer({
                  lineno: 113
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  var _i, _len, _ref3, _results, _while;
                  _ref3 = _this.me.gpg_keys;
                  _len = _ref3.length;
                  _i = 0;
                  _results = [];
                  _while = function(__iced_k) {
                    var _break, _continue, _next;
                    _break = function() {
                      return __iced_k(_results);
                    };
                    _continue = function() {
                      return iced.trampoline(function() {
                        ++_i;
                        return _while(__iced_k);
                      });
                    };
                    _next = function(__iced_next_arg) {
                      _results.push(__iced_next_arg);
                      return _continue();
                    };
                    if (!(_i < _len)) {
                      return _break();
                    } else {
                      key = _ref3[_i];
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/jacko/node-client/src/keypull.iced",
                          funcname: "KeyPull.public_pull"
                        });
                        key.commit({}, esc(__iced_deferrals.defer({
                          lineno: 115
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        return _next(log.info("Pulled public key (" + (format_fingerprint(key.fingerprint().toString('hex').toUpperCase())) + ")"));
                      });
                    }
                  };
                  _while(__iced_k);
                })(function() {
                  log.debug("- KeyPull::public_pull");
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    KeyPull.prototype.run = function(cb) {
      var err, esc, pull_type, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      log.debug("+ KeyPull::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/keypull.iced",
            funcname: "KeyPull.run"
          });
          _this.load_user(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return pull_type = arguments[0];
              };
            })(),
            lineno: 125
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((pull_type !== PullTypes.NONE) && _this.stdin_blocked) {
              err = new E.NoLocalKeyError("Can't fetch your private key since you're performing a stream action; try an explicit `keybase pull`");
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/keypull.iced",
                  funcname: "KeyPull.run"
                });
                athrow(err, esc(__iced_deferrals.defer({
                  lineno: 128
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              switch (pull_type) {
                case PullTypes.SECRET:
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/keypull.iced",
                      funcname: "KeyPull.run"
                    });
                    _this.secret_pull(esc(__iced_deferrals.defer({
                      lineno: 131
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                  break;
                case PullTypes.PUBLIC:
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/keypull.iced",
                      funcname: "KeyPull.run"
                    });
                    _this.public_pull(esc(__iced_deferrals.defer({
                      lineno: 133
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                  break;
                default:
                  return __iced_k();
              }
            })(function() {
              log.debug("- KeyPull::run");
              return cb(null);
            });
          });
        };
      })(this));
    };

    return KeyPull;

  })();

  exports.keypull = function(opts, cb) {
    var err, kp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    kp = new KeyPull(opts);
    (function(_this) {
      return (function(__iced_k) {
        __iced_deferrals = new iced.Deferrals(__iced_k, {
          parent: ___iced_passed_deferral,
          filename: "/home/jacko/node-client/src/keypull.iced",
          funcname: "keypull"
        });
        kp.run(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return err = arguments[0];
            };
          })(),
          lineno: 141
        }));
        __iced_deferrals._fulfill();
      });
    })(this)((function(_this) {
      return function() {
        return cb(err);
      };
    })(this));
  };

}).call(this);
