// Generated by IcedCoffeeScript 1.7.1-f
(function() {
  var KeyInstall, chain, fpeq, hash_json, iced, keyring, log, make_esc, __iced_k, __iced_k_noop;

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  make_esc = require('iced-error').make_esc;

  chain = require('iced-utils').util.chain;

  keyring = require('gpg-wrapper').keyring;

  fpeq = require('pgp-utils').util.fpeq;

  hash_json = require('./util').hash_json;

  log = require('./log');

  exports.KeyInstall = KeyInstall = (function() {
    function KeyInstall(config, keyset) {
      this.config = config;
      this._keyset = keyset;
      this._tmp_keyring = null;
      this._keys = {};
    }

    KeyInstall.prototype.make_tmp_keyring = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("| KeyInstaller::make_tmp_keyring");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
            funcname: "KeyInstall.make_tmp_keyring"
          });
          keyring.QuarantinedKeyRing.make(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1._tmp_keyring = arguments[1];
              };
            })(_this),
            lineno: 23
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    KeyInstall.prototype.cleanup = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ Cleaning up tmp keyring " + this._tmp_keyring);
      (function(_this) {
        return (function(__iced_k) {
          if (_this._tmp_keyring != null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
                funcname: "KeyInstall.cleanup"
              });
              _this._tmp_keyring.nuke(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 31
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(typeof err !== "undefined" && err !== null ? log.warn("Error cleaning up temporary keyring: " + err.message) : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- Cleaning up tmp keyring " + _this._tmp_keyring);
          return cb();
        };
      })(this));
    };

    KeyInstall.prototype.temporary_import = function(cb) {
      var a, b, err, esc, fps, k, msg, source, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyInstaller::temporary_import");
      log.debug("+ KeyInstaller::temporary_import");
      source = this._keyset.keys.code;
      this._keys.code = k = this._tmp_keyring.make_key({
        key_data: source.key_data,
        fingerprint: source.fingerprint,
        username: "code@keybase.io"
      });
      this._tmp_keyring.set_fingerprint(source.fingerprint);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
            funcname: "KeyInstall.temporary_import"
          });
          k.save(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 50
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
              funcname: "KeyInstall.temporary_import"
            });
            _this._tmp_keyring.list_fingerprints(esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return fps = arguments[0];
                };
              })(),
              lineno: 51
            })));
            __iced_deferrals._fulfill();
          })(function() {
            msg = fps.length === 0 ? "key save failed; no fingerprints" : fps.length > 1 ? "keyring corruption; too many fingerprints found" : !fpeq((a = fps[0]), (b = _this._keyset.keys.code.fingerprint)) ? "fingerprint mismatch after import: " + a + " != " + b : void 0;
            err = msg != null ? new Error(msg) : null;
            log.debug("- KeyInstaller::temporary_import");
            return cb(err);
          });
        };
      })(this));
    };

    KeyInstall.prototype.check_self_sig = function(cb) {
      var err, payload, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      sig = this._keyset.self_sig;
      this._keyset.self_sig = null;
      log.debug("+ KeyInstaller::check_self_sig");
      payload = hash_json(this._keyset);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
            funcname: "KeyInstall.check_self_sig"
          });
          _this._keys.code.verify_sig({
            which: "self sig on keyset",
            payload: payload,
            sig: sig
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 69
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- KeyInstaller::check_self_sig");
          return cb(err);
        };
      })(this));
    };

    KeyInstall.prototype.full_import = function(cb) {
      var esc, k, master, source, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyInstall::full_import");
      log.debug("+ KeyInstaller::full_import");
      master = this.config.master_ring();
      source = this._keyset.keys.index;
      this._keys.index = k = master.make_key({
        key_data: source.key_data,
        fingerprint: source.fingerprint,
        username: "index@keybase.io"
      });
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
            funcname: "KeyInstall.full_import"
          });
          k.save(esc(__iced_deferrals.defer({
            lineno: 85
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
              funcname: "KeyInstall.full_import"
            });
            _this._keys.code.commit({
              ring: master
            }, esc(__iced_deferrals.defer({
              lineno: 86
            })));
            __iced_deferrals._fulfill();
          })(function() {
            log.debug("- KeyInstaller::full_import");
            return cb(null);
          });
        };
      })(this));
    };

    KeyInstall.prototype.revoke_1 = function(k, v, cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("| Revoking key " + k);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
            funcname: "KeyInstall.revoke_1"
          });
          keyring.master_ring().gpg({
            args: ["--import"],
            stdin: v,
            quiet: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 94
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    KeyInstall.prototype.revoke_all = function(cb) {
      var esc, k, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyInstall::revoke_all");
      (function(_this) {
        return (function(__iced_k) {
          if (_this._keyset.revocation != null) {
            (function(__iced_k) {
              var _i, _k, _keys, _ref, _results, _while;
              _ref = _this._keyset.revocation;
              _keys = (function() {
                var _results1;
                _results1 = [];
                for (_k in _ref) {
                  _results1.push(_k);
                }
                return _results1;
              })();
              _i = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_i;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_i < _keys.length)) {
                  return _break();
                } else {
                  k = _keys[_i];
                  v = _ref[k];
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
                      funcname: "KeyInstall.revoke_all"
                    });
                    _this.revoke_1(k, v, esc(__iced_deferrals.defer({
                      lineno: 103
                    })));
                    __iced_deferrals._fulfill();
                  })(_next);
                }
              };
              _while(__iced_k);
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    KeyInstall.prototype.keys = function() {
      return this._keys;
    };

    KeyInstall.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeyInstall:run2");
      log.debug("+ KeyInstaller::run");
      log.info("Installing keyset version " + this._keyset.version);
      cb = chain(cb, this.cleanup.bind(this));
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
            funcname: "KeyInstall.run"
          });
          _this.make_tmp_keyring(esc(__iced_deferrals.defer({
            lineno: 117
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
              funcname: "KeyInstall.run"
            });
            _this.temporary_import(esc(__iced_deferrals.defer({
              lineno: 118
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
                funcname: "KeyInstall.run"
              });
              _this.check_self_sig(esc(__iced_deferrals.defer({
                lineno: 119
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
                  funcname: "KeyInstall.run"
                });
                _this.full_import(esc(__iced_deferrals.defer({
                  lineno: 120
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-installer/src/key_install.iced",
                    funcname: "KeyInstall.run"
                  });
                  _this.revoke_all(esc(__iced_deferrals.defer({
                    lineno: 121
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  log.debug("- KeyInstaller::run");
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    return KeyInstall;

  })();

}).call(this);
