// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var BaseScraper, constants, decode_sig, iced, pkg, sncmp, space_normalize, user_agent, v_codes, __iced_k, __iced_k_noop;

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  constants = require('../constants').constants;

  v_codes = constants.v_codes;

  pkg = require('../../package.json');

  decode_sig = require('kbpgp').ukm.decode_sig;

  space_normalize = require('../util').space_normalize;

  exports.user_agent = user_agent = constants.user_agent + pkg.version;

  BaseScraper = (function() {
    function BaseScraper(_arg) {
      var log_level;
      this.libs = _arg.libs, log_level = _arg.log_level, this.proxy = _arg.proxy, this.ca = _arg.ca;
      this.log_level = log_level || "debug";
    }

    BaseScraper.prototype.hunt = function(username, proof_check_text, cb) {
      return hunt2({
        username: username,
        proof_check_text: proof_check_text
      }, cb);
    };

    BaseScraper.prototype.hunt2 = function(args, cb) {
      return cb(new Error("unimplemented"));
    };

    BaseScraper.prototype.id_to_url = function(username, status_id) {};

    BaseScraper.prototype.check_status = function(_arg, cb) {
      var signature, status_id, url, username;
      username = _arg.username, url = _arg.url, signature = _arg.signature, status_id = _arg.status_id;
    };

    BaseScraper.prototype._check_args = function() {
      return new Error("unimplemented");
    };

    BaseScraper.prototype.get_tor_error = function(args) {
      return [null, v_codes.OK];
    };

    BaseScraper.prototype.logl = function(level, msg) {
      var k;
      if ((k = this.libs.log) != null) {
        return k[level](msg);
      }
    };

    BaseScraper.prototype.log = function(msg) {
      var k;
      if (((k = this.libs.log) != null) && (this.log_level != null)) {
        return k[this.log_level](msg);
      }
    };

    BaseScraper.prototype.validate = function(args, cb) {
      var err, rc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      rc = null;
      if ((err = this._check_args(args))) {

      } else if (!this._check_api_url(args)) {
        err = new Error("check url failed for " + (JSON.stringify(args)));
      } else {
        err = this._validate_text_check(args);
      }
      (function(_this) {
        return (function(__iced_k) {
          if (err == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/keybase-proofs/src/scrapers/base.iced",
                funcname: "BaseScraper.validate"
              });
              _this.check_status(args, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return rc = arguments[1];
                  };
                })(),
                lineno: 49
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, rc);
        };
      })(this));
    };

    BaseScraper.prototype._validate_text_check = function(_arg) {
      var err, msg, proof_text_check, signature, _ref;
      signature = _arg.signature, proof_text_check = _arg.proof_text_check;
      _ref = decode_sig({
        armored: signature
      }), err = _ref[0], msg = _ref[1];
      if ((err == null) && ("\n\n" + msg.payload + "\n") !== proof_text_check && msg.payload !== proof_text_check) {
        err = new Error("Bad payload text_check");
      }
      return err;
    };

    BaseScraper.prototype._stripr = function(m) {
      return m.split('\r').join('');
    };

    BaseScraper.prototype._find_sig_in_raw = function(proof_text_check, raw) {
      return space_normalize(raw).indexOf(space_normalize(proof_text_check)) >= 0;
    };

    BaseScraper.prototype._get_url_body = function(opts, cb) {
      var body, err, rc, response, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);

      /*
        cb(err, status, body) only replies with body if status is 200
       */
      body = null;
      if (this.proxy != null) {
        opts.proxy = this.proxy;
      }
      if (this.ca != null) {
        opts.ca = this.ca;
      }
      if (opts.timeout == null) {
        opts.timeout = constants.http_timeout;
      }
      opts.headers || (opts.headers = {});
      opts.headers["User-Agent"] = user_agent;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/keybase-proofs/src/scrapers/base.iced",
            funcname: "BaseScraper._get_url_body"
          });
          _this.libs.request(opts, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                response = arguments[1];
                return body = arguments[2];
              };
            })(),
            lineno: 85
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref;
          rc = typeof err !== "undefined" && err !== null ? err.code === 'ETIMEDOUT' ? v_codes.TIMEOUT : v_codes.HOST_UNREACHABLE : ((_ref = response.statusCode) === 401 || _ref === 403) ? v_codes.PERMISSION_DENIED : response.statusCode === 200 ? v_codes.OK : response.statusCode >= 500 ? v_codes.HTTP_500 : response.statusCode >= 400 ? v_codes.HTTP_400 : response.statusCode >= 300 ? v_codes.HTTP_300 : v_codes.HTTP_OTHER;
          return cb(err, rc, body);
        };
      })(this));
    };

    return BaseScraper;

  })();

  exports.BaseScraper = BaseScraper;

  exports.sncmp = sncmp = function(a, b) {
    if ((a == null) || (b == null)) {
      return false;
    } else {
      a = ("" + a).toLowerCase();
      b = ("" + b).toLowerCase();
      return a === b;
    }
  };

}).call(this);
