/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.configuration;

import org.pdfsam.configuration.EnhancedClassloaderProvider;
import org.pdfsam.configuration.LoggerConfig;
import org.pdfsam.configuration.PdfsamConfig;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class ApplicationContextHolder {
    private AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();

    private ApplicationContextHolder() {
        this.ctx.setClassLoader(EnhancedClassloaderProvider.classLoader(this.ctx.getClassLoader()));
        this.ctx.register(LoggerConfig.class);
        this.ctx.register(PdfsamConfig.class);
        this.ctx.getEnvironment().setActiveProfiles(this.ctx.getEnvironment().getProperty("pdfsam.edition", "COMMUNITY"));
        this.ctx.scan("org.pdfsam");
        this.ctx.registerShutdownHook();
        this.ctx.refresh();
    }

    public static AnnotationConfigApplicationContext getContext() {
        return DefaultApplicationContextHolder.CONTEXT.ctx;
    }

    private static final class DefaultApplicationContextHolder {
        static final ApplicationContextHolder CONTEXT = new ApplicationContextHolder();

        private DefaultApplicationContextHolder() {
        }
    }
}

