/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.merge;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.merge.MergeParametersBuilder;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.pdf.form.AcroFormPolicy;

class MergeOptionsPane
extends VBox
implements TaskParametersBuildStep<MergeParametersBuilder>,
RestorableView {
    private ComboBox<KeyStringValueItem<AcroFormPolicy>> acroForms = new ComboBox();
    private CheckBox blankIfOdd;
    private ComboBox<KeyStringValueItem<OutlinePolicy>> outline = new ComboBox();

    MergeOptionsPane() {
        super(5.0);
        this.blankIfOdd = new CheckBox(DefaultI18nContext.getInstance().i18n("Add a blank page if page number is odd"));
        this.blankIfOdd.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Adds a blank page after each merged document if the document has an odd number of pages")));
        this.blankIfOdd.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.blankIfOdd.setId("blankIfOddCheck");
        this.acroForms.getItems().add(KeyStringValueItem.keyValue(AcroFormPolicy.MERGE, DefaultI18nContext.getInstance().i18n("Merge fields")));
        this.acroForms.getItems().add(KeyStringValueItem.keyValue(AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS, DefaultI18nContext.getInstance().i18n("Merge renaming existing fields")));
        this.acroForms.getItems().add(KeyStringValueItem.keyValue(AcroFormPolicy.DISCARD, DefaultI18nContext.getInstance().i18n("Discard forms")));
        this.acroForms.getSelectionModel().selectFirst();
        this.acroForms.setId("acroFormsCombo");
        HBox formsPolicy = new HBox(new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Interactive forms (AcroForms):")), this.acroForms});
        formsPolicy.getStyleClass().addAll((Object[])Style.VITEM.css());
        formsPolicy.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.RETAIN, DefaultI18nContext.getInstance().i18n("Retain bookmarks")));
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.DISCARD, DefaultI18nContext.getInstance().i18n("Discard bookmarks")));
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.ONE_ENTRY_EACH_DOC, DefaultI18nContext.getInstance().i18n("Create one entry for each merged document")));
        this.outline.getItems().add(KeyStringValueItem.keyValue(OutlinePolicy.RETAIN_AS_ONE_ENTRY, DefaultI18nContext.getInstance().i18n("Retain bookmarks as one entry for each merged document")));
        this.outline.getSelectionModel().selectFirst();
        this.outline.setId("outlineCombo");
        HBox bookmarksPolicy = new HBox(new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Bookmarks handling:")), this.outline});
        bookmarksPolicy.getStyleClass().addAll((Object[])Style.VITEM.css());
        bookmarksPolicy.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{this.blankIfOdd, formsPolicy, bookmarksPolicy});
    }

    @Override
    public void apply(MergeParametersBuilder builder, Consumer<String> onError) {
        builder.outlinePolicy((OutlinePolicy)((KeyStringValueItem)this.outline.getSelectionModel().getSelectedItem()).getKey());
        builder.acroFormsPolicy((AcroFormPolicy)((KeyStringValueItem)this.acroForms.getSelectionModel().getSelectedItem()).getKey());
        builder.blankPageIfOdd(this.blankIfOdd.isSelected());
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("outline", Optional.ofNullable(this.outline.getSelectionModel().getSelectedItem()).map(i -> ((OutlinePolicy)i.getKey()).toString()).orElse(""));
        data.put("acroForms", Optional.ofNullable(this.acroForms.getSelectionModel().getSelectedItem()).map(i -> ((AcroFormPolicy)i.getKey()).toString()).orElse(""));
        data.put("blankIfOdd", Boolean.toString(this.blankIfOdd.isSelected()));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("outline")).map(OutlinePolicy::valueOf).map(r -> KeyStringValueItem.keyEmptyValue(r)).ifPresent(r -> this.outline.getSelectionModel().select(r));
        Optional.ofNullable(data.get("acroForms")).map(AcroFormPolicy::valueOf).map(r -> KeyStringValueItem.keyEmptyValue(r)).ifPresent(r -> this.acroForms.getSelectionModel().select(r));
        this.blankIfOdd.setSelected(Boolean.valueOf(data.get("blankIfOdd")).booleanValue());
    }
}

