/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.merge;

import java.util.Set;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.SingleOutputTaskParametersBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.parameter.MergeParameters;
import org.sejda.model.pdf.form.AcroFormPolicy;

class MergeParametersBuilder
extends AbstractPdfOutputParametersBuilder<MergeParameters>
implements SingleOutputTaskParametersBuilder<MergeParameters> {
    private Set<PdfMergeInput> inputs = new NullSafeSet<PdfMergeInput>();
    private OutlinePolicy outlinePolicy = OutlinePolicy.RETAIN;
    private boolean blankIfOdd;
    private AcroFormPolicy formsPolicy = AcroFormPolicy.MERGE;
    private FileTaskOutput output;

    MergeParametersBuilder() {
    }

    void addInput(PdfMergeInput input) {
        this.inputs.add(input);
    }

    boolean hasInput() {
        return !this.inputs.isEmpty();
    }

    void outlinePolicy(OutlinePolicy outlinePolicy) {
        this.outlinePolicy = outlinePolicy;
    }

    void blankPageIfOdd(boolean blankIfOdd) {
        this.blankIfOdd = blankIfOdd;
    }

    void acroFormsPolicy(AcroFormPolicy formsPolicy) {
        this.formsPolicy = formsPolicy;
    }

    @Override
    public void output(FileTaskOutput output) {
        this.output = output;
    }

    @Override
    public MergeParameters build() {
        MergeParameters params = new MergeParameters();
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        this.inputs.forEach(params::addInput);
        params.setOutlinePolicy(this.outlinePolicy);
        params.setBlankPageIfOdd(this.blankIfOdd);
        params.setAcroFormPolicy(this.formsPolicy);
        params.setOutput(this.output);
        return params;
    }
}

