/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.File;
import java.util.Set;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.OutlineDistiller;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskCancelledException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesExtractor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PagesExtractor.class);
    private OutlineDistiller outlineMerger;
    private PDDocument originalDocument;
    private PDDocumentHandler destinationDocument;
    private LookupTable<PDPage> pagesLookup = new LookupTable();

    public PagesExtractor(PDDocument origin) {
        this.originalDocument = origin;
        this.init();
    }

    private void init() {
        this.outlineMerger = new OutlineDistiller(this.originalDocument);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.initialiseBasedOn(this.originalDocument);
    }

    public void retain(Set<Integer> pages, NotifiableTaskMetadata taskMetadata) throws TaskCancelledException {
        int currentStep = 0;
        for (Integer page : pages) {
            taskMetadata.stopTaskIfCancelled();
            this.retain(page);
            ApplicationEventsNotifier.notifyEvent(taskMetadata).stepsCompleted(++currentStep).outOf(pages.size());
        }
    }

    public void retain(int page) {
        PDPage existingPage = this.originalDocument.getPage(page - 1);
        this.pagesLookup.addLookupEntry(existingPage, this.destinationDocument.importPage(existingPage));
        LOG.trace("Imported page number {}", (Object)page);
    }

    public void setVersion(PdfVersion version) {
        this.destinationDocument.setVersionOnPDDocument(version);
    }

    public void setCompress(boolean compress) {
        this.destinationDocument.setCompress(compress);
    }

    public void save(File file) throws TaskException {
        this.createOutline();
        LookupTable<PDAnnotation> annotations = Annotations.processAnnotations(this.pagesLookup, this.originalDocument);
        SignatureClipper.clipSignatures(annotations.values());
        this.destinationDocument.savePDDocument(file);
    }

    private void createOutline() {
        PDDocumentOutline outline = new PDDocumentOutline();
        this.outlineMerger.appendRelevantOutlineTo(outline, this.pagesLookup);
        if (outline.hasChildren()) {
            this.destinationDocument.setDocumentOutline(outline);
        }
    }

    @Override
    public void close() {
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
        this.pagesLookup.clear();
        this.outlineMerger = null;
    }

    protected PDDocumentHandler destinationDocument() {
        return this.destinationDocument;
    }

    public void reset() {
        this.close();
        this.init();
    }
}

