/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.WriteOption;
import org.sejda.util.RequireUtils;

abstract class AbstractPDFBodyWriter
implements COSVisitor,
Closeable {
    private Queue<IndirectCOSObjectReference> stack = new LinkedList<IndirectCOSObjectReference>();
    private PDFWriteContext context;
    private boolean open = true;

    AbstractPDFBodyWriter(PDFWriteContext context) {
        RequireUtils.requireNotNullArg(context, "Write context cannot be null");
        this.context = context;
    }

    PDFWriteContext context() {
        return this.context;
    }

    public void write(COSDocument document) throws IOException {
        RequireUtils.requireState(this.open, "The writer is closed");
        document.accept(this);
    }

    @Override
    public void visit(COSDocument document) throws IOException {
        for (COSName k : Arrays.asList(COSName.ROOT, COSName.INFO)) {
            COSBase value = document.getTrailer().getItem(k);
            if (value == null) continue;
            this.createIndirectReferenceIfNeededFor(value);
        }
        this.startWriting();
    }

    void startWriting() throws IOException {
        IndirectCOSObjectReference item;
        while ((item = this.stack.poll()) != null) {
            item.getCOSObject().accept(this);
            this.writeObject(item);
        }
        this.onCompletion();
    }

    abstract void writeObject(IndirectCOSObjectReference var1) throws IOException;

    abstract void onCompletion() throws IOException;

    @Override
    public void visit(COSArray array) throws IOException {
        for (int i = 0; i < array.size(); ++i) {
            COSBase item = Optional.ofNullable(array.get(i)).orElse(COSNull.NULL);
            if (item instanceof ExistingIndirectCOSObject || item instanceof COSDictionary) {
                this.createIndirectReferenceIfNeededFor(item);
                continue;
            }
            item.accept(this);
        }
    }

    @Override
    public void visit(COSDictionary value) throws IOException {
        for (COSName key : value.keySet()) {
            COSBase item = Optional.ofNullable(value.getItem(key)).orElse(COSNull.NULL);
            if (item instanceof ExistingIndirectCOSObject || item instanceof COSDictionary || COSName.THREADS.equals(key)) {
                this.createIndirectReferenceIfNeededFor(item);
                continue;
            }
            item.accept(this);
        }
    }

    @Override
    public void visit(COSStream value) throws IOException {
        value.removeItem(COSName.LENGTH);
        if (this.context.hasWriteOption(WriteOption.COMPRESS_STREAMS)) {
            value.addCompression();
        }
        this.visit((COSDictionary)value);
    }

    void createIndirectReferenceIfNeededFor(COSBase item) {
        if (!this.context.hasIndirectReferenceFor(item)) {
            this.stack.add(this.context.getOrCreateIndirectReferenceFor(item));
        }
    }

    @Override
    public void visit(COSBoolean value) {
    }

    @Override
    public void visit(COSFloat value) {
    }

    @Override
    public void visit(COSInteger value) {
    }

    @Override
    public void visit(COSName value) {
    }

    @Override
    public void visit(COSNull value) {
    }

    @Override
    public void visit(COSString value) {
    }

    @Override
    public void visit(IndirectCOSObjectReference value) {
    }

    @Override
    public void close() throws IOException {
        this.context = null;
        this.open = false;
    }
}

