/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.AbstractPDFBodyWriter;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncPDFBodyWriter
extends AbstractPDFBodyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncPDFBodyWriter.class);
    private ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(null, target, "pdf-writer-thread", 0L);
        }
    });
    private AtomicReference<IOException> executionException = new AtomicReference();
    private IndirectObjectsWriter writer;

    AsyncPDFBodyWriter(IndirectObjectsWriter writer, PDFWriteContext context) {
        super(context);
        RequireUtils.requireNotNullArg(writer, "Cannot write to a null writer");
        this.writer = writer;
    }

    @Override
    void onCompletion() throws IOException {
        this.assertCanSubmitAsyncTask();
        try {
            this.executor.submit(() -> {
                IOException previous = this.executionException.get();
                if (previous != null) {
                    throw previous;
                }
                LOG.debug("Written document body");
                return null;
            }).get();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    @Override
    void writeObject(IndirectCOSObjectReference ref) throws IOException {
        this.assertCanSubmitAsyncTask();
        this.executor.execute(() -> {
            try {
                if (this.executionException.get() == null) {
                    this.writer.writeObjectIfNotWritten(ref);
                }
            }
            catch (IOException e) {
                this.executionException.set(e);
            }
            catch (Exception e) {
                this.executionException.set(new IOException(e));
            }
        });
    }

    private void assertCanSubmitAsyncTask() throws IOException {
        IOException previous = this.executionException.get();
        if (previous != null) {
            this.executor.shutdownNow();
            throw previous;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.executor.shutdown();
    }
}

