/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;
import org.sejda.sambox.pdmodel.encryption.DecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.MessageDigests;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.RC4Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    private static final int DEFAULT_KEY_LENGTH = 40;
    private static final byte[] AES_SALT = new byte[]{115, 65, 108, 84};
    protected int keyLength = 40;
    protected byte[] encryptionKey;
    private final RC4Cipher rc4 = new RC4Cipher();
    private boolean decryptMetadata;
    private final Set<COSBase> objects = new HashSet<COSBase>();
    private boolean useAES;
    private AccessPermission currentAccessPermission = null;

    protected void setDecryptMetadata(boolean decryptMetadata) {
        this.decryptMetadata = decryptMetadata;
    }

    public abstract void prepareDocumentForEncryption(PDDocument var1) throws IOException;

    public abstract void prepareForDecryption(PDEncryption var1, COSArray var2, DecryptionMaterial var3) throws IOException;

    private void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output, boolean decrypt) throws IOException {
        if (this.useAES && this.encryptionKey.length == 32) {
            this.encryptDataAES256(data, output, decrypt);
        } else {
            if (this.useAES && !decrypt) {
                throw new IllegalArgumentException("AES encryption with key length other than 256 bits is not yet implemented.");
            }
            byte[] finalKey = this.calcFinalKey(objectNumber, genNumber);
            if (this.useAES) {
                this.encryptDataAESother(finalKey, data, output, decrypt);
            } else {
                this.encryptDataRC4(finalKey, data, output);
            }
        }
        org.sejda.util.IOUtils.close(output);
    }

    private byte[] calcFinalKey(long objectNumber, long genNumber) {
        byte[] newKey = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
        newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
        newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
        newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
        newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
        newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        MessageDigest md = MessageDigests.getMD5();
        md.update(newKey);
        if (this.useAES) {
            md.update(AES_SALT);
        }
        byte[] digestedKey = md.digest();
        int length = Math.min(newKey.length, 16);
        byte[] finalKey = new byte[length];
        System.arraycopy(digestedKey, 0, finalKey, 0, length);
        return finalKey;
    }

    protected void encryptDataRC4(byte[] finalKey, InputStream input, OutputStream output) throws IOException {
        this.rc4.setKey(finalKey);
        this.rc4.write(input, output);
    }

    protected void encryptDataRC4(byte[] finalKey, byte[] input, OutputStream output) throws IOException {
        this.rc4.setKey(finalKey);
        this.rc4.write(input, output);
    }

    private void encryptDataAESother(byte[] finalKey, InputStream data, OutputStream output, boolean decrypt) throws IOException {
        byte[] iv = new byte[16];
        int ivSize = data.read(iv);
        if (ivSize != iv.length) {
            throw new IOException("AES initialization vector not fully read: only " + ivSize + " bytes read instead of " + iv.length);
        }
        try {
            int n;
            Cipher decryptCipher;
            try {
                decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SecretKeySpec aesKey = new SecretKeySpec(finalKey, "AES");
            IvParameterSpec ips = new IvParameterSpec(iv);
            decryptCipher.init(decrypt ? 2 : 1, (Key)aesKey, ips);
            byte[] buffer = new byte[256];
            while ((n = data.read(buffer)) != -1) {
                byte[] update = decryptCipher.update(buffer, 0, n);
                if (update == null) continue;
                output.write(update);
            }
            output.write(decryptCipher.doFinal());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptDataAES256(InputStream data, OutputStream output, boolean decrypt) throws IOException {
        Cipher cipher;
        byte[] iv = new byte[16];
        if (decrypt) {
            data.read(iv);
        } else {
            SecureRandom rnd = new SecureRandom();
            rnd.nextBytes(iv);
            output.write(iv);
        }
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(this.encryptionKey, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(decrypt ? 2 : 1, (Key)keySpec, ivSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        try (CipherInputStream cis = new CipherInputStream(data, cipher);){
            IOUtils.copy((InputStream)cis, output);
        }
    }

    public void decrypt(COSBase obj, long objNum, long genNum) throws IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof COSString) {
                this.decryptString((COSString)obj, objNum, genNum);
            } else if (obj instanceof COSStream) {
                this.decryptStream((COSStream)obj, objNum, genNum);
            } else if (obj instanceof COSDictionary) {
                this.decryptDictionary((COSDictionary)obj, objNum, genNum);
            } else if (obj instanceof COSArray) {
                this.decryptArray((COSArray)obj, objNum, genNum);
            }
        }
    }

    public void decryptStream(COSStream stream, long objNum, long genNum) throws IOException {
        if (!this.decryptMetadata && COSName.METADATA.equals(stream.getCOSName(COSName.TYPE))) {
            return;
        }
        if (COSName.XREF.equals(stream.getCOSName(COSName.TYPE))) {
            return;
        }
        this.decryptDictionary(stream, objNum, genNum);
        byte[] encrypted = IOUtils.toByteArray(stream.getFilteredStream());
        ByteArrayInputStream encryptedStream = new ByteArrayInputStream(encrypted);
        try (OutputStream output = stream.createFilteredStream();){
            this.encryptData(objNum, genNum, encryptedStream, output, true);
        }
    }

    public void encryptStream(COSStream stream, long objNum, int genNum) throws IOException {
        byte[] rawData = IOUtils.toByteArray(stream.getFilteredStream());
        ByteArrayInputStream encryptedStream = new ByteArrayInputStream(rawData);
        try (OutputStream output = stream.createFilteredStream();){
            this.encryptData(objNum, genNum, encryptedStream, output, false);
        }
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws IOException {
        if (dictionary.getItem(COSName.CF) != null) {
            return;
        }
        if (!COSName.SIG.equals(dictionary.getItem(COSName.TYPE)) && !COSName.SIG.equals(dictionary.getItem(COSName.FT))) {
            for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
                COSBase value = entry.getValue();
                if (!(value instanceof COSString) && !(value instanceof COSArray) && !(value instanceof COSDictionary)) continue;
                this.decrypt(value, objNum, genNum);
            }
        }
    }

    private void decryptString(COSString string, long objNum, long genNum) throws IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer, true);
        string.setValue(buffer.toByteArray());
    }

    public void encryptString(COSString string, long objNum, int genNum) throws IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer, false);
        string.setValue(buffer.toByteArray());
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws IOException {
        for (int i = 0; i < array.size(); ++i) {
            this.decrypt(array.get(i), objNum, genNum);
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLen) {
        this.keyLength = keyLen;
    }

    public void setCurrentAccessPermission(AccessPermission currentAccessPermission) {
        this.currentAccessPermission = currentAccessPermission;
    }

    public AccessPermission getCurrentAccessPermission() {
        return this.currentAccessPermission;
    }

    public boolean isAES() {
        return this.useAES;
    }

    public void setAES(boolean aesValue) {
        this.useAES = aesValue;
    }

    public abstract boolean hasProtectionPolicy();
}

