/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ObjectInputStreamClassLoaderAware
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public ObjectInputStreamClassLoaderAware(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException {
        return Class.forName(BlacklistClassResolver.DEFAULT.check(objectStreamClass.getName()), false, this.classLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i], false, this.classLoader);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    private static class BlacklistClassResolver {
        private static final BlacklistClassResolver DEFAULT = new BlacklistClassResolver(BlacklistClassResolver.toArray(System.getProperty("jcs.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections.functors.,org.apache.xalan")), BlacklistClassResolver.toArray(System.getProperty("jcs.serialization.class.whitelist")));
        private final String[] blacklist;
        private final String[] whitelist;

        protected BlacklistClassResolver(String[] stringArray, String[] stringArray2) {
            this.whitelist = stringArray2;
            this.blacklist = stringArray;
        }

        protected boolean isBlacklisted(String string) {
            return this.whitelist != null && !BlacklistClassResolver.contains(this.whitelist, string) || BlacklistClassResolver.contains(this.blacklist, string);
        }

        public final String check(String string) {
            if (this.isBlacklisted(string)) {
                throw new SecurityException(string + " is not whitelisted as deserialisable, prevented before loading.");
            }
            return string;
        }

        private static String[] toArray(String string) {
            return string == null ? null : string.split(" *, *");
        }

        private static boolean contains(String[] stringArray, String string) {
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (!string.startsWith(string2)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

