#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.4.3
id: esqueleto-2.4.3-31e08b67f9a71a3c46b81c06d317b814
key: esque_20bDpgY8dV2G4wxcfx1u6j
license: BSD3
copyright: (c) 2012-2015 Felipe Almeida Lessa
maintainer: felipe.lessa@gmail.com
homepage: https://github.com/prowdsponsor/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/prowdsponsor/esqueleto/>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.PostgreSQL
    Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql
hidden-modules: Database.Esqueleto.Internal.PersistentImport
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/esqueleto-2.4.3
library-dirs: /usr/lib/ghc-7.10.3/site-local/esqueleto-2.4.3
data-dir: /usr/share/arm-linux-ghc-7.10.3/esqueleto-2.4.3
hs-libraries: HSesqueleto-2.4.3-20bDpgY8dV2G4wxcfx1u6j
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    blaze-html-0.8.1.1-59ea4b5f01886f370857b4d16361c2fc
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    conduit-1.2.6.2-e9736ac2851958c9940f374454cdc4fe
    monad-logger-0.3.18-1a8cc90bb0cf2afc03da9e875eb23203
    persistent-2.2.4-bd2986a850822d0f7f277144476772ce
    resourcet-1.1.7.2-b95e5d14f30eaa21587bc62eeb9aed0c
    tagged-0.8.3-aa128de4449752177a05765fb0ce3959
    text-1.2.2.0-2f82ea4adfdd656d9a8840ad2ee17cc0
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    unordered-containers-0.2.7.0-03f1d2fb96e30aca19bb1467e9476c22
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
