/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenMatcher;
import org.languagetool.rules.patterns.Unifier;

public abstract class AbstractPatternRulePerformer {
    protected boolean prevMatched;
    protected AbstractPatternRule rule;
    protected Unifier unifier;
    protected AnalyzedTokenReadings[] unifiedTokens;

    protected AbstractPatternRulePerformer(AbstractPatternRule rule, Unifier unifier) {
        this.rule = rule;
        this.unifier = unifier;
    }

    protected List<PatternTokenMatcher> createElementMatchers() {
        ArrayList<PatternTokenMatcher> patternTokenMatchers = new ArrayList<PatternTokenMatcher>(this.rule.patternTokens.size());
        for (PatternToken pToken : this.rule.patternTokens) {
            PatternTokenMatcher matcher = new PatternTokenMatcher(pToken);
            patternTokenMatchers.add(matcher);
        }
        return patternTokenMatchers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, PatternTokenMatcher matcher, PatternTokenMatcher prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        int i;
        boolean thisMatched = false;
        int numberOfReadings = tokens[tokenNo].getReadingsLength();
        matcher.prepareAndGroup(firstMatchToken, tokens, this.rule.getLanguage());
        for (i = 0; i < numberOfReadings; ++i) {
            AnalyzedToken matchToken = tokens[tokenNo].getAnalyzedToken(i);
            boolean tested = false;
            boolean bl = this.prevMatched = this.prevMatched || prevSkipNext > 0 && prevElement != null && prevElement.isMatchedByScopeNextException(matchToken);
            if (this.prevMatched) {
                return false;
            }
            if (!thisMatched) {
                thisMatched = matcher.isMatched(matchToken);
                tested = true;
            }
            if (!(thisMatched || prevElement != null && prevElement.getPatternToken().getExceptionList() != null)) {
                if (matcher.getPatternToken().getPOStag() == null) {
                    if (!matcher.getPatternToken().isInflected()) return false;
                    if (tokens[tokenNo].hasSameLemmas()) {
                        return false;
                    }
                } else if (!matcher.getPatternToken().getPOSNegation() && !tokens[tokenNo].isTagged()) {
                    return false;
                }
            }
            if (!this.rule.isGroupsOrUnification() || matcher.getPatternToken().isUnificationNeutral()) continue;
            thisMatched &= this.testUnificationAndGroups(thisMatched, i + 1 == numberOfReadings, matchToken, matcher, tested);
        }
        if (thisMatched) {
            for (i = 0; i < numberOfReadings; ++i) {
                if (!matcher.isExceptionMatchedCompletely(tokens[tokenNo].getAnalyzedToken(i))) continue;
                return false;
            }
            if (tokenNo > 0 && matcher.hasPreviousException() && matcher.isMatchedByPreviousException(tokens[tokenNo - 1])) {
                return false;
            }
            if (matcher.getPatternToken().isUnificationNeutral()) {
                this.unifier.addNeutralElement(tokens[tokenNo]);
            }
        }
        if (matcher.getPatternToken().getChunkTag() != null) {
            thisMatched &= tokens[tokenNo].getChunkTags().contains(matcher.getPatternToken().getChunkTag()) ^ matcher.getPatternToken().getNegation();
        }
        if (!matcher.getPatternToken().hasAndGroup()) return thisMatched;
        for (PatternToken e : matcher.getPatternToken().getAndGroup()) {
            if (e.getChunkTag() == null) continue;
            thisMatched &= tokens[tokenNo].getChunkTags().contains(e.getChunkTag()) ^ e.getNegation();
        }
        return thisMatched;
    }

    protected boolean testUnificationAndGroups(boolean matched, boolean lastReading, AnalyzedToken matchToken, PatternTokenMatcher elemMatcher, boolean alreadyTested) {
        boolean thisMatched = matched;
        boolean elemIsMatched = alreadyTested || elemMatcher.isMatched(matchToken);
        PatternToken elem = elemMatcher.getPatternToken();
        if (this.rule.testUnification) {
            if (matched && elem.isUnified()) {
                if (elem.isUniNegated()) {
                    thisMatched = !this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                } else if (elem.isLastInUnification()) {
                    thisMatched = this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                    if (thisMatched && this.rule.isGetUnified()) {
                        this.unifiedTokens = this.unifier.getFinalUnified();
                    }
                } else {
                    this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                }
            }
            if (!elem.isUnified()) {
                this.unifier.reset();
            }
        }
        elemMatcher.addMemberAndGroup(matchToken);
        if (lastReading) {
            thisMatched &= elemMatcher.checkAndGroup(thisMatched);
        }
        return thisMatched;
    }

    protected int getMinOccurrenceCorrection() {
        int minOccurCorrection = 0;
        for (PatternToken patternToken : this.rule.getPatternTokens()) {
            if (patternToken.getMinOccurrence() != 0) continue;
            ++minOccurCorrection;
        }
        return minOccurCorrection;
    }

    protected int skipMaxTokens(AnalyzedTokenReadings[] tokens, PatternTokenMatcher elem, int firstMatchToken, int prevSkipNext, PatternTokenMatcher prevElement, int m, int remainingElems) throws IOException {
        int maxSkip = 0;
        int maxOccurrences = elem.getPatternToken().getMaxOccurrence() == -1 ? Integer.MAX_VALUE : elem.getPatternToken().getMaxOccurrence();
        for (int j = 1; j < maxOccurrences && m + j < tokens.length - remainingElems; ++j) {
            boolean nextAllElementsMatch;
            boolean bl = nextAllElementsMatch = !tokens[m + j].isImmunized() && this.testAllReadings(tokens, elem, prevElement, m + j, firstMatchToken, prevSkipNext);
            if (!nextAllElementsMatch) break;
            ++maxSkip;
        }
        return maxSkip;
    }
}

