/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFinalStatesIterator;
import morfologik.fsa.FSATraversal;
import morfologik.fsa.MatchResult;
import morfologik.stemming.ArrayViewList;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryIterator;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import morfologik.util.BufferUtils;

public final class DictionaryLookup
implements IStemmer,
Iterable<WordData> {
    private static final int REMOVE_EVERYTHING = 255;
    private final FSATraversal matcher;
    private final FSAFinalStatesIterator finalStatesIterator;
    private final int rootNode;
    private static final int EXPAND_SIZE = 10;
    private WordData[] forms = new WordData[0];
    private final ArrayViewList<WordData> formsList = new ArrayViewList<WordData>(this.forms, 0, this.forms.length);
    private final DictionaryMetadata dictionaryMetadata;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final FSA fsa;
    private final char separatorChar;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private CharBuffer charBuffer = CharBuffer.allocate(0);
    private final MatchResult matchResult = new MatchResult();
    private final Dictionary dictionary;

    public DictionaryLookup(Dictionary dictionary) throws IllegalArgumentException {
        this.dictionary = dictionary;
        this.dictionaryMetadata = dictionary.metadata;
        this.rootNode = dictionary.fsa.getRootNode();
        this.fsa = dictionary.fsa;
        this.matcher = new FSATraversal(this.fsa);
        this.finalStatesIterator = new FSAFinalStatesIterator(this.fsa, this.fsa.getRootNode());
        if (this.rootNode == 0) {
            throw new IllegalArgumentException("Dictionary must have at least the root node.");
        }
        if (this.dictionaryMetadata == null) {
            throw new IllegalArgumentException("Dictionary metadata must not be null.");
        }
        this.decoder = dictionary.metadata.getDecoder();
        this.encoder = dictionary.metadata.getEncoder();
        this.separatorChar = dictionary.metadata.getSeparatorAsChar();
    }

    @Override
    public List<WordData> lookup(CharSequence word) {
        int arc;
        byte separator = this.dictionaryMetadata.getSeparator();
        if (!this.dictionaryMetadata.getInputConversionPairs().isEmpty()) {
            word = Dictionary.convertText(word, this.dictionaryMetadata.getInputConversionPairs());
        }
        this.formsList.wrap((WordData[])this.forms, 0, 0);
        this.charBuffer.clear();
        this.charBuffer = BufferUtils.ensureCapacity((CharBuffer)this.charBuffer, (int)word.length());
        for (int i = 0; i < word.length(); ++i) {
            char chr = word.charAt(i);
            if (chr == this.separatorChar) {
                return this.formsList;
            }
            this.charBuffer.put(chr);
        }
        this.charBuffer.flip();
        this.byteBuffer = this.charsToBytes(this.charBuffer, this.byteBuffer);
        MatchResult match = this.matcher.match(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (match.kind == -4 && (arc = this.fsa.getArc(match.node, separator)) != 0 && !this.fsa.isArcFinal(arc)) {
            int formsCount = 0;
            this.finalStatesIterator.restartFrom(this.fsa.getEndNode(arc));
            while (this.finalStatesIterator.hasNext()) {
                int tagSize;
                int sepPos;
                ByteBuffer bb = this.finalStatesIterator.next();
                byte[] ba = bb.array();
                int bbSize = bb.remaining();
                if (formsCount >= this.forms.length) {
                    this.forms = Arrays.copyOf(this.forms, this.forms.length + 10);
                    for (int k = 0; k < this.forms.length; ++k) {
                        if (this.forms[k] != null) continue;
                        this.forms[k] = new WordData(this.decoder);
                    }
                }
                WordData wordData = this.forms[formsCount++];
                wordData.reset();
                wordData.wordBuffer = this.byteBuffer;
                wordData.wordCharSequence = this.dictionaryMetadata.getOutputConversionPairs().isEmpty() ? word : Dictionary.convertText(word, this.dictionaryMetadata.getOutputConversionPairs());
                for (sepPos = 0; sepPos < bbSize && ba[sepPos] != separator; ++sepPos) {
                }
                wordData.stemBuffer.clear();
                wordData.stemBuffer = DictionaryLookup.decodeBaseForm(wordData.stemBuffer, ba, sepPos, this.byteBuffer, this.dictionaryMetadata);
                wordData.stemBuffer.flip();
                if ((tagSize = bbSize - ++sepPos) <= 0) continue;
                wordData.tagBuffer = BufferUtils.ensureCapacity((ByteBuffer)wordData.tagBuffer, (int)tagSize);
                wordData.tagBuffer.clear();
                wordData.tagBuffer.put(ba, sepPos, tagSize);
                wordData.tagBuffer.flip();
            }
            this.formsList.wrap((WordData[])this.forms, 0, formsCount);
        }
        return this.formsList;
    }

    public static ByteBuffer decodeBaseForm(ByteBuffer output, byte[] encoded, int encodedLen, ByteBuffer inflectedForm, DictionaryMetadata metadata) {
        output.clear();
        assert (inflectedForm.position() == 0);
        byte[] src = inflectedForm.array();
        int srcLen = inflectedForm.remaining();
        if (output.capacity() < srcLen + encodedLen) {
            output = ByteBuffer.allocate(srcLen + encodedLen);
        }
        switch (metadata.getEncoderType()) {
            case SUFFIX: {
                byte suffixTrimCode = encoded[0];
                int truncateBytes = suffixTrimCode - 65 & 0xFF;
                if (truncateBytes == 255) {
                    truncateBytes = srcLen;
                }
                output.put(src, 0, srcLen - truncateBytes);
                output.put(encoded, 1, encodedLen - 1);
                break;
            }
            case PREFIX: {
                int truncatePrefixBytes = encoded[0] - 65 & 0xFF;
                int truncateSuffixBytes = encoded[1] - 65 & 0xFF;
                if (truncatePrefixBytes == 255 || truncateSuffixBytes == 255) {
                    truncatePrefixBytes = srcLen;
                    truncateSuffixBytes = 0;
                }
                output.put(src, truncatePrefixBytes, srcLen - (truncateSuffixBytes + truncatePrefixBytes));
                output.put(encoded, 2, encodedLen - 2);
                break;
            }
            case INFIX: {
                int infixIndex = encoded[0] - 65 & 0xFF;
                int infixLength = encoded[1] - 65 & 0xFF;
                int truncateSuffixBytes = encoded[2] - 65 & 0xFF;
                if (infixLength == 255 || truncateSuffixBytes == 255) {
                    infixIndex = 0;
                    infixLength = srcLen;
                    truncateSuffixBytes = 0;
                }
                output.put(src, 0, infixIndex);
                output.put(src, infixIndex + infixLength, srcLen - (infixIndex + infixLength + truncateSuffixBytes));
                output.put(encoded, 3, encodedLen - 3);
                break;
            }
            case NONE: {
                output.put(encoded, 0, encodedLen);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled switch/case: " + (Object)((Object)metadata.getEncoderType()));
            }
        }
        return output;
    }

    private ByteBuffer charsToBytes(CharBuffer chars, ByteBuffer bytes) {
        bytes.clear();
        int maxCapacity = (int)((float)chars.remaining() * this.encoder.maxBytesPerChar());
        if (bytes.capacity() <= maxCapacity) {
            bytes = ByteBuffer.allocate(maxCapacity);
        }
        chars.mark();
        this.encoder.reset();
        if (this.encoder.encode(chars, bytes, true).isError()) {
            bytes.clear();
        }
        bytes.flip();
        chars.reset();
        return bytes;
    }

    @Override
    public Iterator<WordData> iterator() {
        return new DictionaryIterator(this.dictionary, this.decoder, true);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }
}

