/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class BaseResourceFactory
implements ResourceFactory {
    private static final Map<Image, Texture> texCache = new WeakHashMap<Image, Texture>();
    private final WeakHashMap<ResourceFactoryListener, Boolean> listenerMap = new WeakHashMap();

    @Override
    public void addFactoryListener(ResourceFactoryListener resourceFactoryListener) {
        this.listenerMap.put(resourceFactoryListener, Boolean.TRUE);
    }

    @Override
    public void removeFactoryListener(ResourceFactoryListener resourceFactoryListener) {
        this.listenerMap.remove(resourceFactoryListener);
    }

    @Override
    public boolean isDeviceReady() {
        return true;
    }

    protected void clearTextureCache() {
        Collection<Texture> collection = texCache.values();
        for (Texture texture : collection) {
            texture.dispose();
        }
        texCache.clear();
    }

    protected ResourceFactoryListener[] getFactoryListeners() {
        return this.listenerMap.keySet().toArray(new ResourceFactoryListener[0]);
    }

    protected void notifyReset() {
        ResourceFactoryListener[] resourceFactoryListenerArray;
        texCache.clear();
        for (ResourceFactoryListener resourceFactoryListener : resourceFactoryListenerArray = this.getFactoryListeners()) {
            if (null == resourceFactoryListener) continue;
            resourceFactoryListener.factoryReset();
        }
    }

    protected void notifyReleased() {
        ResourceFactoryListener[] resourceFactoryListenerArray;
        texCache.clear();
        for (ResourceFactoryListener resourceFactoryListener : resourceFactoryListenerArray = this.getFactoryListeners()) {
            if (null == resourceFactoryListener) continue;
            resourceFactoryListener.factoryReleased();
        }
    }

    @Override
    public Texture getCachedTexture(Image image) {
        return this.getCachedTexture(image, true);
    }

    @Override
    public Texture getCachedTexture(Image image, boolean bl) {
        if (image == null) {
            throw new IllegalArgumentException("Image must be non-null");
        }
        Texture texture = texCache.get(image);
        int n = image.getSerial();
        if (texture == null) {
            texture = this.createTexture(image, Texture.Usage.DEFAULT, bl);
            if (texture == null) {
                this.clearTextureCache();
                texture = this.createTexture(image, Texture.Usage.DEFAULT, bl);
            }
            if (texture != null) {
                texture.setLastImageSerial(n);
            }
            texCache.put(image, texture);
        } else if (texture.getLastImageSerial() != n) {
            texture.update(image, 0, 0, image.getWidth(), image.getHeight(), false);
            texture.setLastImageSerial(n);
        }
        return texture;
    }

    @Override
    public Texture createTexture(Image image) {
        return this.createTexture(image, Texture.Usage.DEFAULT, true);
    }

    @Override
    public Texture createTexture(Image image, Texture.Usage usage, boolean bl) {
        int n;
        int n2;
        PixelFormat pixelFormat = image.getPixelFormat();
        Texture texture = this.createTexture(pixelFormat, usage, n2 = image.getWidth(), n = image.getHeight(), bl);
        if (texture != null) {
            texture.update(image, 0, 0, n2, n, true);
        }
        return texture;
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, int n, int n2) {
        return this.createTexture(pixelFormat, usage, n, n2, true);
    }

    @Override
    public Texture createMaskTexture(int n, int n2) {
        return this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DEFAULT, n, n2, false);
    }

    @Override
    public Texture createFloatTexture(int n, int n2) {
        return this.createTexture(PixelFormat.FLOAT_XYZW, Texture.Usage.DEFAULT, n, n2, false);
    }
}

