/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import org.owasp.jbrofuzz.system.Logger;

public class WireTextArea
extends JTextArea {
    private static final long serialVersionUID = 2094145846515459112L;

    public WireTextArea() {
    }

    private WireTextArea(StyledDocument doc) {
        super(doc);
    }

    @Override
    public Font getFont() {
        return new Font("Verdana", 0, 10);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public Color getBackground() {
        return Color.BLACK;
    }

    @Override
    public Color getForeground() {
        return Color.GREEN;
    }

    @Override
    protected Document createDefaultModel() {
        return new PlainDocument(){
            private static final long serialVersionUID = 7378012766038129491L;
            private static final int MAX_VALUE = 65535;

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                int overflow = offs + str.length() - 65535;
                if (overflow > 0) {
                    super.insertString(offs, str.substring(65535 - offs), a);
                } else {
                    super.insertString(offs, str, a);
                }
            }
        };
    }

    @Override
    public void setText(String t) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, t, null);
            this.setCaretPosition(doc.getLength());
        }
        catch (BadLocationException e) {
            Logger.log("WireTextArea: Bad Location Exception", 3);
        }
    }
}

