/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Date;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class AbstractPluginUnitTest {
    private static AbstractPlugin createAbstractPluginWithConfig() {
        return AbstractPluginUnitTest.createAbstractPluginWithConfig(0);
    }

    private static AbstractPlugin createAbstractPluginWithConfig(int n) {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin(n);
        abstractPlugin.setConfig((Configuration)new ZapXmlConfiguration());
        return abstractPlugin;
    }

    private static AbstractPlugin createAbstractPlugin() {
        return AbstractPluginUnitTest.createAbstractPlugin(0);
    }

    private static AbstractPlugin createAbstractPlugin(int n) {
        return new TestPlugin(n);
    }

    private static Plugin createNonAbstractPlugin() {
        return new PluginImpl();
    }

    @Test
    public void shouldNotHaveConfigByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void shouldRetrieveConfigSet() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        abstractPlugin.setConfig((Configuration)zapXmlConfiguration);
        Assert.assertThat((Object)abstractPlugin.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)zapXmlConfiguration))));
    }

    @Test
    public void shouldRetrieveClassNameForCodeName() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.getCodeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"AbstractPluginUnitTest$TestPlugin")));
    }

    @Test
    public void shouldRetrieveUndefinedWascId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.getWascId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldRetrieveUndefinedCweId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.getCweId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldRetrieveMediumRiskByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.getRisk(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
    }

    @Test
    public void shouldRetrieveZeroDelayInMsByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.getDelayInMs(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldRetrieveDelaySet() {
        int n = 1234;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        abstractPlugin.setDelayInMs(n);
        Assert.assertThat((Object)abstractPlugin.getDelayInMs(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)n)));
    }

    @Test
    public void shouldRetrieveUnkownStatusByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)((Object)abstractPlugin.getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)AddOn.Status.unknown))));
    }

    @Test
    public void shouldRetrieveStatusSet() {
        AddOn.Status status = AddOn.Status.example;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        abstractPlugin.setStatus(status);
        Assert.assertThat((Object)((Object)abstractPlugin.getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)status))));
    }

    @Test
    public void shouldBeEnabledByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)abstractPlugin.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.TRUE)));
    }

    @Test(expected=Exception.class)
    public void shouldFailWhenSettingEnabledStateWithoutConfig() {
        AbstractPluginUnitTest.createAbstractPlugin().setEnabled(false);
    }

    @Test
    public void shouldRetrieveEnabledStateSet() {
        boolean bl = false;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setEnabled(bl);
        Assert.assertThat((Object)abstractPlugin.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)bl)));
    }

    @Test
    public void shouldRetrieveMediumAttackStrengthByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AttackStrength.MEDIUM))));
    }

    @Test(expected=Exception.class)
    public void shouldFailWhenSettingAttackStrengthWithoutConfig() {
        AbstractPluginUnitTest.createAbstractPlugin().setAttackStrength(Plugin.AttackStrength.INSANE);
    }

    @Test
    public void shouldRetrieveAttackStrengthSet() {
        Plugin.AttackStrength attackStrength = Plugin.AttackStrength.INSANE;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAttackStrength(attackStrength);
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)attackStrength))));
    }

    @Test
    public void shouldRetrieveDefaultAttackStrengthByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AttackStrength.DEFAULT))));
    }

    @Test
    public void shouldRetrieveDefaultAttackStrengthSet() {
        Plugin.AttackStrength attackStrength = Plugin.AttackStrength.LOW;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.DEFAULT);
        abstractPlugin.setDefaultAttackStrength(attackStrength);
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength(false)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)attackStrength))));
    }

    @Test
    public void shouldRetrieveDefaultAttackStrengthSetAsDefault() {
        Plugin.AttackStrength attackStrength = Plugin.AttackStrength.DEFAULT;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.LOW);
        abstractPlugin.setAttackStrength(attackStrength);
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)attackStrength))));
    }

    @Test
    public void shouldRetrieveMediumAlertThresholdByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.MEDIUM))));
    }

    @Test(expected=Exception.class)
    public void shouldFailWhenSettingAlertThresholdWithoutConfig() {
        AbstractPluginUnitTest.createAbstractPlugin().setAlertThreshold(Plugin.AlertThreshold.DEFAULT);
    }

    @Test
    public void shouldRetrieveAlertThresholdSet() {
        Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.HIGH;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(alertThreshold);
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)alertThreshold))));
    }

    @Test
    public void shouldDisablePluginWhenAlertThresholdSetToOff() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.HIGH);
        abstractPlugin.setEnabled(true);
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.OFF);
        Assert.assertThat((Object)abstractPlugin.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.FALSE)));
    }

    @Test
    public void shouldEnablePluginWhenAlertThresholdSetToNonOff() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.OFF);
        abstractPlugin.setEnabled(false);
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.HIGH);
        Assert.assertThat((Object)abstractPlugin.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.TRUE)));
    }

    @Test
    public void shouldSetAlertThresholdToDefaultWhenEnablingPluginWithOffAlertThreshold() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.OFF);
        abstractPlugin.setEnabled(true);
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.DEFAULT))));
    }

    @Test
    public void shouldRetrieveDefaultAlertThresholdByDefault() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.DEFAULT))));
    }

    @Test
    public void shouldRetrieveOffAlertThresholdByDefaultIfDisabled() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setEnabled(false);
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.OFF))));
    }

    @Test
    public void shouldRetrieveDefaultAlertThresholdSet() {
        Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.LOW;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.DEFAULT);
        abstractPlugin.setDefaultAlertThreshold(alertThreshold);
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold(false)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)alertThreshold))));
    }

    @Test
    public void shouldRetrieveDefaultAlertThresholdSetAsDefault() {
        Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.DEFAULT;
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.LOW);
        abstractPlugin.setAlertThreshold(alertThreshold);
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)alertThreshold))));
    }

    @Test(expected=Exception.class)
    public void shouldFailToCloneIntoNonAbstractPlugin() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        Plugin plugin = AbstractPluginUnitTest.createNonAbstractPlugin();
        abstractPlugin.cloneInto(plugin);
    }

    @Test(expected=Exception.class)
    public void shouldFailToCloneIntoPluginWithoutConfig() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPlugin();
        abstractPlugin.cloneInto(abstractPlugin2);
    }

    @Test
    public void shouldCloneIntoPlugin() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.HIGH);
        abstractPlugin.setDefaultAlertThreshold(Plugin.AlertThreshold.MEDIUM);
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.INSANE);
        abstractPlugin.setDefaultAttackStrength(Plugin.AttackStrength.LOW);
        abstractPlugin.setTechSet(TechSet.AllTech);
        abstractPlugin.setStatus(AddOn.Status.beta);
        abstractPlugin.setEnabled(false);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPluginWithConfig();
        abstractPlugin.cloneInto(abstractPlugin2);
        Assert.assertThat((Object)abstractPlugin.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)abstractPlugin2.isEnabled())));
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)abstractPlugin2.getAlertThreshold()))));
        Assert.assertThat((Object)((Object)abstractPlugin.getAlertThreshold(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)abstractPlugin2.getAlertThreshold(true)))));
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)abstractPlugin2.getAttackStrength()))));
        Assert.assertThat((Object)((Object)abstractPlugin.getAttackStrength(true)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)abstractPlugin2.getAttackStrength(true)))));
        Assert.assertThat((Object)abstractPlugin.getTechSet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)abstractPlugin2.getTechSet())));
        Assert.assertThat((Object)((Object)abstractPlugin.getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)abstractPlugin2.getStatus()))));
    }

    @Test
    public void shouldNotBeEqualToNonAbstractPlugin() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        Plugin plugin = AbstractPluginUnitTest.createNonAbstractPlugin();
        boolean bl = abstractPlugin.equals(plugin);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void shouldNotBeEqualToAbstractPluginWithDifferentId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin(1);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPlugin(5);
        boolean bl = abstractPlugin.equals(abstractPlugin2);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void shouldBeEqualToAbstractPluginWithSameId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin(1);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPlugin(1);
        boolean bl = abstractPlugin.equals(abstractPlugin2);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldBeLesserThanAbstractPluginWithGreaterId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin(1);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPlugin(10);
        int n = abstractPlugin.compareTo(abstractPlugin2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)-1)));
    }

    @Test
    public void shouldBeSameAsAbstractPluginWithSameId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin(10);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPlugin(10);
        int n = abstractPlugin.compareTo(abstractPlugin2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldBeGreaterThanAbstractPluginWithLesserId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin(10);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPlugin(1);
        int n = abstractPlugin.compareTo(abstractPlugin2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test(expected=Exception.class)
    public void shouldFailToLoadFromConfigIfConfigNotSet() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        abstractPlugin.loadFrom((Configuration)zapXmlConfiguration);
    }

    @Test
    public void shouldNotLoadFromConfigIfPluginHasDifferentId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig(10);
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.HIGH);
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.INSANE);
        abstractPlugin.setEnabled(false);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPluginWithConfig(15);
        abstractPlugin2.loadFrom(abstractPlugin.getConfig());
        Assert.assertThat((Object)abstractPlugin2.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.TRUE)));
        Assert.assertThat((Object)((Object)abstractPlugin2.getAlertThreshold()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.MEDIUM))));
        Assert.assertThat((Object)((Object)abstractPlugin2.getAttackStrength()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AttackStrength.MEDIUM))));
    }

    @Test
    public void shouldLoadFromConfigIfPluginsHaveSameId() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig(10);
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.HIGH);
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.INSANE);
        abstractPlugin.setEnabled(false);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPluginWithConfig(10);
        abstractPlugin2.loadFrom(abstractPlugin.getConfig());
        Assert.assertThat((Object)abstractPlugin2.isEnabled(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.FALSE)));
        Assert.assertThat((Object)((Object)abstractPlugin2.getAlertThreshold()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.HIGH))));
        Assert.assertThat((Object)((Object)abstractPlugin2.getAttackStrength()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)Plugin.AttackStrength.INSANE))));
    }

    @Test
    public void shouldJustSaveEnabledStateToOwnConfigWhenLoadFromEmptyConfig() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig(15);
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        Configuration configuration = abstractPlugin.getConfig();
        String string = "plugins.p" + abstractPlugin.getId() + ".";
        abstractPlugin.loadFrom((Configuration)zapXmlConfiguration);
        Assert.assertThat((Object)configuration.getString(string + "enabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"true")));
        Assert.assertThat((Object)configuration.getString(string + "level"), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        Assert.assertThat((Object)configuration.getString(string + "strength"), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void shouldSaveToOwnConfigWhenLoadFromOtherConfig() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig(10);
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.LOW);
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.HIGH);
        abstractPlugin.setEnabled(false);
        AbstractPlugin abstractPlugin2 = AbstractPluginUnitTest.createAbstractPluginWithConfig(10);
        Configuration configuration = abstractPlugin2.getConfig();
        String string = "plugins.p" + abstractPlugin2.getId() + ".";
        abstractPlugin2.loadFrom(abstractPlugin.getConfig());
        Assert.assertThat((Object)configuration.getString(string + "enabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"false")));
        Assert.assertThat((Object)configuration.getString(string + "level"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Plugin.AlertThreshold.LOW.name())));
        Assert.assertThat((Object)configuration.getString(string + "strength"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Plugin.AttackStrength.HIGH.name())));
    }

    @Test(expected=Exception.class)
    public void shouldFailToSaveToConfigIfConfigNotSet() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPlugin();
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        abstractPlugin.saveTo((Configuration)zapXmlConfiguration);
    }

    @Test
    public void shouldSaveToConfig() {
        AbstractPlugin abstractPlugin = AbstractPluginUnitTest.createAbstractPluginWithConfig(10);
        abstractPlugin.setAlertThreshold(Plugin.AlertThreshold.HIGH);
        abstractPlugin.setAttackStrength(Plugin.AttackStrength.INSANE);
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        String string = "plugins.p" + abstractPlugin.getId() + ".";
        abstractPlugin.saveTo((Configuration)zapXmlConfiguration);
        Assert.assertThat((Object)zapXmlConfiguration.getString(string + "enabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"true")));
        Assert.assertThat((Object)zapXmlConfiguration.getString(string + "level"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Plugin.AlertThreshold.HIGH.name())));
        Assert.assertThat((Object)zapXmlConfiguration.getString(string + "strength"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Plugin.AttackStrength.INSANE.name())));
    }

    private static class PluginImpl
    implements Plugin {
        private PluginImpl() {
        }

        @Override
        public void run() {
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getCodeName() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int getRisk() {
            return 0;
        }

        @Override
        public void init(HttpMessage httpMessage, HostProcess hostProcess) {
        }

        @Override
        public void scan() {
        }

        @Override
        public String[] getDependency() {
            return null;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public int getCategory() {
            return 0;
        }

        @Override
        public String getSolution() {
            return null;
        }

        @Override
        public String getReference() {
            return null;
        }

        @Override
        public void notifyPluginCompleted(HostProcess hostProcess) {
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void setConfig(Configuration configuration) {
        }

        @Override
        public Configuration getConfig() {
            return null;
        }

        @Override
        public void saveTo(Configuration configuration) {
        }

        @Override
        public void loadFrom(Configuration configuration) {
        }

        @Override
        public void cloneInto(Plugin plugin) {
        }

        @Override
        public void createParamIfNotExist() {
        }

        @Override
        public boolean isDepreciated() {
            return false;
        }

        @Override
        public int getDelayInMs() {
            return 0;
        }

        @Override
        public void setDelayInMs(int n) {
        }

        @Override
        public Plugin.AlertThreshold getAlertThreshold(boolean bl) {
            return null;
        }

        @Override
        public Plugin.AlertThreshold getAlertThreshold() {
            return null;
        }

        @Override
        public void setAlertThreshold(Plugin.AlertThreshold alertThreshold) {
        }

        @Override
        public void setDefaultAlertThreshold(Plugin.AlertThreshold alertThreshold) {
        }

        @Override
        public Plugin.AlertThreshold[] getAlertThresholdsSupported() {
            return null;
        }

        @Override
        public Plugin.AttackStrength getAttackStrength(boolean bl) {
            return null;
        }

        @Override
        public Plugin.AttackStrength getAttackStrength() {
            return null;
        }

        @Override
        public void setAttackStrength(Plugin.AttackStrength attackStrength) {
        }

        @Override
        public void setDefaultAttackStrength(Plugin.AttackStrength attackStrength) {
        }

        @Override
        public Plugin.AttackStrength[] getAttackStrengthsSupported() {
            return null;
        }

        @Override
        public void setTechSet(TechSet techSet) {
        }

        @Override
        public boolean inScope(Tech tech) {
            return false;
        }

        @Override
        public boolean targets(TechSet techSet) {
            return false;
        }

        @Override
        public void setTimeStarted() {
        }

        @Override
        public Date getTimeStarted() {
            return null;
        }

        @Override
        public void setTimeFinished() {
        }

        @Override
        public Date getTimeFinished() {
            return null;
        }

        @Override
        public int getCweId() {
            return 0;
        }

        @Override
        public int getWascId() {
            return 0;
        }

        @Override
        public AddOn.Status getStatus() {
            return null;
        }
    }

    private static class TestPlugin
    extends AbstractPlugin {
        private final int id;

        public TestPlugin(int n) {
            this.id = n;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String[] getDependency() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int getCategory() {
            return 0;
        }

        @Override
        public String getSolution() {
            return null;
        }

        @Override
        public String getReference() {
            return null;
        }

        @Override
        public void init() {
        }

        @Override
        public void scan() {
        }

        @Override
        public void notifyPluginCompleted(HostProcess hostProcess) {
        }
    }
}

