/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.ArrayUtils;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.JCheckBoxTree;

public class ContextTechnologyPanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("context.technology.title");
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelSession = null;
    private JScrollPane jScrollPane = null;
    private TreeModel model = null;
    private HashMap<Tech, DefaultMutableTreeNode> techToNodeMap = new HashMap();
    private JCheckBoxTree techTree = null;

    public static String getPanelName(int n) {
        return n + ": " + PANEL_NAME;
    }

    public ContextTechnologyPanel(Context context) {
        super(context.getIndex());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextTechnologyPanel.getPanelName(this.getContextIndex()));
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new BorderLayout());
            this.panelSession.setName("SessionTech");
            this.panelSession.add((Component)this.getJScrollPane(), "Center");
        }
        return this.panelSession;
    }

    private TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(arrayList);
        return new TreePath(arrayList.toArray());
    }

    private JCheckBoxTree getTechTree() {
        if (this.techTree == null) {
            this.techTree = new JCheckBoxTree(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void setExpandedState(TreePath treePath, boolean bl) {
                    if (bl) {
                        super.setExpandedState(treePath, bl);
                    }
                }
            };
            TechSet techSet = new TechSet(Tech.builtInTech);
            Iterator<Tech> iterator = techSet.getIncludeTech().iterator();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Constant.messages.getString("context.technology.tree.root"));
            while (iterator.hasNext()) {
                Tech tech = iterator.next();
                DefaultMutableTreeNode defaultMutableTreeNode2 = tech.getParent() != null ? this.techToNodeMap.get(tech.getParent()) : null;
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                }
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(tech.getUiName());
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                this.techToNodeMap.put(tech, defaultMutableTreeNode3);
            }
            this.model = new DefaultTreeModel(defaultMutableTreeNode);
            this.techTree.setModel(this.model);
            this.techTree.expandAll();
            this.techTree.setCheckBoxEnabled(new TreePath(defaultMutableTreeNode), false);
        }
        return this.techTree;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTechTree());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context context) {
        TechSet techSet = context.getTechSet();
        TreeSet<Tech> treeSet = techSet.getIncludeTech();
        for (Map.Entry<Tech, DefaultMutableTreeNode> entry : this.techToNodeMap.entrySet()) {
            TreePath treePath = this.getPath(entry.getValue());
            Tech tech = entry.getKey();
            if (ArrayUtils.contains(Tech.builtInTopLevelTech, tech)) {
                this.getTechTree().check(treePath, ContextTechnologyPanel.containsAnyOfTopLevelTech(treeSet, tech));
                continue;
            }
            this.getTechTree().check(treePath, techSet.includes(tech));
        }
    }

    private static boolean containsAnyOfTopLevelTech(Set<Tech> set, Tech tech) {
        for (Tech tech2 : set) {
            if (!tech.equals(tech2.getParent())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateContextData(Session session) throws Exception {
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        session.getContext(this.getContextIndex()).setTechSet(this.buildTechSet());
    }

    private TechSet buildTechSet() {
        TechSet techSet = new TechSet();
        for (Map.Entry<Tech, DefaultMutableTreeNode> entry : this.techToNodeMap.entrySet()) {
            TreePath treePath = this.getPath(entry.getValue());
            Tech tech = entry.getKey();
            if (this.getTechTree().isSelectedFully(treePath)) {
                techSet.include(tech);
                continue;
            }
            techSet.exclude(tech);
        }
        return techSet;
    }

    @Override
    public void saveTemporaryContextData(Context context) {
        context.setTechSet(this.buildTechSet());
    }
}

