/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.zaproxy.clientapi.core.Alert;
import org.zaproxy.clientapi.core.AlertsFile;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseFactory;
import org.zaproxy.clientapi.core.ApiResponseList;
import org.zaproxy.clientapi.core.ApiResponseSet;
import org.zaproxy.clientapi.core.ClientApiException;
import org.zaproxy.clientapi.gen.Acsrf;
import org.zaproxy.clientapi.gen.AjaxSpider;
import org.zaproxy.clientapi.gen.Ascan;
import org.zaproxy.clientapi.gen.Authentication;
import org.zaproxy.clientapi.gen.Autoupdate;
import org.zaproxy.clientapi.gen.Break;
import org.zaproxy.clientapi.gen.Context;
import org.zaproxy.clientapi.gen.Core;
import org.zaproxy.clientapi.gen.ForcedUser;
import org.zaproxy.clientapi.gen.HttpSessions;
import org.zaproxy.clientapi.gen.ImportLogFiles;
import org.zaproxy.clientapi.gen.Params;
import org.zaproxy.clientapi.gen.Pnh;
import org.zaproxy.clientapi.gen.Pscan;
import org.zaproxy.clientapi.gen.Script;
import org.zaproxy.clientapi.gen.Search;
import org.zaproxy.clientapi.gen.SessionManagement;
import org.zaproxy.clientapi.gen.Spider;
import org.zaproxy.clientapi.gen.Users;

public class ClientApi {
    private Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 8090));
    private boolean debug = false;
    private PrintStream debugStream = System.out;
    public Acsrf acsrf = new Acsrf(this);
    public AjaxSpider ajaxSpider = new AjaxSpider(this);
    public Ascan ascan = new Ascan(this);
    public Authentication authentication = new Authentication(this);
    public Autoupdate autoupdate = new Autoupdate(this);
    public Break brk = new Break(this);
    public Context context = new Context(this);
    public Core core = new Core(this);
    public ForcedUser forcedUser = new ForcedUser(this);
    public HttpSessions httpSessions = new HttpSessions(this);
    public ImportLogFiles logImportFiles = new ImportLogFiles(this);
    public Params params = new Params(this);
    public Pnh pnh = new Pnh(this);
    public Pscan pscan = new Pscan(this);
    public Search search = new Search(this);
    public Script script = new Script(this);
    public SessionManagement sessionManagement = new SessionManagement(this);
    public Spider spider = new Spider(this);
    public Users users = new Users(this);

    public ClientApi(String string, int n) {
        this(string, n, false);
    }

    public ClientApi(String string, int n, boolean bl) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        this.debug = bl;
    }

    public void setDebugStream(PrintStream printStream) {
        this.debugStream = printStream;
    }

    public void accessUrl(String string) throws ClientApiException {
        this.accessUrlViaProxy(this.proxy, string);
    }

    private int statusToInt(ApiResponse apiResponse) {
        return Integer.parseInt(((ApiResponseElement)apiResponse).getValue());
    }

    public void checkAlerts(List<Alert> list, List<Alert> list2) throws ClientApiException {
        HashMap<String, List<Alert>> hashMap = this.checkForAlerts(list, list2);
        this.verifyAlerts(hashMap.get("requireAlerts"), hashMap.get("reportAlerts"));
    }

    private void verifyAlerts(List<Alert> list, List<Alert> list2) throws ClientApiException {
        StringBuilder stringBuilder = new StringBuilder();
        if (list2.size() > 0) {
            stringBuilder.append("Found ").append(list2.size()).append(" alerts\n");
            for (Alert alert : list2) {
                stringBuilder.append('\t');
                stringBuilder.append(alert.toString());
                stringBuilder.append('\n');
            }
        }
        if (list != null && list.size() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Not found ").append(list.size()).append(" alerts\n");
            for (Alert alert : list) {
                stringBuilder.append('\t');
                stringBuilder.append(alert.toString());
                stringBuilder.append('\n');
            }
        }
        if (stringBuilder.length() > 0) {
            if (this.debug) {
                this.debugStream.println("Failed: " + stringBuilder.toString());
            }
            throw new ClientApiException(stringBuilder.toString());
        }
    }

    public void checkAlerts(List<Alert> list, List<Alert> list2, File file) throws ClientApiException {
        HashMap<String, List<Alert>> hashMap = this.checkForAlerts(list, list2);
        int n = hashMap.get("reportAlerts").size();
        int n2 = hashMap.get("requireAlerts").size();
        int n3 = hashMap.get("ignoredAlerts").size();
        String string = String.format("Alerts Found: %d, Alerts required but not found: %d, Alerts ignored: %d", n, n2, n3);
        try {
            AlertsFile.saveAlertsToFile(hashMap.get("requireAlerts"), hashMap.get("reportAlerts"), hashMap.get("ignoredAlerts"), file);
        }
        catch (Exception exception) {
            throw new ClientApiException(exception);
        }
        if (n > 0 || n2 > 0) {
            throw new ClientApiException("Check Alerts Failed!\n" + string);
        }
        if (this.debug) {
            this.debugStream.println("Check Alerts Passed!\n" + string);
        }
    }

    public List<Alert> getAlerts(String string, int n, int n2) throws ClientApiException {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        ApiResponse apiResponse = this.core.alerts(string, String.valueOf(n), String.valueOf(n2));
        if (apiResponse != null && apiResponse instanceof ApiResponseList) {
            ApiResponseList apiResponseList = (ApiResponseList)apiResponse;
            for (ApiResponse apiResponse2 : apiResponseList.getItems()) {
                ApiResponseSet apiResponseSet = (ApiResponseSet)apiResponse2;
                arrayList.add(new Alert(apiResponseSet.getAttribute("alert"), apiResponseSet.getAttribute("url"), Alert.Risk.valueOf(apiResponseSet.getAttribute("risk")), Alert.Confidence.valueOf(apiResponseSet.getAttribute("confidence")), apiResponseSet.getAttribute("param"), apiResponseSet.getAttribute("other"), apiResponseSet.getAttribute("attack"), apiResponseSet.getAttribute("description"), apiResponseSet.getAttribute("reference"), apiResponseSet.getAttribute("solution"), apiResponseSet.getAttribute("evidence"), Integer.parseInt(apiResponseSet.getAttribute("cweid")), Integer.parseInt(apiResponseSet.getAttribute("wascid"))));
            }
        }
        return arrayList;
    }

    private HashMap<String, List<Alert>> checkForAlerts(List<Alert> list, List<Alert> list2) throws ClientApiException {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        ArrayList<Alert> arrayList2 = new ArrayList<Alert>();
        List<Alert> list3 = this.getAlerts(null, -1, -1);
        block0: for (Alert alert : list3) {
            boolean bl = false;
            if (list != null) {
                for (Alert alert2 : list) {
                    if (!alert.matches(alert2)) continue;
                    if (this.debug) {
                        this.debugStream.println("Ignoring alert " + alert2);
                    }
                    arrayList2.add(alert);
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                arrayList.add(alert);
            }
            if (list2 == null) continue;
            for (Alert alert2 : list2) {
                if (!alert.matches(alert2)) continue;
                if (this.debug) {
                    this.debugStream.println("Found alert " + alert);
                }
                list2.remove(alert2);
                arrayList.remove(alert);
                continue block0;
            }
        }
        HashMap hashMap = new HashMap();
        hashMap.put("reportAlerts", arrayList);
        hashMap.put("requireAlerts", list2);
        hashMap.put("ignoredAlerts", arrayList2);
        return hashMap;
    }

    private void accessUrlViaProxy(Proxy proxy, String string) throws ClientApiException {
        try {
            URL uRL = new URL(string);
            if (this.debug) {
                this.debugStream.println("Open URL: " + string);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.connect();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!this.debug) continue;
                    this.debugStream.println(string2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                if (this.debug) {
                    this.debugStream.println("Ignoring exception " + iOException);
                }
            }
        }
        catch (Exception exception) {
            throw new ClientApiException(exception);
        }
    }

    public ApiResponse callApi(String string, String string2, String string3, Map<String, String> map) throws ClientApiException {
        Document document = this.callApiDom(string, string2, string3, map);
        return ApiResponseFactory.getResponse(document.getFirstChild());
    }

    private Document callApiDom(String string, String string2, String string3, Map<String, String> map) throws ClientApiException {
        try {
            URL uRL = ClientApi.buildZapRequestUrl("xml", string, string2, string3, map);
            if (this.debug) {
                this.debugStream.println("Open URL: " + uRL);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(this.getConnectionInputStream(uRL));
        }
        catch (Exception exception) {
            throw new ClientApiException(exception);
        }
    }

    private InputStream getConnectionInputStream(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(this.proxy);
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() >= 400) {
            return httpURLConnection.getErrorStream();
        }
        return httpURLConnection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] callApiOther(String string, String string2, String string3, Map<String, String> map) throws ClientApiException {
        try {
            URL uRL = ClientApi.buildZapRequestUrl("other", string, string2, string3, map);
            if (this.debug) {
                this.debugStream.println("Open URL: " + uRL);
            }
            InputStream inputStream = this.getConnectionInputStream(uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                byteArrayOutputStream.close();
                inputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ClientApiException(exception);
        }
    }

    private static URL buildZapRequestUrl(String string, String string2, String string3, String string4, Map<String, String> map) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://zap/");
        stringBuilder.append(string);
        stringBuilder.append('/');
        stringBuilder.append(string2);
        stringBuilder.append('/');
        stringBuilder.append(string3);
        stringBuilder.append('/');
        stringBuilder.append(string4);
        stringBuilder.append('/');
        if (map != null) {
            stringBuilder.append('?');
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder.append(ClientApi.encodeQueryParam(entry.getKey()));
                stringBuilder.append('=');
                if (entry.getValue() != null) {
                    stringBuilder.append(ClientApi.encodeQueryParam(entry.getValue()));
                }
                stringBuilder.append('&');
            }
        }
        return new URL(stringBuilder.toString());
    }

    private static String encodeQueryParam(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public void addExcludeFromContext(String string, String string2, String string3) throws Exception {
        this.context.excludeFromContext(string, string2, string3);
    }

    public void addIncludeInContext(String string, String string2, String string3) throws Exception {
        this.context.includeInContext(string, string2, string3);
    }

    public void includeOneMatchingNodeInContext(String string, String string2, String string3) throws Exception {
        List<String> list = this.getSessionUrls();
        boolean bl = false;
        for (String string4 : list) {
            if (!string4.matches(string3)) continue;
            if (bl) {
                this.addExcludeFromContext(string, string2, string4);
                continue;
            }
            bl = true;
        }
        if (!bl) {
            throw new Exception("Unexpected result: No url found in site tree matching regex " + string3);
        }
    }

    private List<String> getSessionUrls() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ApiResponse apiResponse = this.core.urls();
        if (apiResponse != null && apiResponse instanceof ApiResponseList) {
            ApiResponseElement apiResponseElement = (ApiResponseElement)((ApiResponseList)apiResponse).getItems().get(0);
            for (ApiResponse apiResponse2 : ((ApiResponseList)apiResponse).getItems()) {
                URL uRL = new URL(((ApiResponseElement)apiResponse2).getValue());
                arrayList.add(uRL.getProtocol() + "://" + uRL.getHost() + uRL.getPath());
            }
            System.out.println(apiResponseElement);
        }
        return arrayList;
    }

    public void activeScanSiteInScope(String string, String string2) throws Exception {
        this.ascan.scan(string, string2, "true", "true", "", "", "");
        int n = 0;
        while (n < 100) {
            n = this.statusToInt(this.ascan.status(""));
            if (this.debug) {
                String string3 = "Scanning %s Progress: %d%%";
                System.out.println(String.format(string3, string2, n));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

