/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class BioExt {
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};

    public void getAllPolymerInfo(ModelSet modelSet, BS bS, Map<String, Lst<Map<String, Object>>> map) {
        Lst lst = new Lst();
        int n = modelSet.mc;
        Model[] modelArray = modelSet.am;
        for (int i = 0; i < n; ++i) {
            if (!modelArray[i].isBioModel) continue;
            BioModel bioModel = (BioModel)modelArray[i];
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Lst lst2 = new Lst();
            for (int j = 0; j < bioModel.bioPolymerCount; ++j) {
                BioPolymer bioPolymer = bioModel.bioPolymers[j];
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                Lst lst3 = new Lst();
                Lst lst4 = null;
                ProteinStructure proteinStructure = null;
                int n2 = 0;
                P3 p3 = new P3();
                for (int k = 0; k < bioPolymer.monomerCount; ++k) {
                    if (!bS.get(bioPolymer.monomers[k].leadAtomIndex)) continue;
                    Map<String, Object> map2 = bioPolymer.monomers[k].getMyInfo(p3);
                    map2.put("monomerIndex", k);
                    lst3.addLast(map2);
                    ProteinStructure proteinStructure2 = bioPolymer.getProteinStructure(k);
                    if (proteinStructure2 == null || proteinStructure2 == proteinStructure) continue;
                    Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                    proteinStructure = proteinStructure2;
                    hashtable3.put("type", proteinStructure2.type.getBioStructureTypeName(false));
                    int[] nArray = bioPolymer.getLeadAtomIndices();
                    int[] nArray2 = AU.arrayCopyRangeI((int[])nArray, (int)proteinStructure2.monomerIndexFirst, (int)(proteinStructure2.monomerIndexFirst + proteinStructure2.nRes));
                    hashtable3.put("leadAtomIndices", nArray2);
                    proteinStructure2.calcAxis();
                    if (proteinStructure2.axisA != null) {
                        hashtable3.put("axisA", proteinStructure2.axisA);
                        hashtable3.put("axisB", proteinStructure2.axisB);
                        hashtable3.put("axisUnitVector", proteinStructure2.axisUnitVector);
                    }
                    hashtable3.put("index", n2++);
                    if (lst4 == null) {
                        lst4 = new Lst();
                    }
                    lst4.addLast(hashtable3);
                }
                if (lst3.size() > 0) {
                    hashtable2.put("sequence", bioPolymer.getSequence());
                    hashtable2.put("monomers", (String)lst3);
                    if (lst4 != null) {
                        hashtable2.put("structures", (String)lst4);
                    }
                }
                if (hashtable2.isEmpty()) continue;
                lst2.addLast(hashtable2);
            }
            if (lst2.size() <= 0) continue;
            hashtable.put("modelIndex", bioModel.modelIndex);
            hashtable.put("polymers", (Integer)lst2);
            lst.addLast(hashtable);
        }
        map.put("models", (Lst<Map<String, Object>>)lst);
    }

    void calculateStraightnessAll(Viewer viewer, ModelSet modelSet) {
        char c = viewer.getQuaternionFrame();
        int n = viewer.getInt(0x21000012);
        int n2 = modelSet.mc;
        while (--n2 >= 0) {
            if (!modelSet.am[n2].isBioModel) continue;
            BioModel bioModel = (BioModel)modelSet.am[n2];
            P3 p3 = new P3();
            for (int i = 0; i < bioModel.bioPolymerCount; ++i) {
                BioExt.getPdbData(bioModel.bioPolymers[i], viewer, 'S', c, n, 2, null, null, false, false, false, null, null, null, new BS(), p3);
            }
        }
        modelSet.haveStraightness = true;
    }

    private static void getPdbData(BioPolymer bioPolymer, Viewer viewer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3, P3 p3) {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7 = c2 == 'C' || c2 == 'P';
        boolean bl8 = bl6 = c == 'R' || c == 'S' && bl7;
        if (bl6 && !bioPolymer.calcPhiPsiAngles()) {
            return;
        }
        boolean bl9 = bioPolymer.type == 1;
        boolean bl10 = c == 'r';
        boolean bl11 = bl5 = !bl6 && c == 'S';
        if (n2 == 2 && bl10) {
            c = (char)119;
        }
        if (bl5) {
            n2 = 2;
        }
        boolean bl12 = c == 'S';
        boolean bl13 = bl4 = "rcpCP".indexOf(c2) >= 0;
        if (Logger.debugging && (bl5 || bl7)) {
            Logger.debug((String)("For straightness calculation: useQuaternionStraightness = " + bl12 + " and quaternionFrame = " + c2));
        }
        if (bl3 && !bl2) {
            oC.append("REMARK   6    AT GRP CH RESNO  ");
            switch (c) {
                default: {
                    oC.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    oC.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    oC.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    oC.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (bl4) {
                        oC.append("phi____ psi____ theta         Straightness");
                        break;
                    }
                    oC.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            oC.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            oC.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (c != 'R') {
                oC.append("  centerX___ centerY___ centerZ___");
            }
            if (c2 == 'n') {
                oC.append("  NHX_______ NHY_______ NHZ_______");
            }
            oC.append("\n\n");
        }
        float f = c == 'R' ? 1.0f : 10.0f;
        bl = false;
        int n3 = 0;
        while (n3 < (bl ? 2 : 1)) {
            for (int i = 0; i < (n < 1 ? 1 : n); ++i) {
                if (!bioPolymer.hasStructure) continue;
                BioExt.getData(viewer, i, n, bioPolymer, c, c2, n2, bS, bS2, bl2, bl6, bl7, bl12, bl4, bl5, f, bl9, bl10, labelTokenArray, oC, sB, bS3, p3);
            }
            ++n3;
            f *= -1.0f;
        }
    }

    private static void getData(Viewer viewer, int n, int n2, BioPolymer bioPolymer, char c, char c2, int n3, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, float f, boolean bl7, boolean bl8, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3, P3 p3) {
        String string = n3 > 0 ? "dq" + (n3 == 2 ? "2" : "") : "q";
        Atom atom = null;
        Quat quat = null;
        Quat quat2 = null;
        Quat quat3 = null;
        Quat quat4 = null;
        Atom atom2 = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string2 = "";
        float f6 = Float.NaN;
        float f7 = Float.NaN;
        P3 p32 = bl ? new P3() : null;
        int n4 = n2 <= 1 ? 1 : n2;
        for (int i = n; i < bioPolymer.monomerCount; i += n4) {
            Quat quat5;
            AminoMonomer aminoMonomer;
            Monomer monomer = bioPolymer.monomers[i];
            if (bS != null && !bS.get(monomer.leadAtomIndex)) continue;
            Atom atom3 = monomer.getLeadAtom();
            String string3 = monomer.getUniqueID();
            if (bl2) {
                float f8;
                if (c == 'S') {
                    monomer.setGroupParameter(1111490574, Float.NaN);
                }
                f2 = monomer.getGroupParameter(1111490569);
                f3 = monomer.getGroupParameter(1111490570);
                f4 = monomer.getGroupParameter(1111490568);
                if (f4 < -90.0f) {
                    f4 += 360.0f;
                }
                if (Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4 -= 180.0f)) {
                    if (bS == null) continue;
                    bS.clear(atom3.i);
                    continue;
                }
                float f9 = bl5 ? bioPolymer.calculateRamachandranHelixAngle(i, c2) : 0.0f;
                float f10 = f8 = bl3 || bl5 ? BioExt.getStraightness((float)Math.cos((double)(f9 / 2.0f / 180.0f) * Math.PI)) : 0.0f;
                if (c == 'S') {
                    monomer.setGroupParameter(1111490574, f8);
                    continue;
                }
                if (bl) {
                    if (bS2 != null && !bS2.get(atom3.getIndex())) continue;
                    aminoMonomer = (AminoMonomer)monomer;
                    p32.set(-f2, f2, 0.5f);
                    oC.append("draw ID \"phi").append(string3).append("\" ARROW ARC ").append(Escape.eP((T3)aminoMonomer.getNitrogenAtom())).append(Escape.eP((T3)atom3)).append(Escape.eP((T3)aminoMonomer.getCarbonylCarbonAtom())).append(Escape.eP((T3)p32)).append(" \"phi = ").append(String.valueOf(Math.round(f2))).append("\" color ").append(qColor[2]).append("\n");
                    p32.set(0.0f, f3, 0.5f);
                    oC.append("draw ID \"psi").append(string3).append("\" ARROW ARC ").append(Escape.eP((T3)atom3)).append(Escape.eP((T3)aminoMonomer.getCarbonylCarbonAtom())).append(Escape.eP((T3)aminoMonomer.getNitrogenAtom())).append(Escape.eP((T3)p32)).append(" \"psi = ").append(String.valueOf(Math.round(f3))).append("\" color ").append(qColor[1]).append("\n");
                    oC.append("draw ID \"planeNCC").append(string3).append("\" ").append(Escape.eP((T3)aminoMonomer.getNitrogenAtom())).append(Escape.eP((T3)atom3)).append(Escape.eP((T3)aminoMonomer.getCarbonylCarbonAtom())).append(" color ").append(qColor[0]).append("\n");
                    oC.append("draw ID \"planeCNC").append(string3).append("\" ").append(Escape.eP((T3)((AminoMonomer)bioPolymer.monomers[i - 1]).getCarbonylCarbonAtom())).append(Escape.eP((T3)aminoMonomer.getNitrogenAtom())).append(Escape.eP((T3)atom3)).append(" color ").append(qColor[1]).append("\n");
                    oC.append("draw ID \"planeCCN").append(string3).append("\" ").append(Escape.eP((T3)atom3)).append(Escape.eP((T3)aminoMonomer.getCarbonylCarbonAtom())).append(Escape.eP((T3)((AminoMonomer)bioPolymer.monomers[i + 1]).getNitrogenAtom())).append(" color ").append(qColor[2]).append("\n");
                    continue;
                }
                if (Float.isNaN(f9)) {
                    string2 = "";
                    if (bl5) {
                        continue;
                    }
                } else {
                    quat5 = Quat.newVA((T3)P3.new3((float)1.0f, (float)0.0f, (float)0.0f), (float)f9);
                    string2 = BioExt.getQInfo(quat5);
                    if (bl5) {
                        f4 = f9;
                        f5 = f8;
                    } else {
                        f5 = atom3.getPartialCharge();
                    }
                }
            } else {
                quat5 = monomer.getQuaternion(c2);
                if (quat5 != null) {
                    quat5.setRef(quat4);
                    quat4 = Quat.newQ((Quat)quat5);
                }
                if (n3 == 2) {
                    monomer.setGroupParameter(1111490574, Float.NaN);
                }
                if (quat5 == null) {
                    quat = null;
                    quat4 = null;
                } else if (n3 > 0) {
                    Atom atom4 = atom3;
                    Quat quat6 = quat5;
                    if (quat == null) {
                        quat5 = null;
                        quat3 = null;
                    } else {
                        quat2 = bl8 ? quat.leftDifference(quat5) : quat5.rightDifference(quat);
                        if (n3 == 1) {
                            quat5 = quat2;
                        } else if (quat3 == null) {
                            quat5 = null;
                        } else {
                            quat5 = quat2.rightDifference(quat3);
                            f6 = BioExt.getQuaternionStraightness(string3, quat3, quat2);
                            f7 = BioExt.get3DStraightness(string3, quat3, quat2);
                            ((Monomer)atom.group).setGroupParameter(1111490574, bl4 ? f6 : f7);
                        }
                        quat3 = quat2;
                    }
                    atom = atom4;
                    quat = quat6;
                }
                if (quat5 == null) {
                    atom2 = null;
                    continue;
                }
                switch (c) {
                    default: {
                        f2 = quat5.q1;
                        f3 = quat5.q2;
                        f4 = quat5.q3;
                        f5 = quat5.q0;
                        break;
                    }
                    case 'x': {
                        f2 = quat5.q0;
                        f3 = quat5.q1;
                        f4 = quat5.q2;
                        f5 = quat5.q3;
                        break;
                    }
                    case 'y': {
                        f2 = quat5.q3;
                        f3 = quat5.q0;
                        f4 = quat5.q1;
                        f5 = quat5.q2;
                        break;
                    }
                    case 'z': {
                        f2 = quat5.q2;
                        f3 = quat5.q3;
                        f4 = quat5.q0;
                        f5 = quat5.q1;
                    }
                }
                P3 p33 = monomer.getQuaternionFrameCenter(c2);
                if (p33 == null) {
                    p33 = new P3();
                }
                if (bl) {
                    if (bS2 != null && !bS2.get(atom3.getIndex())) continue;
                    int n5 = (int)Math.floor(Math.acos(f5) * 360.0 / Math.PI);
                    if (n3 == 0) {
                        oC.append(Escape.drawQuat((Quat)quat5, (String)string, (String)string3, (P3)p33, (float)1.0f));
                        if (c2 == 'n' && bl7 && (aminoMonomer = ((AminoMonomer)monomer).getNitrogenHydrogenPoint()) != null) {
                            oC.append("draw ID \"").append(string).append("nh").append(string3).append("\" width 0.1 ").append(Escape.eP((T3)aminoMonomer)).append("\n");
                        }
                    }
                    if (n3 == 1) {
                        oC.append((String)monomer.getHelixData(135176, c2, n2)).append("\n");
                        continue;
                    }
                    p32.set(f2 * 2.0f, f3 * 2.0f, f4 * 2.0f);
                    oC.append("draw ID \"").append(string).append("a").append(string3).append("\" VECTOR ").append(Escape.eP((T3)p33)).append(Escape.eP((T3)p32)).append(" \">").append(String.valueOf(n5)).append("\" color ").append(qColor[n3]).append("\n");
                    continue;
                }
                string2 = BioExt.getQInfo(quat5) + PT.sprintf((String)"  %10.5p %10.5p %10.5p", (String)"p", (Object[])new Object[]{p33});
                if (c2 == 'n' && bl7) {
                    string2 = string2 + PT.sprintf((String)"  %10.5p %10.5p %10.5p", (String)"p", (Object[])new Object[]{((AminoMonomer)monomer).getNitrogenHydrogenPoint()});
                } else if (n3 == 2 && !Float.isNaN(f6)) {
                    string2 = string2 + PT.sprintf((String)" %10.5f %10.5f", (String)"F", (Object[])new Object[]{new float[]{f6, f7}});
                }
            }
            if (oC == null) continue;
            bS3.set(((Monomer)atom3.group).leadAtomIndex);
            viewer.ms.getLabeler();
            oC.append(LabelToken.formatLabelAtomArray((Viewer)viewer, (Atom)atom3, (LabelToken[])labelTokenArray, (char)'\u0000', null, (P3)p3));
            oC.append(PT.sprintf((String)"%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", (String)"ssF", (Object[])new Object[]{atom3.getElementSymbolIso(false).toUpperCase(), string2, new float[]{f2 * f, f3 * f, f4 * f, f5 * f}}));
            if (atom2 != null && atom2.group.getBioPolymerIndexInModel() == atom3.group.getBioPolymerIndexInModel()) {
                sB.append("CONECT").append(PT.formatStringI((String)"%5i", (String)"i", (int)atom2.getAtomNumber())).append(PT.formatStringI((String)"%5i", (String)"i", (int)atom3.getAtomNumber())).appendC('\n');
            }
            atom2 = atom3;
        }
    }

    private static String getQInfo(Quat quat) {
        A4 a4 = quat.toAxisAngle4f();
        return PT.sprintf((String)"%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", (String)"F", (Object[])new Object[]{new float[]{quat.q0, quat.q1, quat.q2, quat.q3, (float)((double)(a4.angle * 180.0f) / Math.PI), a4.x, a4.y, a4.z}});
    }

    public static String drawQuat(Quat quat, String string, String string2, P3 p3, float f) {
        String string3 = " VECTOR " + Escape.eP((T3)p3) + " ";
        if (f == 0.0f) {
            f = 1.0f;
        }
        return "draw " + string + "x" + string2 + string3 + Escape.eP((T3)quat.getVectorScaled(0, f)) + " color red\n" + "draw " + string + "y" + string2 + string3 + Escape.eP((T3)quat.getVectorScaled(1, f)) + " color green\n" + "draw " + string + "z" + string2 + string3 + Escape.eP((T3)quat.getVectorScaled(2, f)) + " color blue\n";
    }

    private static float get3DStraightness(String string, Quat quat, Quat quat2) {
        return quat.getNormal().dot((T3)quat2.getNormal());
    }

    private static float getQuaternionStraightness(String string, Quat quat, Quat quat2) {
        return BioExt.getStraightness(quat.dot(quat2));
    }

    private static float getStraightness(float f) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(f)) / Math.PI);
    }

    void getPdbDataM(BioModel bioModel, Viewer viewer, String string, char c, boolean bl, BS bS, OC oC, LabelToken[] labelTokenArray, SB sB, BS bS2) {
        int n;
        char c2;
        boolean bl2 = false;
        char c3 = c != 'R' ? (char)'r' : (c2 = string.length() > 13 && string.indexOf("ramachandran ") >= 0 ? (char)string.charAt(13) : (char)'R');
        if (c2 == 'r') {
            c2 = viewer.getQuaternionFrame();
        }
        int n2 = viewer.getInt(0x21000012);
        int n3 = string.indexOf("diff") < 0 ? 0 : (n = string.indexOf("2") < 0 ? 1 : 2);
        if (!bl) {
            oC.append("REMARK   6 Jmol PDB-encoded data: " + string + ";");
            if (c != 'R') {
                oC.append("  quaternionFrame = \"" + c2 + "\"");
                bl2 = true;
            }
            oC.append("\nREMARK   6 Jmol Version ").append(Viewer.getJmolVersion()).append("\n");
            if (c == 'R') {
                oC.append("REMARK   6 Jmol data min = {-180 -180 -180} max = {180 180 180} unScaledXyz = xyz * {1 1 1} + {0 0 0} plotScale = {100 100 100}\n");
            } else {
                oC.append("REMARK   6 Jmol data min = {-1 -1 -1} max = {1 1 1} unScaledXyz = xyz * {0.1 0.1 0.1} + {0 0 0} plotScale = {100 100 100}\n");
            }
        }
        P3 p3 = new P3();
        for (int i = 0; i < bioModel.bioPolymerCount; ++i) {
            BioExt.getPdbData(bioModel.bioPolymers[i], viewer, c, c2, n2, n, bioModel.bsAtoms, bS, bl2, bl, i == 0, labelTokenArray, oC, sB, bS2, p3);
        }
    }

    int calculateAllstruts(Viewer viewer, ModelSet modelSet, BS bS, BS bS2) {
        BS bS3;
        viewer.setModelVisibility();
        modelSet.makeConnections2(0.0f, Float.MAX_VALUE, 32768, 12291, bS, bS2, null, false, false, 0.0f);
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        Model model = modelSet.am[modelSet.at[n].mi];
        if (!model.isBioModel) {
            return 0;
        }
        Lst lst = new Lst();
        if (bS.equals((Object)bS2)) {
            bS3 = bS;
        } else {
            bS3 = BSUtil.copy((BS)bS);
            bS3.or(bS2);
        }
        Atom[] atomArray = modelSet.at;
        bS3.and(viewer.getModelUndeletedAtomsBitSet(model.modelIndex));
        int n2 = bS3.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = atomArray[n2];
            if (atom.checkVisible() && atom.atomID == 2 && atom.group.groupID != 5 && atomArray[n2].group.leadAtomIndex >= 0) {
                lst.addLast((Object)atomArray[n2]);
            }
            n2 = bS3.nextSetBit(n2 + 1);
        }
        if (lst.size() == 0) {
            return 0;
        }
        Lst<Atom[]> lst2 = BioExt.calculateStruts(modelSet, bS, bS2, (Lst<Atom>)lst, viewer.getFloat(0x22000040), viewer.getInt(553648184), viewer.getBoolean(603979955));
        short s = (short)(viewer.getFloat(570425406) * 2000.0f);
        for (int i = 0; i < lst2.size(); ++i) {
            Atom[] atomArray2 = (Atom[])lst2.get(i);
            modelSet.bondAtoms(atomArray2[0], atomArray2[1], 32768, s, null, 0.0f, false, true);
        }
        return lst2.size();
    }

    private static Lst<Atom[]> calculateStruts(ModelSet modelSet, BS bS, BS bS2, Lst<Atom> lst, float f, int n, boolean bl) {
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Lst lst2 = new Lst();
        float f3 = f * f;
        int n9 = lst.size();
        int n10 = 3;
        BS bS3 = new BS();
        BS bS4 = new BS();
        BS bS5 = new BS();
        Atom atom = (Atom)lst.get(0);
        int n11 = modelSet.getBioPolymerCountInModel((int)atom.mi);
        int[][] nArray = new int[n11][n10 * 2];
        for (int i = 0; i < n9; ++i) {
            atom = (Atom)lst.get(i);
            n8 = atom.group.getBioPolymerIndexInModel();
            n7 = atom.group.getMonomerIndex();
            n6 = n7;
            if (n6 < n10) {
                nArray[n8][n6] = i + 1;
            }
            if ((n6 = ((Monomer)atom.group).getBioPolymerLength() - n7 - 1) >= n10) continue;
            nArray[n8][n10 + n6] = i + 1;
        }
        float[] fArray = new float[n9 * (n9 - 1) / 2];
        for (n8 = 0; n8 < n9; ++n8) {
            atom = (Atom)lst.get(n8);
            for (n7 = n8 + 1; n7 < n9; ++n7) {
                n6 = BioExt.strutPoint(n8, n7, n9);
                Atom atom2 = (Atom)lst.get(n7);
                n5 = atom.getResno();
                n4 = atom.group.getBioPolymerIndexInModel();
                n3 = atom2.getResno();
                n2 = atom2.group.getBioPolymerIndexInModel();
                if (n4 == n2 && Math.abs(n3 - n5) < n) {
                    bS5.set(n6);
                }
                if (!((f2 = (fArray[n6] = atom.distanceSquared((T3)atom2))) >= f3)) continue;
                bS4.set(n6);
            }
        }
        n8 = 5;
        while (--n8 >= 0) {
            f3 = (f - (float)n8) * (f - (float)n8);
            for (n7 = 0; n7 < n9; ++n7) {
                if (!bl && bS3.get(n7)) continue;
                for (n6 = n7 + 1; n6 < n9; ++n6) {
                    n5 = BioExt.strutPoint(n7, n6, n9);
                    if (bS4.get(n5) || bS5.get(n5) || !bl && bS3.get(n6) || !(fArray[n5] <= f3)) continue;
                    BioExt.setStrut(n7, n6, n9, lst, bS, bS2, (Lst<Atom[]>)lst2, bS3, bS4, bS5, n);
                }
            }
        }
        for (n8 = 0; n8 < n11; ++n8) {
            for (n7 = 0; n7 < n10 * 2; ++n7) {
                n6 = nArray[n8][n7] - 1;
                if (n6 < 0 || !bS3.get(n6)) continue;
                for (n5 = 0; n5 < n10; ++n5) {
                    n4 = n7 / n10 * n10 + n5;
                    n6 = nArray[n8][n4] - 1;
                    if (n6 >= 0) {
                        bS3.set(n6);
                    }
                    nArray[n8][n4] = -1;
                }
            }
            if (nArray[n8][0] == -1 && nArray[n8][n10] == -1) continue;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            f2 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n10 * 2; ++j) {
                    int n12;
                    int n13 = nArray[n8][j] - 1;
                    if (n13 == -2) {
                        j = (j / n10 + 1) * n10 - 1;
                        continue;
                    }
                    if (i == n13 || n13 == -1 || bS5.get(n12 = BioExt.strutPoint(n13, i, n9)) || fArray[n12] > (j < n10 ? f2 : f4)) continue;
                    if (j < n10) {
                        if (bS4.get(n12)) {
                            n7 = 1;
                        }
                        n4 = i;
                        n5 = n13;
                        f2 = fArray[n12];
                        continue;
                    }
                    if (bS4.get(n12)) {
                        n6 = 1;
                    }
                    n2 = i;
                    n3 = n13;
                    f4 = fArray[n12];
                }
            }
            if (n7 != 0) {
                BioExt.setStrut(n5, n4, n9, lst, bS, bS2, (Lst<Atom[]>)lst2, bS3, bS4, bS5, n);
            }
            if (n6 == 0) continue;
            BioExt.setStrut(n3, n2, n9, lst, bS, bS2, (Lst<Atom[]>)lst2, bS3, bS4, bS5, n);
        }
        return lst2;
    }

    private static int strutPoint(int n, int n2, int n3) {
        return n2 < n ? n2 * (2 * n3 - n2 - 1) / 2 + n - n2 - 1 : n * (2 * n3 - n - 1) / 2 + n2 - n - 1;
    }

    private static void setStrut(int n, int n2, int n3, Lst<Atom> lst, BS bS, BS bS2, Lst<Atom[]> lst2, BS bS3, BS bS4, BS bS5, int n4) {
        Atom atom = (Atom)lst.get(n);
        Atom atom2 = (Atom)lst.get(n2);
        if (!bS.get(atom.i) || !bS2.get(atom2.i)) {
            return;
        }
        lst2.addLast((Object)new Atom[]{atom, atom2});
        bS3.set(n);
        bS3.set(n2);
        for (int i = Math.max(0, n - n4); i <= n + n4 && i < n3; ++i) {
            for (int j = Math.max(0, n2 - n4); j <= n2 + n4 && j < n3; ++j) {
                int n5;
                if (i == j || bS5.get(n5 = BioExt.strutPoint(i, j, n3))) continue;
                bS4.set(n5);
            }
        }
    }

    boolean mutate(Viewer viewer, BS bS, String string, String[] stringArray) {
        boolean bl;
        int n = bS.nextSetBit(0);
        if (stringArray == null) {
            return BioExt.mutateAtom(viewer, n, string);
        }
        boolean bl2 = bl = string == null;
        if (bl) {
            string = stringArray[0];
        }
        Group group = null;
        boolean bl3 = true;
        int n2 = n;
        int n3 = 0;
        while (n2 >= 0) {
            block6: {
                block7: {
                    Group group2 = viewer.ms.at[n2].group;
                    if (group2 == group) break block6;
                    group = group2;
                    if (bl) break block7;
                    if ((string = stringArray[n3++ % stringArray.length]).equals("UNK")) break block6;
                    string = "==" + string;
                }
                BioExt.mutateAtom(viewer, n2, string);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        return bl3;
    }

    private static boolean mutateAtom(Viewer viewer, int n, String string) {
        ModelSet modelSet = viewer.ms;
        short s = modelSet.at[n].mi;
        if (modelSet.isTrajectory((int)s)) {
            return false;
        }
        String[] stringArray = viewer.fm.getFileInfo();
        Group group = modelSet.at[n].group;
        if (!(group instanceof AminoMonomer)) {
            return false;
        }
        ((BioModel)modelSet.am[s]).isMutated = true;
        AminoMonomer aminoMonomer = (AminoMonomer)group;
        int n2 = modelSet.ac;
        BS bS = new BS();
        aminoMonomer.setAtomBits(bS);
        Atom[] atomArray = BioExt.getMutationBackbone(aminoMonomer, null);
        string = PT.esc((String)string);
        String string2 = "try{\n  var atoms0 = {*}\n  var res0 = " + BS.escape((BS)bS, (char)'(', (char)')') + "\n" + "  load mutate " + string + "\n" + "  var res1 = {!atoms0};var r1 = res1[1];var r0 = res1[0]\n" + "  if ({r1 & within(group, r0)}){\n" + "    var haveHs = ({_H & connected(res0)} != 0)\n" + "    if (!haveHs) {delete _H & res1}\n" + "    var sm = '[*.N][*.CA][*.C][*.O]'\n" + "    var keyatoms = res1.find(sm)\n" + "    var x = compare(res1,res0,sm,'BONDS')\n" + "    if(x){\n" + "      print 'mutating ' + res0[1].label('%n%r') + ' to ' + " + string + ".trim('=')\n" + "      rotate branch @x\n" + "      compare res1 res0 SMARTS @sm rotate translate 0\n" + "      var c = {!res0 & connected(res0)}\n" + "      var N2 = {*.N & c}\n" + "      var C0 = {*.C & c}\n" + "      var angleH = ({*.H and res0} ? angle({*.C and res0},{*.CA and res0},{*.N and res0},{*.H and res0}) : 1000)\n" + "      delete res0\n" + "      if (N2) {\n" + "        delete (*.OXT,*.HXT) and res1\n" + "        connect {N2} {keyatoms & *.C}\n" + "      }\n" + "      if (C0) {\n" + "        var h1 = {*.H and res1}\n" + "        var n = (h1 ? 0 + {res1 and _H & connected(*.N)} : 0)\n" + "        switch (n) {\n" + "        case 0:\n" + "          break\n" + "        case 1:\n" + "          delete h1\n" + "          break\n" + "        default:\n" + "          var x = angle({*.C and res1},{*.CA and res1},{*.N and res1},h1)\n" + "          rotate branch {*.CA and res1} {*.N and res1} @{angleH-x}\n" + "          delete *.H2 and res1\n" + "          delete *.H3 and res1\n" + "          break\n" + "        }\n" + "        connect {C0} {keyatoms & *.N}\n" + "      }\n" + "    }\n" + "  }\n" + "}catch(e){print e}\n";
        try {
            if (Logger.debugging) {
                Logger.debug((String)string2);
            }
            viewer.eval.runScript(string2);
        }
        catch (Exception exception) {
            if (!viewer.isJS) {
                exception.printStackTrace();
            }
            System.out.println(exception);
        }
        modelSet = viewer.ms;
        if (modelSet.ac == n2) {
            return false;
        }
        SB sB = modelSet.am[s].loadScript;
        String string3 = PT.rep((String)sB.toString(), (String)"load mutate ", (String)("mutate ({" + n + "})"));
        sB.setLength(0);
        sB.append(string3);
        group = modelSet.at[modelSet.ac - 1].group;
        if (group != modelSet.at[n2 + 1].group || !(group instanceof AminoMonomer)) {
            BS bS2 = new BS();
            group.setAtomBits(bS2);
            viewer.deleteAtoms(bS2, false);
            return false;
        }
        AminoMonomer aminoMonomer2 = (AminoMonomer)group;
        BioExt.getMutationBackbone(aminoMonomer2, atomArray);
        BioExt.replaceMutatedMonomer(viewer, aminoMonomer, aminoMonomer2);
        viewer.fm.setFileInfo(stringArray);
        return true;
    }

    private static void replaceMutatedMonomer(Viewer viewer, AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        aminoMonomer2.setResno(aminoMonomer.getResno());
        aminoMonomer2.chain.groupCount = 0;
        aminoMonomer2.chain = aminoMonomer.chain;
        aminoMonomer2.chain.model.groupCount = -1;
        aminoMonomer2.proteinStructure = aminoMonomer.proteinStructure;
        viewer.shm.replaceGroup((Group)aminoMonomer, (Group)aminoMonomer2);
        Group[] groupArray = aminoMonomer.chain.groups;
        int n = groupArray.length;
        while (--n >= 0) {
            if (groupArray[n] != aminoMonomer) continue;
            groupArray[n] = aminoMonomer2;
            break;
        }
        aminoMonomer2.bioPolymer = aminoMonomer.bioPolymer;
        if (aminoMonomer2.bioPolymer != null) {
            Monomer[] monomerArray = aminoMonomer2.bioPolymer.monomers;
            int n2 = monomerArray.length;
            while (--n2 >= 0) {
                if (monomerArray[n2] != aminoMonomer) continue;
                monomerArray[n2] = aminoMonomer2;
                break;
            }
        }
    }

    private static Atom[] getMutationBackbone(AminoMonomer aminoMonomer, Atom[] atomArray) {
        Atom[] atomArray2 = new Atom[]{aminoMonomer.getCarbonylCarbonAtom(), aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getLeadAtom(), aminoMonomer.getNitrogenAtom(), aminoMonomer.getExplicitNH()};
        if (atomArray == null) {
            if (atomArray2[3].getCovalentHydrogenCount() > 1) {
                atomArray2[4] = null;
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                Atom atom = atomArray[i];
                Atom atom2 = atomArray2[i];
                if (atom == null || atom2 == null) continue;
                atom2.setT((T3)atom);
            }
        }
        return atomArray2;
    }
}

