/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.C;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;
    private P3[] screens3f;
    private P3i scrVib;
    private boolean vibs;
    private BS bsSelected;
    private boolean showNumbers;

    protected boolean render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        this.bsSelected = this.vwr.getSelectionHalosEnabled() ? this.vwr.bsA() : null;
        this.g3d.addRenderer(1073742182);
        this.vibs = this.ms.vibrations != null && this.tm.vibrationOn;
        this.showNumbers = this.vwr.getTestFlag(3);
        boolean bl = false;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            if (!polyhedronArray[n].isValid || !this.render1(polyhedronArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean render1(Polyhedron polyhedron) {
        V3 v3;
        V3 v32;
        int n;
        Object object;
        T3[] t3Array;
        short s;
        if (polyhedron.visibilityFlags == 0) {
            return false;
        }
        short[] sArray = ((Polyhedra)this.shape).colixes;
        int n2 = -1;
        float f = 1.0f;
        if (polyhedron.id == null) {
            n2 = polyhedron.centralAtom.i;
            s = sArray == null || n2 >= sArray.length ? (short)0 : sArray[n2];
            s = C.getColixInherited((short)s, (short)polyhedron.centralAtom.colixAtom);
        } else {
            s = polyhedron.colix;
            f = polyhedron.scale;
        }
        boolean bl = false;
        if (C.renderPass2((short)s)) {
            bl = true;
        } else if (!this.g3d.setC(s)) {
            return false;
        }
        P3[] p3Array = polyhedron.vertices;
        if (f != 1.0f) {
            t3Array = new T3[p3Array.length];
            if (f < 0.0f) {
                object = V3.newV((T3)polyhedron.center);
                object.scale(-f - 1.0f);
                n = t3Array.length;
                while (--n >= 0) {
                    v32 = V3.newV((T3)p3Array[n]);
                    v32.add((T3)object);
                    t3Array[n] = v32;
                }
            } else {
                int n3 = t3Array.length;
                while (--n3 >= 0) {
                    V3 v33 = V3.newVsub((T3)p3Array[n3], (T3)polyhedron.center);
                    v33.scaleAdd2(f, (T3)v33, (T3)polyhedron.center);
                    t3Array[n3] = v33;
                }
            }
            p3Array = t3Array;
        }
        if (this.screens3f == null || this.screens3f.length < p3Array.length) {
            this.screens3f = new P3[p3Array.length];
            int n4 = p3Array.length;
            while (--n4 >= 0) {
                this.screens3f[n4] = new P3();
            }
        }
        t3Array = this.screens3f;
        object = polyhedron.triangles;
        n = p3Array.length;
        while (--n >= 0) {
            Object object2 = v32 = p3Array[n] instanceof Atom ? (Atom)p3Array[n] : null;
            if (v32 == null) {
                this.tm.transformPtScrT3((T3)p3Array[n], t3Array[n]);
            } else if (v32.isVisible(this.myVisibilityFlag)) {
                t3Array[n].set((float)v32.sX, (float)v32.sY, (float)v32.sZ);
            } else if (this.vibs && v32.hasVibration()) {
                this.scrVib = this.tm.transformPtVib((P3)v32, this.ms.vibrations[v32.i]);
                t3Array[n].set((float)this.scrVib.x, (float)this.scrVib.y, (float)this.scrVib.z);
            } else {
                this.tm.transformPt3f((T3)v32, (P3)t3Array[n]);
            }
            if (!this.showNumbers) continue;
            this.g3d.setC((short)4);
            this.g3d.drawStringNoSlab("" + n, null, (int)t3Array[n].x, (int)t3Array[n].y, (int)t3Array[n].z - 30, (short)0);
            this.g3d.setC(s);
        }
        this.isAll = this.drawEdges == 1 || this.bsSelected != null;
        this.frontOnly = this.drawEdges == 2;
        short[] sArray2 = polyhedron.getNormixes();
        if (!bl || this.g3d.setC(s)) {
            int n5 = ((V3)object).length;
            while (--n5 >= 0) {
                v3 = object[n5];
                try {
                    if (this.showNumbers && !this.g3d.setC((short)(Math.round(Math.random() * 10.0) + 5L))) continue;
                    this.g3d.fillTriangleTwoSided(sArray2[n5], (P3)t3Array[v3[0]], (P3)t3Array[v3[1]], (P3)t3Array[v3[2]]);
                }
                catch (Exception exception) {
                    System.out.println("PolyhedraRendererError");
                }
            }
        }
        if (this.bsSelected != null && this.bsSelected.get(n2)) {
            s = 23;
        } else if (polyhedron.colixEdge != 0) {
            s = polyhedron.colixEdge;
        }
        if (this.g3d.setC(C.getColixTranslucent3((short)s, (boolean)false, (float)0.0f))) {
            int n6 = ((V3)object).length;
            while (--n6 >= 0) {
                v3 = object[n6];
                this.drawEdges(sArray2[n6], (P3)t3Array[v3[0]], (P3)t3Array[v3[1]], (P3)t3Array[v3[2]], (int)(-v3[3]));
            }
        }
        return bl;
    }

    private void drawEdges(short s, P3 p3, P3 p32, P3 p33, int n) {
        if (this.isAll || this.frontOnly && this.vwr.gdata.isDirectedTowardsCamera(s)) {
            int n2;
            int n3 = n2 = this.g3d.isAntialiased() ? 6 : 3;
            if ((n & 1) == 1) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p32);
            }
            if ((n & 2) == 2) {
                this.g3d.fillCylinderBits((byte)3, n2, p32, p33);
            }
            if ((n & 4) == 4) {
                this.g3d.fillCylinderBits((byte)3, n2, p3, p33);
            }
        }
    }
}

