/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.common.Location;
import com.sparshui.server.GestureServer;
import com.sparshui.server.TouchPoint;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class InputDeviceConnection
implements Runnable {
    private GestureServer _gestureServer;
    private Socket _socket;
    private DataInputStream _in;
    private Map<Integer, TouchPoint> _touchPoints;
    private List<Integer> _flaggedids;

    public InputDeviceConnection(GestureServer gestureServer, Socket socket) throws IOException {
        this._gestureServer = gestureServer;
        this._socket = socket;
        this._in = new DataInputStream(socket.getInputStream());
        this._touchPoints = new Hashtable<Integer, TouchPoint>();
        this._flaggedids = new ArrayList<Integer>();
        this.startListening();
    }

    private void removeDeadTouchPoints() {
        for (int i = 0; i < this._flaggedids.size(); ++i) {
            Integer n = this._flaggedids.get(i);
            this._touchPoints.remove(n);
        }
        this._flaggedids.clear();
    }

    private void flagTouchPointForRemoval(int n) {
        this._flaggedids.add(n);
    }

    private void receiveData() {
        try {
            while (!this._socket.isInputShutdown()) {
                this.readTouchPoints();
            }
        }
        catch (IOException iOException) {
            System.out.println("[InputDeviceConnection] InputDevice Disconnected");
            this._gestureServer.notifyInputLost();
        }
    }

    private boolean readTouchPoints() throws IOException {
        int n;
        int n2 = this._in.readInt();
        if (n2 == 0) {
            this._in.close();
            return false;
        }
        if (n2 < 0) {
            n2 = -n2;
            n = this._in.readInt();
        } else {
            n = 13;
        }
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            bl |= this.readTouchPoint(n);
        }
        this.removeDeadTouchPoints();
        return bl;
    }

    private boolean readTouchPoint(int n) throws IOException {
        long l;
        int n2 = this._in.readInt();
        float f = this._in.readFloat();
        float f2 = this._in.readFloat();
        byte by = this._in.readByte();
        long l2 = l = n >= 21 ? this._in.readLong() : System.currentTimeMillis();
        if (n > 21) {
            this._in.read(new byte[n - 21]);
        }
        Location location = new Location(f, f2);
        boolean bl = this._gestureServer.processTouchPoint(this._touchPoints, n2, location, l, by);
        if (by == 1) {
            this.flagTouchPointForRemoval(n2);
        }
        return bl;
    }

    private void startListening() {
        Thread thread = new Thread(this);
        thread.setName("SparshUI Server->InputDeviceConnection on port 5947");
        thread.start();
    }

    @Override
    public void run() {
        this.receiveData();
    }
}

