/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.script.SV;
import org.jmol.util.C;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Normix;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Polyhedron {
    Map<String, Object> info;
    public String id;
    public P3 center;
    public Atom centralAtom;
    public P3[] vertices;
    public int[][] triangles;
    public int[][] faces;
    int nVertices;
    boolean collapsed;
    private BS bsFlat;
    private float distanceRef;
    private V3[] normals;
    private short[] normixes;
    public String smiles;
    public String smarts;
    public String polySmiles;
    private SymmetryInterface pointGroup;
    private SymmetryInterface pointGroupFamily;
    private Float volume;
    boolean visible = true;
    boolean isFullyLit;
    public boolean isValid = true;
    public short colixEdge = 0;
    public int visibilityFlags = 0;
    public short colix = (short)23;
    public int modelIndex = Integer.MIN_VALUE;
    private P3 offset;
    public float scale = 1.0f;

    Polyhedron() {
    }

    Polyhedron set(String string, int n, P3 p3, P3[] p3Array, int n2, int n3, int[][] nArray, int n4, int[][] nArray2, V3[] v3Array, BS bS, boolean bl, float f) {
        this.distanceRef = f;
        this.centralAtom = string == null ? (Atom)p3 : null;
        this.center = this.centralAtom == null ? p3 : null;
        this.modelIndex = this.centralAtom == null ? n : (int)this.centralAtom.mi;
        this.id = string;
        this.nVertices = n3;
        this.vertices = new P3[n2 + 1];
        this.normals = new V3[n4];
        this.faces = nArray2;
        this.bsFlat = bS;
        this.triangles = AU.newInt2(n4);
        int n5 = n2 + 1;
        while (--n5 >= 0) {
            this.vertices[n5] = p3Array[n5];
        }
        n5 = n4;
        while (--n5 >= 0) {
            this.normals[n5] = V3.newV(v3Array[n5]);
        }
        n5 = n4;
        while (--n5 >= 0) {
            this.triangles[n5] = nArray[n5];
        }
        this.collapsed = bl;
        return this;
    }

    Polyhedron setInfo(Map<String, SV> map, Atom[] atomArray) {
        try {
            T3 t3;
            this.collapsed = map.containsKey("collapsed");
            String string = this.id = map.containsKey("id") ? map.get("id").asString() : null;
            if (this.id == null) {
                this.centralAtom = atomArray[map.get((Object)"atomIndex").intValue];
            } else {
                this.center = P3.newP(SV.ptValue(map.get("center")));
                this.modelIndex = map.get((Object)"modelIndex").intValue;
                this.colix = C.getColixS(map.get("color").asString());
                this.colixEdge = C.getColixS(map.get("colorEdge").asString());
                if (map.containsKey("offset")) {
                    this.offset = P3.newP(SV.ptValue(map.get("offset")));
                }
                if (map.containsKey("scale")) {
                    this.scale = SV.fValue(map.get("scale"));
                }
            }
            Lst<SV> lst = map.get("vertices").getList();
            SV sV = map.get("vertexCount");
            if (sV == null) {
                this.nVertices = lst.size();
                this.vertices = new P3[this.nVertices + 1];
                this.vertices[this.nVertices] = SV.ptValue(map.get("ptRef"));
            } else {
                this.nVertices = sV.intValue;
                this.vertices = new P3[lst.size()];
                sV = map.get("r");
                if (sV != null) {
                    this.distanceRef = sV.asFloat();
                }
            }
            int n = lst.size();
            while (--n >= 0) {
                this.vertices[n] = SV.ptValue((SV)lst.get(n));
            }
            lst = map.get("elemNos").getList();
            n = this.nVertices;
            while (--n >= 0) {
                int n2 = ((SV)lst.get((int)n)).intValue;
                if (n2 <= 0) continue;
                t3 = new Point3fi();
                t3.setT(this.vertices[n]);
                t3.sD = (short)n2;
                this.vertices[n] = t3;
            }
            SV sV2 = map.get("faces");
            SV sV3 = map.get("triangles");
            if (sV3 == null) {
                sV3 = sV2;
            } else {
                this.faces = this.toInt2(sV2);
            }
            this.triangles = this.toInt2(sV3);
            this.normals = new V3[this.triangles.length];
            t3 = new V3();
            int n3 = this.triangles.length;
            while (--n3 >= 0) {
                this.normals[n3] = new V3();
                int[] nArray = this.triangles[n3];
                Measure.getNormalThroughPoints(this.vertices[nArray[0]], this.vertices[nArray[1]], this.vertices[nArray[2]], this.normals[n3], (V3)t3);
            }
            this.bsFlat = SV.getBitSet(map.get("bsFlat"), false);
        }
        catch (Exception exception) {
            return null;
        }
        return this;
    }

    private int[][] toInt2(SV sV) {
        Lst<SV> lst = sV.getList();
        int[][] nArray = AU.newInt2(lst.size());
        int n = nArray.length;
        while (--n >= 0) {
            Lst<SV> lst2 = ((SV)lst.get(n)).getList();
            nArray[n] = new int[lst2.size()];
            int[] nArray2 = nArray[n];
            int n2 = nArray2.length;
            while (--n2 >= 0) {
                nArray2[n2] = ((SV)lst2.get((int)n2)).intValue;
            }
        }
        return nArray;
    }

    Map<String, Object> getInfo(Viewer viewer, boolean bl) {
        P3 p3;
        int n;
        Object object;
        int n2;
        if (bl && this.info != null && !Logger.debugging) {
            return this.info;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n3 = n2 = this.id == null ? (int)this.centralAtom.mi : this.modelIndex;
        if (bl) {
            this.info = hashtable;
            if (this.id == null) {
                hashtable.put("center", P3.newP(this.centralAtom));
                hashtable.put("modelNumber", this.centralAtom.getModelNumber());
                hashtable.put("atomNumber", this.centralAtom.getAtomNumber());
                hashtable.put("atomName", this.centralAtom.getInfo());
                hashtable.put("element", this.centralAtom.getElementSymbol());
                object = viewer.ms.getInfo(this.centralAtom.mi, "Energy");
                if (object != null) {
                    hashtable.put("energy", object);
                }
            }
            hashtable.put("triangleCount", this.triangles.length);
            hashtable.put("volume", this.getVolume());
            object = new String[this.nVertices];
            n = this.nVertices;
            while (--n >= 0) {
                p3 = this.vertices[n];
                object[n] = p3 instanceof Node ? ((Node)((Object)p3)).getAtomName() : (p3 instanceof Point3fi ? Elements.elementSymbolFromNumber(((Point3fi)p3).sD) : "");
            }
            if (this.faces != null) {
                hashtable.put("faceCount", this.faces.length);
            }
            hashtable.put("atomNames", object);
            if (this.smarts != null) {
                hashtable.put("smarts", this.smarts);
            }
            if (this.smiles != null) {
                hashtable.put("smiles", this.smiles);
            }
            if (this.polySmiles != null) {
                hashtable.put("polySmiles", this.polySmiles);
            }
            if (this.pointGroup != null) {
                hashtable.put("pointGroup", this.pointGroup.getPointGroupName());
            }
            if (this.pointGroupFamily != null) {
                hashtable.put("pointGroupFamily", this.pointGroupFamily.getPointGroupName());
            }
        }
        if (this.id != null) {
            hashtable.put("id", this.id);
            hashtable.put("modelIndex", n2);
            hashtable.put("color", C.getHexCode(this.colix));
            hashtable.put("colorEdge", C.getHexCode(this.colixEdge == 0 ? this.colix : this.colixEdge));
            if (this.offset != null) {
                hashtable.put("offset", this.offset);
            }
            if (this.scale != 1.0f) {
                hashtable.put("scale", Float.valueOf(this.scale));
            }
        }
        if (this.faces != null) {
            hashtable.put("faces", this.faces);
        }
        if (!bl || Logger.debugging) {
            hashtable.put("bsFlat", this.bsFlat);
            if (this.collapsed) {
                hashtable.put("collapsed", this.collapsed);
            }
            if (this.distanceRef != 0.0f) {
                hashtable.put("r", Float.valueOf(this.distanceRef));
            }
            object = new P3[this.normals.length];
            n = ((Object[])object).length;
            while (--n >= 0) {
                object[n] = P3.newP(this.normals[n]);
            }
            hashtable.put("normals", object);
            hashtable.put("triangles", AU.arrayCopyII(this.triangles, this.triangles.length));
        }
        hashtable.put("vertexCount", this.nVertices);
        if (this.center == null) {
            hashtable.put("atomIndex", this.centralAtom.i);
        } else {
            hashtable.put("id", this.id);
            hashtable.put("center", P3.newP(this.center));
        }
        hashtable.put("vertices", AU.arrayCopyPt(this.vertices, bl ? this.nVertices : this.vertices.length));
        object = new int[this.nVertices];
        for (n = 0; n < this.nVertices; ++n) {
            p3 = this.vertices[n];
            object[n] = p3 instanceof Node ? ((Node)((Object)p3)).getElementNumber() : (p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2);
        }
        hashtable.put("elemNos", object);
        return hashtable;
    }

    String getSymmetry(Viewer viewer, boolean bl) {
        T3[] t3Array;
        if (this.id == null) {
            this.info = null;
            t3Array = viewer.getSmilesMatcher();
            try {
                String string;
                String string2 = string = this.distanceRef <= 0.0f ? null : "r=" + this.distanceRef;
                if (this.smarts == null) {
                    this.smarts = t3Array.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, null, 512, null);
                    this.smiles = t3Array.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 1, null);
                    this.polySmiles = t3Array.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 528385, string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.pointGroup == null && bl) {
            t3Array = new T3[this.nVertices];
            int n = t3Array.length;
            while (--n >= 0) {
                t3Array[n] = this.vertices[n];
            }
            this.pointGroup = viewer.ms.getSymTemp(true).setPointGroup(null, null, t3Array, null, false, viewer.getFloat(0x22000026), viewer.getFloat(0x22000028), true);
            n = t3Array.length;
            while (--n >= 0) {
                t3Array[n] = P3.newP(this.vertices[n]);
            }
            this.pointGroupFamily = viewer.ms.getSymTemp(true).setPointGroup(null, null, t3Array, null, false, viewer.getFloat(0x22000026), viewer.getFloat(0x22000028), true);
        }
        return (this.center == null ? this.centralAtom : this.center) + " " + this.pointGroup.getPointGroupName() + " " + "(" + this.pointGroupFamily.getPointGroupName() + ")";
    }

    private Float getVolume() {
        if (this.volume != null) {
            return this.volume;
        }
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        float f = 0.0f;
        if (this.bsFlat.cardinality() < this.triangles.length) {
            int n = this.triangles.length;
            while (--n >= 0) {
                int[] nArray = this.triangles[n];
                f += this.triangleVolume(nArray[0], nArray[1], nArray[2], v3, v32, v33);
            }
        }
        return Float.valueOf(f / 6.0f);
    }

    private float triangleVolume(int n, int n2, int n3, V3 v3, V3 v32, V3 v33) {
        v3.setT(this.vertices[n]);
        v32.setT(this.vertices[n2]);
        v33.cross(v3, v32);
        v32.setT(this.vertices[n3]);
        return v32.dot(v33);
    }

    String getState(Viewer viewer) {
        String string = this.id == null ? "({" + this.centralAtom.i + "})" : "ID " + Escape.e(this.id);
        return "  polyhedron @{" + Escape.e(this.getInfo(viewer, false)) + "} " + (this.isFullyLit ? " fullyLit" : "") + ";" + (this.visible ? "" : "polyhedra " + string + " off;") + "\n";
    }

    public void move(M4 m4) {
        int n;
        this.info = null;
        for (n = 0; n < this.nVertices; ++n) {
            P3 p3 = this.vertices[n];
            if (p3 instanceof Atom) {
                p3 = this.vertices[n] = P3.newP(p3);
            }
            m4.rotTrans(p3);
        }
        n = this.normals.length;
        while (--n >= 0) {
            m4.rotate(this.normals[n]);
        }
        this.normixes = null;
    }

    public short[] getNormixes() {
        if (this.normixes == null) {
            this.normixes = new short[this.normals.length];
            BS bS = new BS();
            int n = this.normals.length;
            while (--n >= 0) {
                this.normixes[n] = this.bsFlat.get(n) ? Normix.get2SidedNormix(this.normals[n], bS) : Normix.getNormixV(this.normals[n], bS);
            }
        }
        return this.normixes;
    }

    void setOffset(P3 p3) {
        if (this.center == null) {
            return;
        }
        P3 p32 = P3.newP(p3);
        if (this.offset != null) {
            p3.sub(this.offset);
        }
        this.offset = p32;
        this.center.add(p3);
        int n = this.vertices.length;
        while (--n >= 0) {
            this.vertices[n].add(p3);
        }
    }
}

