/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.ClientProtocol;
import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;
import com.sparshui.server.TouchPoint;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javajs.util.Lst;

public class ServerToClientProtocol
extends ClientProtocol {
    private DataOutputStream _bufferOut;
    private ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

    public ServerToClientProtocol(Socket socket) throws IOException {
        super(socket);
        this._bufferOut = new DataOutputStream(this._buffer);
    }

    public Lst<GestureType> getGestures(int n) throws IOException {
        Lst<GestureType> lst = new Lst<GestureType>();
        this._bufferOut.writeInt(n);
        this.sendBuffer(2);
        for (int i = this._in.readInt(); i > 0; i -= 4) {
            int n2 = this._in.readInt();
            if (n2 < 0) {
                byte[] byArray = new byte[-n2];
                this._in.read(byArray);
                lst.addLast(new GestureType(Converter.byteArrayToString(byArray)));
                i -= byArray.length;
                continue;
            }
            lst.addLast(new GestureType(n2));
        }
        return lst;
    }

    public int getGroupID(TouchPoint touchPoint) throws IOException {
        byte[] byArray = new byte[4];
        Converter.floatToByteArray(byArray, 0, touchPoint.getLocation().getX());
        this._bufferOut.write(byArray);
        Converter.floatToByteArray(byArray, 0, touchPoint.getLocation().getY());
        this._bufferOut.write(byArray);
        this.sendBuffer(1);
        int n = this._in.readInt();
        return n;
    }

    public void processEvents(int n, Lst<Event> lst) throws IOException {
        for (int i = 0; i < lst.size(); ++i) {
            this._bufferOut.writeInt(n);
            this._bufferOut.write(((Event)lst.get(i)).serialize());
            this.sendBuffer(0);
        }
    }

    public void processError(int n) throws IOException {
        this._bufferOut.writeInt(-1);
        this._bufferOut.writeInt(n);
        this.sendBuffer(0);
    }

    private void sendBuffer(int n) throws IOException {
        this._out.writeByte((byte)n);
        this._out.writeInt(this._buffer.size());
        this._out.write(this._buffer.toByteArray());
        this._buffer.reset();
    }
}

