/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.script.ScriptParallelProcessor;
import org.jmol.script.ScriptProcess;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;

public class ScriptProcessRunnable
implements Runnable {
    private final ScriptParallelProcessor parallelProcessor;
    private final ScriptProcess process;
    private Object processLock;
    private ShapeManager shapeManager;

    public ScriptProcessRunnable(ScriptParallelProcessor scriptParallelProcessor, ScriptProcess scriptProcess, Object object, ShapeManager shapeManager) {
        this.parallelProcessor = scriptParallelProcessor;
        this.process = scriptProcess;
        this.processLock = object;
        this.shapeManager = shapeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.parallelProcessor.error == null) {
                if (Logger.debugging) {
                    Logger.debug("Running process " + this.process.processName + " " + this.process.context.pc + " - " + (this.process.context.pcEnd - 1));
                }
                this.parallelProcessor.eval(this.process.context, this.shapeManager);
                if (Logger.debugging) {
                    Logger.debug("Process " + this.process.processName + " complete");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            this.parallelProcessor.clearShapeManager(error);
        }
        finally {
            Object object = this.processLock;
            synchronized (object) {
                --this.parallelProcessor.counter;
                this.processLock.notifyAll();
            }
        }
    }
}

