/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Point3fi;

public class BoxInfo {
    public final P3 bbCorner0 = new P3();
    public final P3 bbCorner1 = new P3();
    private final P3 bbCenter = new P3();
    private final V3 bbVector = new V3();
    private final Point3fi[] bbVertices = new Point3fi[8];
    private boolean isScaleSet;
    private float margin;
    public static char[] bbcageTickEdges = new char[]{'z', '\u0000', '\u0000', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static char[] uccageTickEdges = new char[]{'z', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static final byte[] edges = new byte[]{0, 1, 0, 2, 0, 4, 1, 3, 1, 5, 2, 3, 2, 6, 3, 7, 4, 5, 4, 6, 5, 7, 6, 7};
    public static final P3[] unitCubePoints = new P3[]{P3.new3(0.0f, 0.0f, 0.0f), P3.new3(0.0f, 0.0f, 1.0f), P3.new3(0.0f, 1.0f, 0.0f), P3.new3(0.0f, 1.0f, 1.0f), P3.new3(1.0f, 0.0f, 0.0f), P3.new3(1.0f, 0.0f, 1.0f), P3.new3(1.0f, 1.0f, 0.0f), P3.new3(1.0f, 1.0f, 1.0f)};
    private static P3i[] facePoints = new P3i[]{P3i.new3(4, 0, 6), P3i.new3(4, 6, 5), P3i.new3(5, 7, 1), P3i.new3(1, 3, 0), P3i.new3(6, 2, 7), P3i.new3(1, 0, 5)};
    public static final int[] toCanonical = new int[]{0, 3, 4, 7, 1, 2, 5, 6};
    protected static final P3i[] cubeVertexOffsets = new P3i[]{P3i.new3(0, 0, 0), P3i.new3(1, 0, 0), P3i.new3(1, 0, 1), P3i.new3(0, 0, 1), P3i.new3(0, 1, 0), P3i.new3(1, 1, 0), P3i.new3(1, 1, 1), P3i.new3(0, 1, 1)};
    private static final P3[] unitBboxPoints = new P3[8];

    public BoxInfo() {
        int n = 8;
        while (--n >= 0) {
            this.bbVertices[n] = new Point3fi();
        }
        for (n = 0; n < 8; ++n) {
            BoxInfo.unitBboxPoints[n] = P3.new3(-1.0f, -1.0f, -1.0f);
            unitBboxPoints[n].scaleAdd2(2.0f, unitCubePoints[n], unitBboxPoints[n]);
        }
        this.reset();
    }

    public Lst<Object> intersectPlane(ModelSet modelSet, P4 p4, float f, int n) {
        Lst<Object> lst = new Lst<Object>();
        lst.addLast(this.getCanonicalCopy(f));
        return modelSet.intersectPlane(p4, lst, n);
    }

    public P3[] getCanonicalCopy(float f) {
        return BoxInfo.getCanonicalCopy(this.bbVertices, f);
    }

    public static final P3[] getCanonicalCopy(P3[] p3Array, float f) {
        P3[] p3Array2 = new P3[8];
        for (int i = 0; i < 8; ++i) {
            p3Array2[BoxInfo.toCanonical[i]] = P3.newP(p3Array[i]);
        }
        BoxInfo.scaleBox(p3Array2, f);
        return p3Array2;
    }

    public static void scaleBox(P3[] p3Array, float f) {
        int n;
        if (f == 0.0f || f == 1.0f) {
            return;
        }
        P3 p3 = new P3();
        V3 v3 = new V3();
        for (n = 0; n < 8; ++n) {
            p3.add(p3Array[n]);
        }
        p3.scale(0.125f);
        for (n = 0; n < 8; ++n) {
            v3.sub2(p3Array[n], p3);
            v3.scale(f);
            p3Array[n].add2(p3, v3);
        }
    }

    public static P4[] getFacesFromCriticalPoints(P3[] p3Array) {
        P4[] p4Array = new P4[6];
        V3 v3 = new V3();
        V3 v32 = new V3();
        P3 p3 = new P3();
        P3 p32 = new P3();
        P3 p33 = new P3();
        P3[] p3Array2 = BoxInfo.getVerticesFromCriticalPoints(p3Array);
        for (int i = 0; i < 6; ++i) {
            p3.setT(p3Array2[BoxInfo.facePoints[i].x]);
            p32.setT(p3Array2[BoxInfo.facePoints[i].y]);
            p33.setT(p3Array2[BoxInfo.facePoints[i].z]);
            p4Array[i] = Measure.getPlaneThroughPoints(p3, p32, p33, v3, v32, new P4());
        }
        return p4Array;
    }

    public static P3[] getVerticesFromCriticalPoints(P3[] p3Array) {
        P3[] p3Array2 = new P3[8];
        for (int i = 0; i < 8; ++i) {
            p3Array2[i] = P3.newP(p3Array[0]);
            if ((i & 1) == 1) {
                p3Array2[i].add(p3Array[1]);
            }
            if ((i & 2) == 2) {
                p3Array2[i].add(p3Array[2]);
            }
            if ((i & 4) != 4) continue;
            p3Array2[i].add(p3Array[3]);
        }
        return p3Array2;
    }

    public static final P3[] getUnitCellPoints(P3[] p3Array, T3 t3) {
        P3 p3 = P3.newP(p3Array[0]);
        P3 p32 = P3.newP(p3Array[1]);
        P3 p33 = P3.newP(p3Array[2]);
        P3 p34 = P3.newP(p3Array[4]);
        p32.sub(p3);
        p33.sub(p3);
        p34.sub(p3);
        if (t3 != null) {
            p3.add(t3);
        }
        return new P3[]{p3, p32, p33, p34};
    }

    public P3 getBoundBoxCenter() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbCenter;
    }

    public V3 getBoundBoxCornerVector() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbVector;
    }

    public P3[] getBoundBoxPoints(boolean bl) {
        P3[] p3Array;
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        if (bl) {
            P3[] p3Array2 = new P3[4];
            p3Array2[0] = this.bbCenter;
            p3Array2[1] = P3.newP(this.bbVector);
            p3Array2[2] = this.bbCorner0;
            p3Array = p3Array2;
            p3Array2[3] = this.bbCorner1;
        } else {
            P3[] p3Array3 = new P3[2];
            p3Array3[0] = this.bbCorner0;
            p3Array = p3Array3;
            p3Array3[1] = this.bbCorner1;
        }
        return p3Array;
    }

    public Point3fi[] getBoundBoxVertices() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbVertices;
    }

    public void setBoundBoxFromCriticalPoints(T3[] t3Array) {
        P3 p3 = P3.newP(t3Array[0]);
        P3 p32 = new P3();
        for (int i = 0; i < 4; ++i) {
            p32.add(t3Array[i]);
        }
        this.setBoundBox(p3, p32, true, 1.0f);
    }

    public void setBoundBox(T3 t3, T3 t32, boolean bl, float f) {
        if (t3 != null) {
            if (f == 0.0f) {
                return;
            }
            if (bl) {
                if (t3.distance(t32) == 0.0f) {
                    return;
                }
                this.bbCorner0.set(Math.min(t3.x, t32.x), Math.min(t3.y, t32.y), Math.min(t3.z, t32.z));
                this.bbCorner1.set(Math.max(t3.x, t32.x), Math.max(t3.y, t32.y), Math.max(t3.z, t32.z));
            } else {
                if (t32.x == 0.0f || t32.y == 0.0f && t32.z == 0.0f) {
                    return;
                }
                this.bbCorner0.set(t3.x - t32.x, t3.y - t32.y, t3.z - t32.z);
                this.bbCorner1.set(t3.x + t32.x, t3.y + t32.y, t3.z + t32.z);
            }
        }
        this.setBbcage(f);
    }

    public void reset() {
        this.isScaleSet = false;
        this.bbCorner0.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.bbCorner1.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    public void setMargin(float f) {
        this.margin = f;
    }

    public void addBoundBoxPoint(T3 t3) {
        this.isScaleSet = false;
        BoxInfo.addPoint(t3, this.bbCorner0, this.bbCorner1, this.margin);
    }

    public static void addPoint(T3 t3, T3 t32, T3 t33, float f) {
        if (t3.x - f < t32.x) {
            t32.x = t3.x - f;
        }
        if (t3.x + f > t33.x) {
            t33.x = t3.x + f;
        }
        if (t3.y - f < t32.y) {
            t32.y = t3.y - f;
        }
        if (t3.y + f > t33.y) {
            t33.y = t3.y + f;
        }
        if (t3.z - f < t32.z) {
            t32.z = t3.z - f;
        }
        if (t3.z + f > t33.z) {
            t33.z = t3.z + f;
        }
    }

    public static void addPointXYZ(float f, float f2, float f3, P3 p3, P3 p32, float f4) {
        if (f - f4 < p3.x) {
            p3.x = f - f4;
        }
        if (f + f4 > p32.x) {
            p32.x = f + f4;
        }
        if (f2 - f4 < p3.y) {
            p3.y = f2 - f4;
        }
        if (f2 + f4 > p32.y) {
            p32.y = f2 + f4;
        }
        if (f3 - f4 < p3.z) {
            p3.z = f3 - f4;
        }
        if (f3 + f4 > p32.z) {
            p32.z = f3 + f4;
        }
    }

    public void setBbcage(float f) {
        this.isScaleSet = true;
        this.bbCenter.add2(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5f);
        this.bbVector.sub2(this.bbCorner1, this.bbCenter);
        if (f > 0.0f) {
            this.bbVector.scale(f);
        } else {
            this.bbVector.x -= f / 2.0f;
            this.bbVector.y -= f / 2.0f;
            this.bbVector.z -= f / 2.0f;
        }
        int n = 8;
        while (--n >= 0) {
            Point3fi point3fi = this.bbVertices[n];
            point3fi.setT(unitBboxPoints[n]);
            point3fi.x *= this.bbVector.x;
            point3fi.y *= this.bbVector.y;
            point3fi.z *= this.bbVector.z;
            point3fi.add(this.bbCenter);
        }
        this.bbCorner0.setT(this.bbVertices[0]);
        this.bbCorner1.setT(this.bbVertices[7]);
    }

    public boolean isWithin(P3 p3) {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return p3.x >= this.bbCorner0.x && p3.x <= this.bbCorner1.x && p3.y >= this.bbCorner0.y && p3.y <= this.bbCorner1.y && p3.z >= this.bbCorner0.z && p3.z <= this.bbCorner1.z;
    }

    public float getMaxDim() {
        return this.bbVector.length() * 2.0f;
    }
}

