/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javajs.util.PT;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.WebPanel;

class ScriptButtons
extends WebPanel {
    ScriptButtons(Viewer viewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        super(viewer, jFileChooser, webPanelArray, n);
        this.panelName = "script_btn";
        this.listLabel = GT._("These names will be used for button labels");
    }

    @Override
    JPanel appletParamPanel() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(WebExport.getScriptButtonPercent(), 20, 100, 5);
        this.appletSizeSpinnerP = new JSpinner(spinnerNumberModel);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(GT._("% of window for applet width:")));
        jPanel.add(this.appletSizeSpinnerP);
        return jPanel;
    }

    @Override
    String fixHtml(String string) {
        int n = ((SpinnerNumberModel)this.appletSizeSpinnerP.getModel()).getNumber().intValue();
        double d = 99.5 - (double)n;
        int n2 = 100;
        int n3 = this.getInstanceList().getModel().getSize();
        if (!this.allSelectedWidgets().isEmpty()) {
            n2 = 85;
        }
        string = PT.rep(string, "@WIDTHPERCENT@", "" + n);
        string = PT.rep(string, "@LEFTPERCENT@", "" + d);
        string = PT.rep(string, "@NBUTTONS@", "" + n3);
        string = PT.rep(string, "@HEIGHT@", "" + n2);
        return string;
    }

    @Override
    String getAppletDefs(int n, String string, StringBuilder stringBuilder, JmolInstance jmolInstance) {
        String string2 = jmolInstance.name;
        String string3 = jmolInstance.javaname;
        String string4 = "";
        int n2 = 0;
        if (!jmolInstance.whichWidgets.isEmpty()) {
            string4 = string4 + "<table border = \"0\" width=\"100%\"><tbody><tr>";
            for (int i = 0; i < this.nWidgets; ++i) {
                if (!jmolInstance.whichWidgets.get(i)) continue;
                if (n2 == 3) {
                    string4 = string4 + "</tr><tr>";
                    n2 = 0;
                }
                string4 = string4 + "<td>" + this.theWidgets.widgetList[i].getJavaScript(0, jmolInstance) + "</td>";
                ++n2;
            }
            string4 = string4 + "</tr></tbody></table>";
        }
        if (n == 0) {
            string = PT.rep(string, "@APPLETNAME0@", GT.escapeHTML(string3));
        }
        if (this.useAppletJS) {
            String string5 = "info for " + string2;
            stringBuilder.append("\naddAppletButton(" + n + ",'" + string3 + "',\"" + string2 + "\",\"" + string5 + "\");");
        } else {
            String string6 = this.htmlAppletTemplate;
            string6 = PT.rep(string6, "@APPLETNAME0@", GT.escapeHTML(string3));
            string6 = PT.rep(string6, "@NAME@", GT.escapeHTML(string2));
            string6 = PT.rep(string6, "@LABEL@", GT.escapeHTML(string2));
            string6 = PT.rep(string6, "@I@", "" + n);
            string6 = PT.rep(string6, "@WIDGETSTR@", string4);
            stringBuilder.append(string6);
        }
        return string;
    }
}

