/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.Lst;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.UFFAngleCalc;
import org.jmol.minimize.forcefield.UFFDistanceCalc;
import org.jmol.minimize.forcefield.UFFOOPCalc;
import org.jmol.minimize.forcefield.UFFTorsionCalc;
import org.jmol.minimize.forcefield.UFFVDWCalc;

class CalculationsUFF
extends Calculations {
    static final double KCAL332 = 1390.2842991599998;
    static final double KCAL644 = 2696.8016159999997;
    static final double KCAL6 = 25.1208;
    static final double KCAL22 = 92.1096;
    static final double KCAL44 = 184.2192;
    static final int PAR_R = 0;
    static final int PAR_THETA = 1;
    static final int PAR_X = 2;
    static final int PAR_D = 3;
    static final int PAR_ZETA = 4;
    static final int PAR_Z = 5;
    static final int PAR_V = 6;
    static final int PAR_U = 7;
    static final int PAR_XI = 8;
    static final int PAR_HARD = 9;
    static final int PAR_RADIUS = 10;
    Calculation bondCalc;
    Calculation angleCalc;
    Calculation torsionCalc;
    Calculation oopCalc;
    Calculation vdwCalc;

    CalculationsUFF(ForceField forceField, Map<Object, Object> map, MinAtom[] minAtomArray, MinBond[] minBondArray, MinAngle[] minAngleArray, MinTorsion[] minTorsionArray, MinPosition[] minPositionArray, Lst<Object[]> lst) {
        super(forceField, minAtomArray, minBondArray, minAngleArray, minTorsionArray, minPositionArray, lst);
        this.ffParams = map;
        this.bondCalc = new UFFDistanceCalc().set(this);
        this.angleCalc = new UFFAngleCalc().set(this);
        this.torsionCalc = new UFFTorsionCalc().set(this);
        this.oopCalc = new UFFOOPCalc().set(this);
        this.vdwCalc = new UFFVDWCalc().set(this);
    }

    @Override
    String getUnits() {
        return "kJ";
    }

    @Override
    boolean setupCalculations() {
        Calculation calculation = new UFFDistanceCalc().set(this);
        Lst lst = this.calculations[0] = new Lst();
        for (int i = 0; i < this.bondCount; ++i) {
            MinBond minBond = this.minBonds[i];
            double d = minBond.order;
            if (minBond.isAromatic) {
                d = 1.5;
            }
            if (minBond.isAmide) {
                d = 1.41;
            }
            calculation.setData((Lst<Object[]>)lst, minBond.data[0], minBond.data[1], d);
        }
        lst = this.calculations[1] = new Lst();
        UFFAngleCalc uFFAngleCalc = (UFFAngleCalc)new UFFAngleCalc().set(this);
        int n = this.minAngles.length;
        while (--n >= 0) {
            uFFAngleCalc.setData((Lst<Object[]>)lst, this.minAngles[n].data);
        }
        lst = this.calculations[3] = new Lst();
        UFFTorsionCalc uFFTorsionCalc = (UFFTorsionCalc)new UFFTorsionCalc().set(this);
        int n2 = this.minTorsions.length;
        while (--n2 >= 0) {
            uFFTorsionCalc.setData((Lst<Object[]>)lst, this.minTorsions[n2].data);
        }
        lst = this.calculations[4] = new Lst();
        Calculation calculation2 = new UFFOOPCalc().set(this);
        for (int i = 0; i < this.ac; ++i) {
            int n3;
            MinAtom minAtom = this.minAtoms[i];
            if (minAtom.nBonds != 3 || !CalculationsUFF.isInvertible(n3 = minAtom.atom.getElementNumber())) continue;
            calculation2.setData((Lst<Object[]>)lst, i, n3, 0.0);
        }
        this.calculations[5] = new Lst();
        this.pairSearch((Lst<Object[]>)this.calculations[5], new UFFVDWCalc().set(this), null, null);
        return true;
    }

    private static boolean isInvertible(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 33: 
            case 51: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    static double calculateR0(double d, double d2, double d3, double d4, double d5) {
        double d6 = -0.1332 * (d + d2) * Math.log(d5);
        double d7 = Math.sqrt(d3) - Math.sqrt(d4);
        double d8 = d * d2 * d7 * d7 / (d3 * d + d4 * d2);
        return d + d2 + d6 - d8;
    }

    @Override
    double compute(int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                return this.bondCalc.compute(objectArray);
            }
            case 1: {
                return this.angleCalc.compute(objectArray);
            }
            case 3: {
                return this.torsionCalc.compute(objectArray);
            }
            case 4: {
                return this.oopCalc.compute(objectArray);
            }
            case 5: {
                return this.vdwCalc.compute(objectArray);
            }
        }
        return 0.0;
    }

    @Override
    String getDebugHeader(int n) {
        switch (n) {
            case -1: {
                return "Universal Force Field -- Rappe, A. K., et. al.; J. Am. Chem. Soc. (1992) 114(25) p. 10024-10035\n";
            }
        }
        return this.getDebugHeader2(n);
    }

    @Override
    protected Object getParameterObj(MinObject minObject) {
        return null;
    }
}

