/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import javajs.util.AU;
import javajs.util.Lst;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.awt.Platform;
import org.jmol.console.GenericConsole;
import org.jmol.console.JmolButton;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.viewer.FileManager;

public abstract class JmolConsole
extends GenericConsole
implements ActionListener,
WindowListener {
    protected JFrame vwrFrame;
    protected Container externalContainer;
    protected ScriptEditor scriptEditor;

    @Override
    public void dispose() {
        if (this.externalContainer instanceof Window) {
            ((Window)this.externalContainer).dispose();
        } else {
            this.externalContainer.setVisible(false);
        }
    }

    protected Container getPane() {
        return this.externalContainer instanceof JFrame ? ((JFrame)this.externalContainer).getContentPane() : this.externalContainer;
    }

    @Override
    protected void setTitle() {
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setTitle(JmolConsole.getLabel("title"));
        } else if (this.externalContainer instanceof JDialog) {
            ((JDialog)this.externalContainer).setTitle(JmolConsole.getLabel("title"));
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.externalContainer.setVisible(bl);
    }

    @Override
    protected JmolAbstractButton setButton(String string) {
        return this.addButton(new JmolButton(JmolConsole.getLabel(string)), string);
    }

    @Override
    protected void updateLabels() {
        labels = null;
        boolean bl = GT.setDoTranslate(true);
        this.setViewer(this.vwr);
        this.defaultMessage = JmolConsole.getLabel("default");
        JmolConsole.setAbstractButtonLabels(this.menuMap, labels);
        this.setTitle();
        if (this.label1 != null) {
            this.label1.setText(JmolConsole.getLabel("label1"));
        }
        GT.setDoTranslate(bl);
    }

    @Override
    public JmolScriptEditorInterface getScriptEditor() {
        return this.scriptEditor == null ? (this.scriptEditor = new ScriptEditor(this.vwr, this.vwrFrame, this)) : this.scriptEditor;
    }

    @Override
    protected String nextFileName(String string, int n) {
        Object object;
        String string2 = FileManager.getLocalPathForWritingFile(this.vwr, string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
        }
        if (string2.indexOf("/") >= 0) {
            if (string3.equals(string2)) {
                string = "";
            } else {
                object = new File(string2);
                string2 = ((File)object).getParent();
                string = ((File)object).getName();
            }
        }
        object = new FileChecker(string);
        try {
            new File(string2).list((FilenameFilter)object);
            return string3 + ((FileChecker)object).getFile(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doAction(actionEvent.getSource());
    }

    @Override
    protected boolean isMenuItem(Object object) {
        return object instanceof JMenuItem;
    }

    protected void addWindowListener() {
        Window window = Platform.getWindow(this.externalContainer);
        if (window != null) {
            window.addWindowListener(this);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.updateFontSize();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public Object newJMenu(String string) {
        return new KeyJMenu(string, JmolConsole.getLabel(string), null);
    }

    @Override
    public Object newJMenuItem(String string) {
        return new KeyJMenuItem(string, JmolConsole.getLabel(string), null);
    }

    public void updateFontSize() {
    }

    private class FileChecker
    implements FilenameFilter {
        private String stub;
        private Lst<String> v = new Lst();

        protected FileChecker(String string) {
            this.stub = string.toLowerCase();
        }

        @Override
        public boolean accept(File file, String string) {
            if (!string.toLowerCase().startsWith(this.stub)) {
                return false;
            }
            this.v.addLast(string);
            return true;
        }

        protected String getFile(int n) {
            return AU.sortedItem(this.v, n);
        }
    }
}

