/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.script.T;

public class ContactPair {
    public float[] radii = new float[2];
    public float[] vdws = new float[2];
    public Atom[] myAtoms = new Atom[2];
    public P3 pt;
    public double volume = 0.0;
    public double vdwVolume = 0.0;
    public float score;
    public float d;
    public float chord;
    public int contactType;
    public float xVdwClash = Float.NaN;
    private int oldType = 0;

    public ContactPair(Atom[] atomArray, int n, int n2, float f, float f2, float f3, float f4) {
        this.radii[0] = f;
        this.radii[1] = f2;
        this.vdws[0] = f3;
        this.vdws[1] = f4;
        this.myAtoms[0] = atomArray[n];
        this.myAtoms[1] = atomArray[n2];
        V3 v3 = V3.newVsub(this.myAtoms[1], this.myAtoms[0]);
        this.d = v3.length();
        float f5 = (f - f2 + this.d) / (2.0f * this.d);
        this.pt = new P3();
        this.pt.scaleAdd2(f5, v3, this.myAtoms[0]);
        this.score = this.d - f3 - f4;
        int n3 = this.contactType = this.score < 0.0f ? 1073741881 : 1648363544;
        if (this.score < 0.0f) {
            this.radii[0] = f = f3;
            this.radii[1] = f2 = f4;
        }
        this.getVolume();
    }

    private void getVolume() {
        double d = this.radii[0];
        double d2 = this.radii[1];
        this.volume = d + d2 - (double)this.d;
        this.volume *= Math.PI * this.volume * ((double)(this.d * this.d) + (double)(2.0f * this.d) * d2 - 3.0 * d2 * d2 + (double)(2.0f * this.d) * d + 6.0 * d2 * d - 3.0 * d * d) / 12.0 / (double)this.d;
        this.vdwVolume = this.score > 0.0f ? -this.volume : this.volume;
        double d3 = (double)(this.d * this.d) - d2 * d2 + d * d;
        this.chord = (float)Math.sqrt((double)(4.0f * this.d * this.d) * d * d - d3 * d3) / this.d;
    }

    public boolean setForVdwClash(boolean bl) {
        if (Float.isNaN(this.xVdwClash)) {
            return false;
        }
        if (bl) {
            this.oldType = this.contactType;
            this.contactType = 1648363544;
            this.radii[0] = this.vdws[0] + this.xVdwClash;
            this.radii[1] = this.vdws[1] + this.xVdwClash;
        } else {
            this.contactType = this.oldType;
            this.radii[0] = this.vdws[0];
            this.radii[1] = this.vdws[1];
        }
        this.getVolume();
        return true;
    }

    public void switchAtoms() {
        Atom atom = this.myAtoms[0];
        this.myAtoms[0] = this.myAtoms[1];
        this.myAtoms[1] = atom;
        float f = this.radii[0];
        this.radii[0] = this.radii[1];
        this.radii[1] = f;
        f = this.vdws[0];
        this.vdws[0] = this.vdws[1];
        this.vdws[1] = f;
    }

    public String toString() {
        return "type=" + T.nameOf(this.contactType) + " " + this.myAtoms[0] + " " + this.myAtoms[1] + " dAB=" + this.d + " score=" + this.score + " chord=" + this.chord + " volume=" + this.volume;
    }
}

