/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.Execute;
import com.oracle.truffle.api.interop.ForeignObjectAccessHeadNode;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.impl.ReadOnlyArrayList;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

public final class ForeignAccess {
    private final Factory factory;
    private final Thread initThread;

    private ForeignAccess(Factory faf) {
        this.factory = faf;
        this.initThread = Thread.currentThread();
        CompilerAsserts.neverPartOfCompilation();
    }

    public static ForeignAccess create(Class<? extends TruffleObject> baseClass, Factory10 factory) {
        if (baseClass == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(new DelegatingFactory(baseClass, factory));
    }

    public static ForeignAccess create(Factory factory) {
        return new ForeignAccess(factory);
    }

    public static Object execute(Node foreignNode, VirtualFrame frame, TruffleObject receiver, Object ... arguments) {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)foreignNode;
        return fn.executeForeign(frame, receiver, arguments);
    }

    public static List<Object> getArguments(Frame frame) {
        Object[] arr = frame.getArguments();
        return ReadOnlyArrayList.asList(arr, 1, arr.length);
    }

    public static TruffleObject getReceiver(Frame frame) {
        return (TruffleObject)frame.getArguments()[0];
    }

    public String toString() {
        Object f = this.factory instanceof DelegatingFactory ? ((DelegatingFactory)this.factory).factory : this.factory;
        return "ForeignAccess[" + f.getClass().getName() + "]";
    }

    private void checkThread() {
        assert (this.initThread == Thread.currentThread());
    }

    CallTarget access(Message message) {
        this.checkThread();
        return this.factory.accessMessage(message);
    }

    boolean canHandle(TruffleObject receiver) {
        this.checkThread();
        return this.factory.canHandle(receiver);
    }

    private static class DelegatingFactory
    implements Factory {
        private final Class<?> baseClass;
        private final Factory10 factory;

        public DelegatingFactory(Class<?> baseClass, Factory10 factory) {
            this.baseClass = baseClass;
            this.factory = factory;
        }

        @Override
        public boolean canHandle(TruffleObject obj) {
            if (this.baseClass == null) {
                return ((Factory)((Object)this.factory)).canHandle(obj);
            }
            return this.baseClass.isInstance(obj);
        }

        @Override
        public CallTarget accessMessage(Message msg) {
            if (msg instanceof KnownMessage) {
                switch (msg.hashCode()) {
                    case 423430: {
                        return this.factory.accessExecute(((Execute)msg).getArity());
                    }
                    case 423429: {
                        return this.factory.accessInvoke(((Execute)msg).getArity());
                    }
                    case 423428: {
                        return this.factory.accessNew(((Execute)msg).getArity());
                    }
                    case 423432: {
                        return this.factory.accessGetSize();
                    }
                    case 423433: {
                        return this.factory.accessHasSize();
                    }
                    case 423434: {
                        return this.factory.accessIsBoxed();
                    }
                    case 423435: {
                        return this.factory.accessIsExecutable();
                    }
                    case 423436: {
                        return this.factory.accessIsNull();
                    }
                    case 423438: {
                        return this.factory.accessRead();
                    }
                    case 423437: {
                        return this.factory.accessUnbox();
                    }
                    case 423431: {
                        return this.factory.accessWrite();
                    }
                }
            }
            return this.factory.accessMessage(msg);
        }
    }

    public static interface Factory10 {
        public CallTarget accessIsNull();

        public CallTarget accessIsExecutable();

        public CallTarget accessIsBoxed();

        public CallTarget accessHasSize();

        public CallTarget accessGetSize();

        public CallTarget accessUnbox();

        public CallTarget accessRead();

        public CallTarget accessWrite();

        public CallTarget accessExecute(int var1);

        public CallTarget accessInvoke(int var1);

        public CallTarget accessNew(int var1);

        public CallTarget accessMessage(Message var1);
    }

    public static interface Factory {
        public boolean canHandle(TruffleObject var1);

        public CallTarget accessMessage(Message var1);
    }
}

